/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid.actions;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import scouter.client.cubrid.ActiveDbInfo;
import scouter.client.cubrid.CubridSingleItem;
import scouter.client.popup.CalendarDialog;
import scouter.client.util.UIUtil;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

public class AddShortPeriodCalendarDialog {
    private final Display display;
    private final IAddSingleShortPeriodDialog callback;
    private final int serverId;
    Combo dbListCombo;
    Combo counterCombo;

    public AddShortPeriodCalendarDialog(Display display, int serverId, IAddSingleShortPeriodDialog callback) {
        this.display = display;
        this.callback = callback;
        this.serverId = serverId;
    }

    public void show(Point p, long stime, long etime) {
        if (p != null) {
            this.show((int)p.getX(), (int)p.getY() + 10, stime, etime);
        }
    }

    public void show(Point p, long stime) {
        if (p != null) {
            this.showOnlyStartTime((int)p.getX(), (int)p.getY() + 10, stime);
        }
    }

    public void show(long stime, long etime) {
        this.show(UIUtil.getMousePosition(), stime, etime);
    }

    public void show(long stime) {
        this.show(UIUtil.getMousePosition(), stime);
    }

    public void show(int x, int y, long stime, long etime) {
        final Shell dialog = new Shell(this.display, 67680);
        dialog.setLayout((Layout)new GridLayout(4, false));
        dialog.setText("Add PeriodView");
        UIUtil.setDialogDefaultFunctions(dialog);
        Label Label2 = new Label((Composite)dialog, 0);
        Label2.setText("Counter");
        this.counterCombo = new Combo((Composite)dialog, 12);
        ArrayList<String> multiViewList = new ArrayList<String>();
        CubridSingleItem[] cubridSingleItemArray = CubridSingleItem.values();
        int n = cubridSingleItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CubridSingleItem view = cubridSingleItemArray[n2];
            multiViewList.add(view.getTitle());
            ++n2;
        }
        this.counterCombo.setItems(multiViewList.toArray(new String[CubridSingleItem.values().length]));
        this.counterCombo.select(0);
        this.counterCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.counterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (CubridSingleItem.infotypeFromOrdinal(AddShortPeriodCalendarDialog.this.counterCombo.getSelectionIndex()).equals((Object)CubridSingleItem.InfoType.BROKER_INFO)) {
                    AddShortPeriodCalendarDialog.this.dbListCombo.setEnabled(false);
                    AddShortPeriodCalendarDialog.this.dbListCombo.removeAll();
                    AddShortPeriodCalendarDialog.this.dbListCombo.add("BROKER_INFO");
                    AddShortPeriodCalendarDialog.this.dbListCombo.select(0);
                } else {
                    AddShortPeriodCalendarDialog.this.dbListCombo.setEnabled(true);
                    AddShortPeriodCalendarDialog.this.dbListCombo.removeAll();
                    AddShortPeriodCalendarDialog.this.dbLoad();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label2 = new Label((Composite)dialog, 0);
        Label2.setText("DB");
        this.dbListCombo = new Combo((Composite)dialog, 12);
        this.dbListCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.dbLoad();
        final DateTime calendar = new DateTime((Composite)dialog, 1024);
        GridData data = new GridData(4, 0x1000000, false, false, 4, 1);
        calendar.setLayoutData((Object)data);
        int year = CastUtil.cint((Object)DateUtil.format((long)stime, (String)"yyyy"));
        int month = CastUtil.cint((Object)DateUtil.format((long)stime, (String)"MM")) - 1;
        int day = CastUtil.cint((Object)DateUtil.format((long)stime, (String)"dd"));
        calendar.setDate(year, month, day);
        calendar.setDay(day);
        Label2 = new Label((Composite)dialog, 0);
        Label2.setText("From");
        final DateTime startTime = new DateTime((Composite)dialog, 32896);
        startTime.setHours(DateUtil.getHour((long)stime));
        startTime.setMinutes(DateUtil.getMin((long)stime));
        Label2 = new Label((Composite)dialog, 0);
        Label2.setText("To");
        final DateTime endTime = new DateTime((Composite)dialog, 32896);
        endTime.setHours(DateUtil.getHour((long)etime));
        endTime.setMinutes(DateUtil.getMin((long)etime));
        Button okButton = new Button((Composite)dialog, 8);
        okButton.setText("&OK");
        okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        try {
                            String counterTitle = AddShortPeriodCalendarDialog.this.counterCombo.getText();
                            CubridSingleItem type = CubridSingleItem.fromCounterName(counterTitle);
                            String fromTime = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear() + " " + (startTime.getHours() < 10 ? "0" : "") + startTime.getHours() + ":" + (startTime.getMinutes() < 10 ? "0" : "") + startTime.getMinutes();
                            boolean nextDay0 = false;
                            if (endTime.getHours() == 0 && endTime.getMinutes() == 0) {
                                nextDay0 = true;
                            }
                            String toTime = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear() + " " + (endTime.getHours() < 10 ? "0" : "") + endTime.getHours() + ":" + (endTime.getMinutes() < 10 ? "0" : "") + endTime.getMinutes();
                            long startTime2 = DateUtil.getTime((String)fromTime, (String)"MM/dd/yyyy HH:mm");
                            long endTime2 = DateUtil.getTime((String)toTime, (String)"MM/dd/yyyy HH:mm");
                            if (nextDay0) {
                                endTime2 += 86399000L;
                            }
                            if (endTime2 <= startTime2) {
                                MessageDialog.openWarning((Shell)dialog, (String)"Warning", (String)"Time range is incorrect");
                                break;
                            }
                            AddShortPeriodCalendarDialog.this.callback.onPressedOk(AddShortPeriodCalendarDialog.this.dbListCombo.getItem(AddShortPeriodCalendarDialog.this.dbListCombo.getSelectionIndex()), type, startTime2, endTime2);
                            dialog.close();
                            break;
                        }
                        catch (Exception e) {
                            MessageDialog.openError((Shell)dialog, (String)"Error55", (String)("format error:" + e.getMessage()));
                        }
                    }
                }
            }
        });
        Button cancelButton = new Button((Composite)dialog, 8);
        cancelButton.setText("&Cancel");
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        AddShortPeriodCalendarDialog.this.callback.onPressedCancel();
                        dialog.close();
                    }
                }
            }
        });
        dialog.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                AddShortPeriodCalendarDialog.this.callback.onPressedCancel();
            }
        });
        dialog.setDefaultButton(okButton);
        dialog.pack();
        if (x > 0 && y > 0) {
            dialog.setLocation(x, y);
        }
        dialog.open();
    }

    public void showOnlyStartTime(int x, int y, long stime) {
        final Shell dialog = new Shell(this.display, 67680);
        dialog.setLayout((Layout)new GridLayout(4, false));
        dialog.setText("Add PeriodView");
        UIUtil.setDialogDefaultFunctions(dialog);
        Label Label2 = new Label((Composite)dialog, 0);
        Label2.setText("Counter");
        this.counterCombo = new Combo((Composite)dialog, 4);
        ArrayList<String> multiViewList = new ArrayList<String>();
        CubridSingleItem[] cubridSingleItemArray = CubridSingleItem.values();
        int n = cubridSingleItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CubridSingleItem view = cubridSingleItemArray[n2];
            multiViewList.add(view.getTitle());
            ++n2;
        }
        this.counterCombo.setItems(multiViewList.toArray(new String[CubridSingleItem.values().length]));
        this.counterCombo.select(0);
        this.counterCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.counterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (CubridSingleItem.infotypeFromOrdinal(AddShortPeriodCalendarDialog.this.counterCombo.getSelectionIndex()).equals((Object)CubridSingleItem.InfoType.BROKER_INFO)) {
                    AddShortPeriodCalendarDialog.this.dbListCombo.setEnabled(false);
                    AddShortPeriodCalendarDialog.this.dbListCombo.removeAll();
                    AddShortPeriodCalendarDialog.this.dbListCombo.add("BROKER_INFO");
                    AddShortPeriodCalendarDialog.this.dbListCombo.select(0);
                } else {
                    AddShortPeriodCalendarDialog.this.dbListCombo.setEnabled(true);
                    AddShortPeriodCalendarDialog.this.dbListCombo.removeAll();
                    AddShortPeriodCalendarDialog.this.dbLoad();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label2 = new Label((Composite)dialog, 0);
        Label2.setText("DB");
        this.dbListCombo = new Combo((Composite)dialog, 4);
        this.dbListCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.dbLoad();
        final DateTime calendar = new DateTime((Composite)dialog, 1024);
        GridData data = new GridData(4, 0x1000000, false, false, 4, 1);
        calendar.setLayoutData((Object)data);
        int year = CastUtil.cint((Object)DateUtil.format((long)stime, (String)"yyyy"));
        int month = CastUtil.cint((Object)DateUtil.format((long)stime, (String)"MM")) - 1;
        int day = CastUtil.cint((Object)DateUtil.format((long)stime, (String)"dd"));
        calendar.setDate(year, month, day);
        calendar.setDay(day);
        Label2 = new Label((Composite)dialog, 0);
        Label2.setText("From");
        final DateTime startTime = new DateTime((Composite)dialog, 32896);
        startTime.setHours(DateUtil.getHour((long)stime));
        startTime.setMinutes(DateUtil.getMin((long)stime));
        Label2 = new Label((Composite)dialog, 0);
        Label2.setText("To");
        final Combo afterMinutes = new Combo((Composite)dialog, 12);
        ArrayList<String> minuteStrList = new ArrayList<String>();
        CalendarDialog.AfterMinuteUnit[] afterMinuteUnitArray = CalendarDialog.AfterMinuteUnit.values();
        int n3 = afterMinuteUnitArray.length;
        int n4 = 0;
        while (n4 < n3) {
            CalendarDialog.AfterMinuteUnit minute = afterMinuteUnitArray[n4];
            minuteStrList.add(minute.getLabel());
            ++n4;
        }
        afterMinutes.setItems(minuteStrList.toArray(new String[CalendarDialog.AfterMinuteUnit.values().length]));
        afterMinutes.select(0);
        afterMinutes.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Button okButton = new Button((Composite)dialog, 8);
        okButton.setText("&OK");
        okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        try {
                            String counterTitle = AddShortPeriodCalendarDialog.this.counterCombo.getText();
                            CubridSingleItem type = CubridSingleItem.fromCounterName(counterTitle);
                            String fromTime = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear() + " " + startTime.getHours() + ":" + (startTime.getMinutes() < 10 ? "0" : "") + startTime.getMinutes();
                            long startTime2 = DateUtil.getTime((String)fromTime, (String)"MM/dd/yyyy HH:mm");
                            long endTime = 0L;
                            String afterMinute = afterMinutes.getText();
                            CalendarDialog.AfterMinuteUnit m = CalendarDialog.AfterMinuteUnit.fromString(afterMinute);
                            if (m != null) {
                                endTime = startTime2 + m.getTime();
                            }
                            if (endTime <= startTime2) {
                                MessageDialog.openWarning((Shell)dialog, (String)"Warning", (String)"Time range is incorrect");
                                break;
                            }
                            if (!DateUtil.isSameDay((Date)new Date(startTime2), (Date)new Date(endTime))) {
                                endTime = DateUtil.getTime((String)(String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear() + " 23:59"), (String)"MM/dd/yyyy HH:mm");
                            }
                            AddShortPeriodCalendarDialog.this.callback.onPressedOk(AddShortPeriodCalendarDialog.this.dbListCombo.getItem(AddShortPeriodCalendarDialog.this.dbListCombo.getSelectionIndex()), type, startTime2, endTime);
                            dialog.close();
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            MessageDialog.openError((Shell)dialog, (String)"Error", (String)("Date format error:" + e.getMessage()));
                        }
                    }
                }
            }
        });
        Button cancelButton = new Button((Composite)dialog, 8);
        cancelButton.setText("&Cancel");
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        AddShortPeriodCalendarDialog.this.callback.onPressedCancel();
                        dialog.close();
                    }
                }
            }
        });
        dialog.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                AddShortPeriodCalendarDialog.this.callback.onPressedCancel();
            }
        });
        dialog.setDefaultButton(okButton);
        dialog.pack();
        if (x > 0 && y > 0) {
            dialog.setLocation(x, y);
        }
        dialog.open();
    }

    private void dbLoad() {
        ActiveDbInfo activeDBList = ActiveDbInfo.getInstance();
        if (!activeDBList.isEmpty(this.serverId)) {
            for (String dbName : activeDBList.keySet(this.serverId)) {
                this.dbListCombo.add(dbName);
            }
        } else {
            return;
        }
        this.dbListCombo.select(0);
    }

    public static interface IAddSingleShortPeriodDialog {
        public void onPressedOk(String var1, CubridSingleItem var2, long var3, long var5);

        public void onPressedCancel();
    }
}

