/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid.actions;

import java.awt.Point;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import scouter.client.cubrid.CubridSingleItem;
import scouter.client.model.AgentModelThread;
import scouter.client.net.TcpProxy;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.UIUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.util.CastUtil;

public class AlertSettingDialog {
    private final Display display;
    private final int serverId;
    private int objhash;
    private final int counterOrdinal;
    Combo dbListCombo;
    Combo counterCombo;
    Text currentValue;
    Text changeValue;
    String value = "0";
    MapValue alertConfigMap = new MapValue();

    public AlertSettingDialog(Display display, int serverId, int ordinal) {
        this.display = display;
        this.serverId = serverId;
        this.counterOrdinal = ordinal;
    }

    public void show(Point p) {
        if (p != null) {
            this.show((int)p.getX(), (int)p.getY() + 10);
        }
    }

    public void show() {
        this.show(UIUtil.getMousePosition());
    }

    public void show(int x, int y) {
        final Shell dialog = new Shell(this.display, 67680);
        dialog.setLayout((Layout)new GridLayout(2, true));
        dialog.setText("Warning Alert Setting");
        UIUtil.setDialogDefaultFunctions(dialog);
        AgentModelThread agentThreadA = AgentModelThread.getInstance();
        String hashString = agentThreadA.getLiveObjectHashStringWithParent(this.serverId, "cubridagent");
        if (hashString == null || hashString.equals("")) {
            MessageDialog.openError((Shell)dialog, (String)"Error55", (String)"Error : Please Check CUBRID-AGENT!!!!");
            return;
        }
        this.objhash = Integer.parseInt(hashString);
        this.loadAlertConfig();
        Label Label1 = new Label((Composite)dialog, 0);
        Label1.setLayoutData((Object)new GridData(16384));
        Label1.setText("Counter Name:");
        this.counterCombo = new Combo((Composite)dialog, 12);
        ArrayList<String> multiViewList = new ArrayList<String>();
        CubridSingleItem[] cubridSingleItemArray = CubridSingleItem.values();
        int n = cubridSingleItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CubridSingleItem view = cubridSingleItemArray[n2];
            multiViewList.add(view.getTitle());
            ++n2;
        }
        this.counterCombo.setItems(multiViewList.toArray(new String[CubridSingleItem.values().length]));
        this.counterCombo.select(this.counterOrdinal);
        this.counterCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.counterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                AlertSettingDialog.this.value = AlertSettingDialog.this.alertConfigMap.getText(CubridSingleItem.values()[AlertSettingDialog.this.counterCombo.getSelectionIndex()].getCounterName());
                if (AlertSettingDialog.this.value == null) {
                    AlertSettingDialog.this.currentValue.setText("not load Or not Setting");
                } else {
                    AlertSettingDialog.this.currentValue.setText(AlertSettingDialog.this.value);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label Label2 = new Label((Composite)dialog, 0);
        Label2.setLayoutData((Object)new GridData(16384));
        Label2.setText("Current Warning Value:");
        this.currentValue = new Text((Composite)dialog, 0);
        this.currentValue.setEditable(false);
        this.currentValue.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.value = this.alertConfigMap.getText(CubridSingleItem.values()[this.counterOrdinal].getCounterName());
        if (this.value == null) {
            this.currentValue.setText("not load Or not Setting");
        } else {
            this.currentValue.setText(this.value);
        }
        Label Label3 = new Label((Composite)dialog, 0);
        Label3.setLayoutData((Object)new GridData(16384));
        Label3.setText("Change Warning Value:");
        this.changeValue = new Text((Composite)dialog, 0);
        this.changeValue.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.changeValue.setText("");
        Button okButton = new Button((Composite)dialog, 8);
        okButton.setText("&OK");
        okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        try {
                            int ret = AlertSettingDialog.this.saveAlertConfig(CubridSingleItem.values()[AlertSettingDialog.this.counterCombo.getSelectionIndex()].getCounterName(), AlertSettingDialog.this.changeValue.getText());
                            if (ret != ErrorEnum.SUCCESS.getCode()) {
                                MessageDialog.openError((Shell)dialog, (String)"Error55", (String)("Error : " + ErrorEnum.getErrorMsg(ret)));
                                break;
                            }
                            dialog.close();
                            break;
                        }
                        catch (Exception e) {
                            MessageDialog.openError((Shell)dialog, (String)"Error55", (String)("Error : " + e.getMessage()));
                        }
                    }
                }
            }
        });
        Button cancelButton = new Button((Composite)dialog, 8);
        cancelButton.setText("&Cancel");
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        dialog.close();
                    }
                }
            }
        });
        dialog.setDefaultButton(okButton);
        dialog.pack();
        if (x > 0 && y > 0) {
            dialog.setLocation(x, y);
        }
        dialog.open();
    }

    private void loadAlertConfig() {
        final MapPack param = new MapPack();
        param.put("objHash", (long)this.objhash);
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack pack;
                block7: {
                    pack = null;
                    TcpProxy tcp = TcpProxy.getTcpProxy(AlertSettingDialog.this.serverId);
                    try {
                        try {
                            pack = (MapPack)tcp.getSingle("CUBRID_GET_ALERT_CONFIGURE", (Pack)param);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (pack != null) {
                    ListValue keyList = pack.getList("key");
                    ListValue valueList = pack.getList("value");
                    AlertSettingDialog.this.alertConfigMap.clear();
                    int i = 0;
                    while (i < keyList.size()) {
                        String key = CastUtil.cString((Object)keyList.get(i));
                        String value = CastUtil.cString((Object)valueList.get(i));
                        key = key == null ? "" : key;
                        value = value == null ? "" : value;
                        AlertSettingDialog.this.alertConfigMap.put(key, value);
                        ++i;
                    }
                }
            }
        });
    }

    private int saveAlertConfig(String alertKey, String value) {
        int success;
        block8: {
            success = ErrorEnum.SUCCESS.getCode();
            if (value == "") {
                return ErrorEnum.VALUE_EMPTY.getCode();
            }
            if (Integer.parseInt(value) < 0) {
                return ErrorEnum.VALUE_ERROR.getCode();
            }
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("key", alertKey);
                    param.put("value", value);
                    param.put("objHash", (long)this.objhash);
                    MapPack out = null;
                    out = (MapPack)tcp.getSingle("CUBRID_SET_ALERT_CONFIGURE", (Pack)param);
                    if (out == null) break block8;
                    String config = out.getText("result");
                    if ("true".equalsIgnoreCase(config)) {
                        success = ErrorEnum.SUCCESS.getCode();
                        break block8;
                    }
                    success = ErrorEnum.SERVER_ERROR.getCode();
                }
                catch (Throwable throwable) {
                    success = ErrorEnum.THROW_ERROR.getCode();
                    ConsoleProxy.errorSafe(String.valueOf(throwable.getMessage()) + " : error on save AlertConfig.");
                    TcpProxy.putTcpProxy(tcp);
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
        }
        return success;
    }

    static enum ErrorEnum {
        SUCCESS(0, "SUCCESS"),
        VALUE_EMPTY(1, "Please check, ChangeValue is Empty"),
        VALUE_ERROR(2, "Please check, ChangeValue is less zero"),
        SERVER_ERROR(3, "Error Server"),
        THROW_ERROR(4, "Unkown Error");

        private final int errorCode;
        private final String errorMsg;

        private ErrorEnum(int errorCode, String errorMsg) {
            this.errorCode = errorCode;
            this.errorMsg = errorMsg;
        }

        public int getCode() {
            return this.errorCode;
        }

        public String getMsg() {
            return this.errorMsg;
        }

        public static String getErrorMsg(int code) {
            return ErrorEnum.values()[code].getMsg();
        }
    }
}

