/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import scouter.client.Images;
import scouter.client.cubrid.CubridSingleItem;
import scouter.client.cubrid.CubridTypePeriod;
import scouter.client.cubrid.actions.AddLongPeriodCalendarDialog;
import scouter.client.cubrid.actions.AddRealTimeDialog;
import scouter.client.cubrid.actions.AddShortPeriodCalendarDialog;
import scouter.client.cubrid.views.CubridSingleDailyPeriodMultiView;
import scouter.client.cubrid.views.CubridSinglePeriodMultiView;
import scouter.client.cubrid.views.CubridSingleRealTimeMultiView;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;
import scouter.util.DateUtil;

public class MultiViewDialogAction
extends Action {
    IWorkbenchWindow window;
    private final int serverId;
    private final CubridTypePeriod periodType;

    public MultiViewDialogAction(IWorkbenchWindow window, int serverId, CubridTypePeriod periodType) {
        this.window = window;
        this.serverId = serverId;
        this.periodType = periodType;
        this.setText(periodType.getTitle());
        this.setImageDescriptor(ImageUtil.getImageDescriptor(Images.add));
    }

    public void run() {
        if (this.periodType == CubridTypePeriod.REALTIME) {
            AddRealTimeDialog dialog = new AddRealTimeDialog(this.window.getShell().getDisplay(), this.serverId, new AddRealTimeDialog.IAddSingleRealTimeDialog(){

                @Override
                public void onPressedOk(String dbName, CubridSingleItem viewType, long timeRange) {
                    System.out.println("MultiViewDialogAction dbName : " + dbName);
                    try {
                        MultiViewDialogAction.this.window.getActivePage().showView(CubridSingleRealTimeMultiView.ID, String.valueOf(MultiViewDialogAction.this.serverId) + "&" + dbName + "&" + viewType.ordinal() + "&" + timeRange, 1);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onPressedCancel() {
                }
            });
            dialog.show();
        } else if (this.periodType == CubridTypePeriod.PAST_LESS_1DAY) {
            AddShortPeriodCalendarDialog dialog = new AddShortPeriodCalendarDialog(this.window.getShell().getDisplay(), this.serverId, new AddShortPeriodCalendarDialog.IAddSingleShortPeriodDialog(){

                @Override
                public void onPressedOk(String dbName, CubridSingleItem viewType, long stime, long etime) {
                    try {
                        MultiViewDialogAction.this.window.getActivePage().showView(CubridSinglePeriodMultiView.ID, String.valueOf(MultiViewDialogAction.this.serverId) + "&" + dbName + "&" + viewType.ordinal() + "&" + stime + "&" + etime, 1);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onPressedCancel() {
                }
            });
            int hourRange = DateUtil.getHour((long)TimeUtil.getCurrentTime(this.serverId));
            int MiniteRange = DateUtil.getMin((long)TimeUtil.getCurrentTime(this.serverId));
            if (hourRange > 4) {
                dialog.show(TimeUtil.getCurrentTime(this.serverId) - 14400000L, TimeUtil.getCurrentTime(this.serverId));
            } else {
                dialog.show(TimeUtil.getCurrentTime(this.serverId) - 3600000L * (long)hourRange - 60000L * (long)MiniteRange, TimeUtil.getCurrentTime(this.serverId));
            }
        } else {
            AddLongPeriodCalendarDialog dialog = new AddLongPeriodCalendarDialog(this.window.getShell().getDisplay(), this.serverId, new AddLongPeriodCalendarDialog.IAddSingleLongPeriodDialog(){

                @Override
                public void onPressedOk(String dbName, CubridSingleItem viewType, String sDate, String eDate) {
                    try {
                        MultiViewDialogAction.this.window.getActivePage().showView(CubridSingleDailyPeriodMultiView.ID, String.valueOf(MultiViewDialogAction.this.serverId) + "&" + dbName + "&" + viewType.ordinal() + "&" + sDate + "&" + eDate, 1);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onPressedCancel() {
                }
            });
            dialog.show(TimeUtil.getCurrentTime(this.serverId), TimeUtil.getCurrentTime(this.serverId));
        }
    }
}

