/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.cubrid.views.CubridLongTransactionList;
import scouter.client.cubrid.views.CubridRealtimeDmlView;
import scouter.client.cubrid.views.CubridServerInfoView;
import scouter.client.cubrid.views.CubridSpaceDbView;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ImageUtil;

public class OpenOtherViewAction
extends Action {
    private final int serverId;
    private final OtherViewType viewType;

    public OpenOtherViewAction(int serverId, int objHash, OtherViewType viewType) {
        this.serverId = serverId;
        this.viewType = viewType;
        this.setText(viewType.getTitle());
        this.setImageDescriptor(ImageUtil.getImageDescriptor(Images.add));
    }

    public void run() {
        try {
            if (this.viewType.equals((Object)OtherViewType.DB_SPACE_INFO)) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(CubridSpaceDbView.ID, String.valueOf(this.serverId) + "&" + "default", 1);
            } else if (this.viewType.equals((Object)OtherViewType.LONG_TRANSACTION)) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(CubridLongTransactionList.ID, String.valueOf(this.serverId) + "&" + "default", 1);
            } else if (this.viewType.equals((Object)OtherViewType.DML_REALTIME)) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(CubridRealtimeDmlView.ID, String.valueOf(this.serverId) + "&" + "default", 1);
            } else if (this.viewType.equals((Object)OtherViewType.CUBRID_SERVERINFO)) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(CubridServerInfoView.ID, "" + this.serverId, 1);
            }
        }
        catch (PartInitException e) {
            ConsoleProxy.errorSafe(e.toString());
        }
    }

    public static enum OtherViewType {
        DB_SPACE_INFO("DB Space Info"),
        LONG_TRANSACTION("Long Tranjaction List"),
        DML_REALTIME("Realtime DML"),
        CUBRID_SERVERINFO("CUBRID ServerInfo");

        private String title;

        private OtherViewType(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

