/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid.views;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.cubrid.ActiveDbInfo;
import scouter.client.cubrid.actions.AddLongTransactionList;
import scouter.client.model.AgentModelThread;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.StatusPack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

public class CubridLongTransactionList
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = CubridLongTransactionList.class.getName();
    static long TIME_RANGE = 300000L;
    static int REFRESH_INTERVAL = 5000;
    String[] maxListArray = new String[]{"10", "20", "50", "100", "1000"};
    static int DEFAULT_MAX_LIST = 1000;
    private Combo dbListCombo;
    private Label MaxLabel;
    private Combo MaxListCombo;
    private int MaxListValue = 50;
    private TableViewer viewer;
    private TableColumnLayout tableColumnLayout;
    private Clipboard clipboard;
    private int serverId;
    RefreshThread thread;
    String date;
    long stime;
    long etime;
    Map<String, TransactionObject> saveData;
    ArrayList<TransactionObject> transactionList = new ArrayList();
    String selectionDB = "";
    boolean isDefaultView = false;
    int lastListIndex = 0;
    int prvActiveDBHash = -1;
    boolean scrollLock = false;
    boolean ctrlPressed = false;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.selectionDB = CastUtil.cString((Object)ids[1]);
        if (this.selectionDB.equals("default")) {
            this.isDefaultView = true;
        }
        this.saveData = new LinkedHashMap<String, TransactionObject>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, TransactionObject> eldest) {
                return this.size() > DEFAULT_MAX_LIST;
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.initialLayout(parent);
        this.clipboard = new Clipboard(null);
    }

    private void initialLayout(final Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        if (server != null) {
            this.setPartName("Long Transaction List[" + server.getName() + "]");
        } else {
            this.setPartName("Long Transaction List");
        }
        parent.setLayout((Layout)new GridLayout(2, true));
        this.dbListCombo = new Combo(parent, 12);
        if (!this.isDefaultView) {
            this.dbListCombo.add(this.selectionDB);
            this.dbListCombo.select(0);
            this.dbListCombo.setEnabled(false);
        }
        this.dbListCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ExUtil.exec(parent, new Runnable(){

                    @Override
                    public void run() {
                        (this).CubridLongTransactionList.this.selectionDB = (this).CubridLongTransactionList.this.dbListCombo.getText();
                        (this).CubridLongTransactionList.this.saveData.clear();
                        (this).CubridLongTransactionList.this.transactionList.clear();
                        (this).CubridLongTransactionList.this.viewer.setInput((Object)(this).CubridLongTransactionList.this.transactionList.toArray());
                        (this).CubridLongTransactionList.this.thread.interrupt();
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        GridData gdata = new GridData();
        gdata.horizontalAlignment = 3;
        gdata.verticalAlignment = 2;
        composite.setLayoutData((Object)gdata);
        this.MaxLabel = new Label(composite, 0);
        this.MaxLabel.setText("MaxList : ");
        this.MaxLabel.setLayoutData((Object)new GridData(0x1000000, 131072, false, false));
        this.MaxListCombo = new Combo(composite, 12);
        ArrayList<String> valueStrList = new ArrayList<String>();
        int i = 0;
        while (i < this.maxListArray.length) {
            valueStrList.add(this.maxListArray[i]);
            ++i;
        }
        this.MaxListCombo.setItems(valueStrList.toArray(new String[this.maxListArray.length]));
        this.MaxListCombo.select(2);
        this.MaxListCombo.setLayoutData((Object)new GridData(4, 16384, false, false));
        this.MaxListCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                CubridLongTransactionList.this.MaxListValue = Integer.parseInt(CubridLongTransactionList.this.maxListArray[CubridLongTransactionList.this.MaxListCombo.getSelectionIndex()]);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Composite tableComposite = new Composite(parent, 0);
        GridData gdataTable = new GridData(1808);
        gdataTable.horizontalSpan = 2;
        tableComposite.setLayoutData((Object)gdataTable);
        tableComposite.setLayout((Layout)new GridLayout(1, true));
        this.createTableViewer(tableComposite);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        Action scrollAct = new Action("Scroll Lock", 2){

            public void run() {
                CubridLongTransactionList.this.scrollLock = this.isChecked();
            }
        };
        scrollAct.setImageDescriptor(ImageUtil.getImageDescriptor(Images.table_scroll_lock));
        scrollAct.setChecked(false);
        man.add((IAction)scrollAct);
        this.thread = new RefreshThread(this, REFRESH_INTERVAL);
        this.thread.start();
    }

    private void createTableViewer(Composite composite) {
        this.viewer = new TableViewer(composite, 67586);
        this.tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)this.tableColumnLayout);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableContextMenu();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData gridData = new GridData(4, 4, true, true);
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void createTableContextMenu() {
        MenuManager manager = new MenuManager();
        this.viewer.getControl().setMenu(manager.createContextMenu(this.viewer.getControl()));
        manager.add((IAction)new Action("&Add LongTransaction ListView", ImageDescriptor.createFromImage((Image)Images.add)){

            public void run() {
                final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                AddLongTransactionList dialog = new AddLongTransactionList(window.getShell().getDisplay(), CubridLongTransactionList.this.serverId, new AddLongTransactionList.IAddLongTransactionList(){

                    @Override
                    public void onPressedOk(String dbName) {
                        try {
                            window.getActivePage().showView(ID, String.valueOf((this).CubridLongTransactionList.this.serverId) + "&" + dbName, 1);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onPressedCancel() {
                    }
                });
                dialog.show();
            }
        });
        manager.add((IAction)new Action("&Copy", ImageDescriptor.createFromImage((Image)Images.copy)){

            public void run() {
                CubridLongTransactionList.this.selectionCopyToClipboard();
            }
        });
        this.viewer.getTable().addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 262144) {
                    CubridLongTransactionList.this.ctrlPressed = true;
                } else if ((e.keyCode == 99 || e.keyCode == 67) && CubridLongTransactionList.this.ctrlPressed) {
                    CubridLongTransactionList.this.selectionCopyToClipboard();
                }
            }
        });
        this.viewer.getTable().addListener(2, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 262144) {
                    CubridLongTransactionList.this.ctrlPressed = false;
                }
            }
        });
    }

    private void selectionCopyToClipboard() {
        TableItem[] items;
        if (this.viewer != null && (items = this.viewer.getTable().getSelection()) != null && items.length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                TransactionObject data = (TransactionObject)items[i].getData();
                sb.append(data.toString());
                ++i;
            }
            this.clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private void createColumns() {
        ColumnEnum[] columnEnumArray = ColumnEnum.values();
        int n = columnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnEnum column = columnEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case SQL_TEXT: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof TransactionObject) {
                                return ((TransactionObject)element).sql_text;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case USER: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof TransactionObject) {
                                return ((TransactionObject)element).user;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case SQL_ID: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof TransactionObject) {
                                return ((TransactionObject)element).sql_id;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case HOST: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof TransactionObject) {
                                return ((TransactionObject)element).host;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case PID: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof TransactionObject) {
                                return String.valueOf(((TransactionObject)element).pid);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case PROGRAM: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof TransactionObject) {
                                return ((TransactionObject)element).program;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case TRAN_TIME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof TransactionObject) {
                                return String.valueOf(((TransactionObject)element).tran_time);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case QUERY_TIME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof TransactionObject) {
                                return String.valueOf(((TransactionObject)element).query_time);
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(30, width, resizable));
        column.setData("isNumber", (Object)isNumber);
        return viewerColumn;
    }

    public void setFocus() {
    }

    @Override
    public void refresh() {
        block14: {
            ActiveDbInfo activeDBList = ActiveDbInfo.getInstance();
            long now = TimeUtil.getCurrentTime(this.serverId);
            this.date = DateUtil.yyyymmdd((long)now);
            this.stime = now - TIME_RANGE;
            this.etime = now;
            if (this.isDefaultView) {
                if (this.selectionDB.equals("") || this.selectionDB.equals("default")) {
                    this.checkDBList();
                    return;
                }
                this.checkDBList();
            }
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            Pack p = null;
            try {
                try {
                    MapPack param = new MapPack();
                    ListValue objHashLv = AgentModelThread.getInstance().getLiveObjHashLV(this.serverId, "cubridagent");
                    StatusPack sp = null;
                    MapValue mv = null;
                    if (objHashLv.size() > 0) {
                        if (activeDBList.isEmpty(this.serverId)) {
                            this.transactionList.clear();
                        }
                        param.put("objHash", (Value)objHashLv);
                        param.put("date", this.date);
                        param.put("stime", this.stime);
                        param.put("etime", this.etime);
                        param.put("time", now);
                        param.put("key", "cubrid_taransaction_info_" + this.selectionDB);
                        p = tcp.getSingle("CUBRID_DB_LONG_TRANSACTION_DATA", (Pack)param);
                        if (p != null) {
                            sp = (StatusPack)p;
                            mv = sp.data;
                        }
                        if (mv != null) {
                            int i = 0;
                            while (i < mv.getList("user").size()) {
                                TransactionObject tranObj = new TransactionObject();
                                tranObj.sql_text = mv.getList("SQL_Text").get(i).toString();
                                tranObj.user = mv.getList("user").get(i).toString();
                                tranObj.sql_id = mv.getList("SQL_ID").get(i).toString();
                                tranObj.host = mv.getList("host").get(i).toString();
                                tranObj.pid = mv.getList("pid").get(i).toString();
                                tranObj.program = mv.getList("program").get(i).toString();
                                tranObj.tran_time = mv.getList("tran_time").getFloat(i);
                                tranObj.query_time = mv.getList("query_time").getFloat(i);
                                String key = String.valueOf(tranObj.sql_id) + tranObj.host + tranObj.pid + tranObj.user + tranObj.program;
                                if (this.saveData.get(key) == null) {
                                    this.saveData.put(key, tranObj);
                                } else {
                                    this.saveData.remove(key);
                                    this.saveData.put(key, tranObj);
                                }
                                ++i;
                            }
                        }
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        this.updateTableview();
    }

    private void updateTableview() {
        if (this.saveData.size() < 1) {
            return;
        }
        int skipCount = this.saveData.size() - this.MaxListValue;
        this.transactionList.clear();
        for (String key : this.saveData.keySet()) {
            if (skipCount > 0) {
                --skipCount;
                continue;
            }
            this.transactionList.add(this.saveData.get(key));
        }
        ExUtil.exec((Composite)this.viewer.getTable(), new Runnable(){

            @Override
            public void run() {
                CubridLongTransactionList.this.viewer.setInput((Object)CubridLongTransactionList.this.transactionList.toArray());
                if (CubridLongTransactionList.this.transactionList.size() > 0 && !CubridLongTransactionList.this.scrollLock) {
                    CubridLongTransactionList.this.viewer.getTable().setTopIndex(CubridLongTransactionList.this.transactionList.size() - 1);
                }
            }
        });
    }

    public void checkDBList() {
        if (!this.isDefaultView) {
            return;
        }
        if (ActiveDbInfo.getInstance().getActiveDBInfo(this.serverId) == null) {
            return;
        }
        if (ActiveDbInfo.getInstance().getActiveDBInfo(this.serverId).hashCode() == this.prvActiveDBHash) {
            return;
        }
        this.prvActiveDBHash = ActiveDbInfo.getInstance().getActiveDBInfo(this.serverId).hashCode();
        ExUtil.exec((Composite)this.dbListCombo, new Runnable(){

            @Override
            public void run() {
                CubridLongTransactionList.this.dbListCombo.removeAll();
            }
        });
        if (!ActiveDbInfo.getInstance().isEmpty(this.serverId)) {
            ExUtil.exec((Composite)this.dbListCombo, new Runnable(){

                @Override
                public void run() {
                    for (String dbName : ActiveDbInfo.getInstance().keySet(CubridLongTransactionList.this.serverId)) {
                        CubridLongTransactionList.this.dbListCombo.add(dbName);
                    }
                    CubridLongTransactionList.this.dbListCombo.setEnabled(true);
                }
            });
        } else {
            ExUtil.exec((Composite)this.dbListCombo, new Runnable(){

                @Override
                public void run() {
                    CubridLongTransactionList.this.selectionDB = "";
                    CubridLongTransactionList.this.dbListCombo.setEnabled(false);
                }
            });
        }
        ExUtil.exec((Composite)this.dbListCombo, new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < CubridLongTransactionList.this.dbListCombo.getItemCount()) {
                    if (CubridLongTransactionList.this.dbListCombo.getItem(i).equals(CubridLongTransactionList.this.selectionDB)) {
                        CubridLongTransactionList.this.dbListCombo.select(i);
                        return;
                    }
                    ++i;
                }
                if (CubridLongTransactionList.this.dbListCombo.getItemCount() != 0) {
                    CubridLongTransactionList.this.dbListCombo.select(0);
                    CubridLongTransactionList.this.selectionDB = CubridLongTransactionList.this.dbListCombo.getItem(CubridLongTransactionList.this.dbListCombo.getSelectionIndex());
                }
            }
        });
    }

    public static enum ColumnEnum {
        SQL_TEXT("SQL TEXT", 50, 131072, true, true, false),
        TRAN_TIME("TRAN TIME", 150, 16384, true, true, true),
        QUERY_TIME("QUERY_TIME", 150, 16384, true, true, true),
        HOST("HOST", 50, 131072, true, true, false),
        PID("PID", 50, 131072, true, true, false),
        USER("USER", 70, 131072, true, true, false),
        PROGRAM("PROGRAM", 100, 131072, true, true, false),
        SQL_ID("SQL_ID", 50, 131072, true, true, false);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private ColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }

    class TransactionObject {
        String sql_text;
        String user;
        String sql_id;
        String host;
        String pid;
        String program;
        float tran_time;
        float query_time;

        TransactionObject() {
        }

        public String getValueByIndex(int index) {
            switch (index) {
                case 0: {
                    return this.sql_text;
                }
                case 1: {
                    return this.user;
                }
                case 2: {
                    return this.sql_id;
                }
                case 3: {
                    return this.host;
                }
                case 4: {
                    return this.pid;
                }
                case 5: {
                    return this.program;
                }
                case 6: {
                    return String.valueOf(this.tran_time);
                }
                case 7: {
                    return String.valueOf(this.query_time);
                }
            }
            return null;
        }

        public String toString() {
            return String.valueOf(this.sql_text) + "\t" + this.user + "\t" + this.sql_id + "\t" + this.host + "\t" + this.pid + "\t" + this.program + "\t" + this.tran_time + "\t" + this.query_time + "\n";
        }
    }
}

