/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid.views;

import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.cubrid.ActiveDbInfo;
import scouter.client.cubrid.actions.AddLongTransactionList;
import scouter.client.listeners.RangeMouseListener;
import scouter.client.model.AgentModelThread;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.HashUtil;
import scouter.util.LinkedList;
import scouter.util.StringUtil;

public class CubridRealtimeDmlView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = CubridRealtimeDmlView.class.getName();
    int serverId;
    String selectionDB;
    RefreshThread thread;
    static long TIME_RANGE = 300000L;
    static int REFRESH_INTERVAL = 5000;
    static int BUFFER_SIZE = (int)(TIME_RANGE / (long)REFRESH_INTERVAL) + 1;
    FigureCanvas canvas;
    XYGraph xyGraph;
    Combo dbListCombo;
    boolean isDefaultView = false;
    int prvActiveDBHash;
    Trace selectTrace;
    Trace insertTrace;
    Trace updateTrace;
    Trace deleteTrace;
    boolean isStackView = true;
    String date;
    long stime;
    long etime;
    LinkedList<ValueLog> valueLogs = new LinkedList();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = StringUtil.split((String)secId, (String)"&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.selectionDB = CastUtil.cString((Object)ids[1]);
        if (this.selectionDB.equals("default")) {
            this.isDefaultView = true;
        }
    }

    public void createPartControl(Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        this.setPartName("REALTIME DML[" + server.getName() + "]");
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.dbListCombo = new Combo(parent, 12);
        this.dbListCombo.setLayoutData((Object)new GridData(4));
        if (!this.isDefaultView) {
            this.dbListCombo.add(this.selectionDB);
            this.dbListCombo.select(0);
            this.dbListCombo.setEnabled(false);
        }
        this.dbListCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ExUtil.exec((Composite)CubridRealtimeDmlView.this.canvas, new Runnable(){

                    @Override
                    public void run() {
                        (this).CubridRealtimeDmlView.this.selectionDB = (this).CubridRealtimeDmlView.this.dbListCombo.getText();
                        CircularBufferDataProvider delProvider = (CircularBufferDataProvider)(this).CubridRealtimeDmlView.this.deleteTrace.getDataProvider();
                        CircularBufferDataProvider upProvider = (CircularBufferDataProvider)(this).CubridRealtimeDmlView.this.updateTrace.getDataProvider();
                        CircularBufferDataProvider inProvider = (CircularBufferDataProvider)(this).CubridRealtimeDmlView.this.insertTrace.getDataProvider();
                        CircularBufferDataProvider selProvider = (CircularBufferDataProvider)(this).CubridRealtimeDmlView.this.selectTrace.getDataProvider();
                        delProvider.clearTrace();
                        upProvider.clearTrace();
                        inProvider.clearTrace();
                        selProvider.clearTrace();
                        (this).CubridRealtimeDmlView.this.thread.interrupt();
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                Rectangle r = CubridRealtimeDmlView.this.canvas.getClientArea();
                CubridRealtimeDmlView.this.xyGraph.setSize(r.width, r.height);
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(true);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setFormatPattern("HH:mm:ss");
        this.xyGraph.primaryYAxis.setFormatPattern("#,##0");
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.primaryYAxis.addMouseListener((MouseListener)new RangeMouseListener(this.getViewSite().getShell(), this.xyGraph.primaryYAxis));
        CircularBufferDataProvider selectProvider = new CircularBufferDataProvider(true);
        selectProvider.setBufferSize(BUFFER_SIZE);
        selectProvider.setCurrentXDataArray(new double[0]);
        selectProvider.setCurrentYDataArray(new double[0]);
        this.selectTrace = new Trace("Select (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, selectProvider);
        this.selectTrace.setPointStyle(Trace.PointStyle.NONE);
        this.selectTrace.setTraceType(Trace.TraceType.AREA);
        this.selectTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.selectTrace.setAreaAlpha(255);
        this.selectTrace.setTraceColor(ColorUtil.getInstance().getColor(14));
        this.xyGraph.addTrace(this.selectTrace);
        CircularBufferDataProvider insertProvider = new CircularBufferDataProvider(true);
        insertProvider.setBufferSize(BUFFER_SIZE);
        insertProvider.setCurrentXDataArray(new double[0]);
        insertProvider.setCurrentYDataArray(new double[0]);
        this.insertTrace = new Trace("Insert (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, insertProvider);
        this.insertTrace.setPointStyle(Trace.PointStyle.NONE);
        this.insertTrace.setTraceType(Trace.TraceType.AREA);
        this.insertTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.insertTrace.setAreaAlpha(255);
        this.insertTrace.setTraceColor(ColorUtil.getInstance().getColor(16));
        this.xyGraph.addTrace(this.insertTrace);
        CircularBufferDataProvider updateProvider = new CircularBufferDataProvider(true);
        updateProvider.setBufferSize(BUFFER_SIZE);
        updateProvider.setCurrentXDataArray(new double[0]);
        updateProvider.setCurrentYDataArray(new double[0]);
        this.updateTrace = new Trace("Update (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, updateProvider);
        this.updateTrace.setPointStyle(Trace.PointStyle.NONE);
        this.updateTrace.setTraceType(Trace.TraceType.AREA);
        this.updateTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.updateTrace.setAreaAlpha(255);
        this.updateTrace.setTraceColor(ColorUtil.getInstance().getColor(6));
        this.xyGraph.addTrace(this.updateTrace);
        CircularBufferDataProvider deleteProvider = new CircularBufferDataProvider(true);
        deleteProvider.setBufferSize(BUFFER_SIZE);
        deleteProvider.setCurrentXDataArray(new double[0]);
        deleteProvider.setCurrentYDataArray(new double[0]);
        this.deleteTrace = new Trace("Delete (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, deleteProvider);
        this.deleteTrace.setPointStyle(Trace.PointStyle.NONE);
        this.deleteTrace.setTraceType(Trace.TraceType.AREA);
        this.deleteTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.deleteTrace.setAreaAlpha(255);
        this.deleteTrace.setTraceColor(ColorUtil.getInstance().getColor(12));
        this.xyGraph.addTrace(this.deleteTrace);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        Action stackViewAct = new Action("Area Mode", 2){

            public void run() {
                CubridRealtimeDmlView.this.isStackView = this.isChecked();
                CubridRealtimeDmlView.this.changeMode();
            }
        };
        stackViewAct.setImageDescriptor(ImageUtil.getImageDescriptor(Images.sum));
        stackViewAct.setChecked(true);
        man.add((IAction)stackViewAct);
        this.createContextMenu();
        this.thread = new RefreshThread(this, REFRESH_INTERVAL);
        this.thread.start();
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        this.canvas.setMenu(manager.createContextMenu((Control)this.canvas));
        manager.add((IAction)new Action("&Add Realtime DML", ImageDescriptor.createFromImage((Image)Images.add)){

            public void run() {
                final IWorkbenchWindow window = CubridRealtimeDmlView.this.getSite().getWorkbenchWindow();
                AddLongTransactionList dialog = new AddLongTransactionList(CubridRealtimeDmlView.this.getSite().getWorkbenchWindow().getShell().getDisplay(), CubridRealtimeDmlView.this.serverId, new AddLongTransactionList.IAddLongTransactionList(){

                    @Override
                    public void onPressedOk(String dbName) {
                        try {
                            window.getActivePage().showView(ID, String.valueOf((this).CubridRealtimeDmlView.this.serverId) + "&" + dbName, 1);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onPressedCancel() {
                    }
                });
                dialog.show();
            }
        });
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    @Override
    public void refresh() {
        Value v;
        TcpProxy tcp;
        block15: {
            String objectName;
            MapPack param;
            block14: {
                block13: {
                    block12: {
                        if (this.isDefaultView) {
                            if (this.selectionDB.equals("default")) {
                                this.checkDBList();
                                return;
                            }
                            this.checkDBList();
                        }
                        tcp = TcpProxy.getTcpProxy(this.serverId);
                        v = null;
                        param = new MapPack();
                        if (ActiveDbInfo.getInstance() != null && !ActiveDbInfo.getInstance().isEmpty(this.serverId)) break block12;
                        TcpProxy.putTcpProxy(tcp);
                        return;
                    }
                    if (this.selectionDB != null) break block13;
                    TcpProxy.putTcpProxy(tcp);
                    return;
                }
                if (ActiveDbInfo.getInstance() == null) {
                    System.out.println("CubridRealtimeDmlView ActiveDbInfo.getInstance() is null");
                }
                if ((objectName = ActiveDbInfo.getInstance().getObjectName(this.serverId, this.selectionDB)) != null) break block14;
                TcpProxy.putTcpProxy(tcp);
                return;
            }
            try {
                try {
                    int objHash = HashUtil.hash((String)objectName);
                    ListValue objHashLv = AgentModelThread.getInstance().getLiveObjHashLV(this.serverId, "cubridagent");
                    objHashLv.add((long)objHash);
                    if (objHashLv.size() <= 0) break block15;
                    long now = TimeUtil.getCurrentTime(this.serverId);
                    this.date = DateUtil.yyyymmdd((long)now);
                    this.stime = now - TIME_RANGE;
                    this.etime = now;
                    param.put("objHash", (Value)objHashLv);
                    param.put("date", this.date);
                    param.put("stime", this.stime);
                    param.put("etime", this.etime);
                    param.put("time", now);
                    v = tcp.getSingleValue("CUBRID_DB_REALTIME_DML", (Pack)param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ConsoleProxy.errorSafe(e.toString());
                    TcpProxy.putTcpProxy(tcp);
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
        }
        TcpProxy.putTcpProxy(tcp);
        if (v == null) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    CubridRealtimeDmlView.this.setTitleImage(Images.inactive);
                    long now = TimeUtil.getCurrentTime(CubridRealtimeDmlView.this.serverId);
                    long stime = now - TIME_RANGE;
                    CubridRealtimeDmlView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                }
            });
        } else {
            MapValue mv = (MapValue)v;
            final DecimalValue selectValue = new DecimalValue(mv.getLong("select"));
            final DecimalValue insertValue = new DecimalValue(mv.getLong("insert"));
            final DecimalValue updateValue = new DecimalValue(mv.getLong("update"));
            final DecimalValue deleteValue = new DecimalValue(mv.getLong("delete"));
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    CubridRealtimeDmlView.this.setTitleImage(Images.active);
                    long now = TimeUtil.getCurrentTime(CubridRealtimeDmlView.this.serverId) / (long)REFRESH_INTERVAL * (long)REFRESH_INTERVAL;
                    long stime = now - TIME_RANGE;
                    CubridRealtimeDmlView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                    ValueLog valueLog = new ValueLog();
                    valueLog.time = now;
                    valueLog.delete = deleteValue.value;
                    valueLog.update = updateValue.value;
                    valueLog.insert = insertValue.value;
                    valueLog.select = selectValue.value;
                    CubridRealtimeDmlView.this.valueLogs.add((Object)valueLog);
                    if (CubridRealtimeDmlView.this.valueLogs.size() > BUFFER_SIZE) {
                        CubridRealtimeDmlView.this.valueLogs.removeFirst();
                    }
                    if (CubridRealtimeDmlView.this.isStackView) {
                        updateValue.value += deleteValue.value;
                        insertValue.value += updateValue.value;
                        selectValue.value += insertValue.value;
                    }
                    ((CircularBufferDataProvider)CubridRealtimeDmlView.this.selectTrace.getDataProvider()).addSample(new Sample(now, selectValue.value));
                    ((CircularBufferDataProvider)CubridRealtimeDmlView.this.insertTrace.getDataProvider()).addSample(new Sample(now, insertValue.value));
                    ((CircularBufferDataProvider)CubridRealtimeDmlView.this.updateTrace.getDataProvider()).addSample(new Sample(now, updateValue.value));
                    ((CircularBufferDataProvider)CubridRealtimeDmlView.this.deleteTrace.getDataProvider()).addSample(new Sample(now, deleteValue.value));
                    CubridRealtimeDmlView.this.xyGraph.primaryYAxis.setRange(0.0, this.getMaxYValue());
                }

                private double getMaxYValue() {
                    double value = ChartUtil.getMax(((CircularBufferDataProvider)CubridRealtimeDmlView.this.selectTrace.getDataProvider()).iterator());
                    value = Math.max(value, ChartUtil.getMax(((CircularBufferDataProvider)CubridRealtimeDmlView.this.insertTrace.getDataProvider()).iterator()));
                    value = Math.max(value, ChartUtil.getMax(((CircularBufferDataProvider)CubridRealtimeDmlView.this.updateTrace.getDataProvider()).iterator()));
                    value = Math.max(value, ChartUtil.getMax(((CircularBufferDataProvider)CubridRealtimeDmlView.this.deleteTrace.getDataProvider()).iterator()));
                    return value;
                }
            });
        }
    }

    protected void changeMode() {
        CircularBufferDataProvider delProvider = (CircularBufferDataProvider)this.deleteTrace.getDataProvider();
        CircularBufferDataProvider upProvider = (CircularBufferDataProvider)this.updateTrace.getDataProvider();
        CircularBufferDataProvider inProvider = (CircularBufferDataProvider)this.insertTrace.getDataProvider();
        CircularBufferDataProvider selProvider = (CircularBufferDataProvider)this.selectTrace.getDataProvider();
        delProvider.clearTrace();
        upProvider.clearTrace();
        inProvider.clearTrace();
        selProvider.clearTrace();
        int size = this.valueLogs.size();
        if (size > 0) {
            LinkedList.ENTRY entry = this.valueLogs.getFirst();
            if (this.isStackView) {
                do {
                    ValueLog log = (ValueLog)entry.item;
                    double x = log.time;
                    double delValue = log.delete;
                    double upValue = delValue + log.update;
                    double inValue = upValue + log.insert;
                    double selValue = inValue + log.select;
                    selProvider.addSample(new Sample(x, selValue));
                    inProvider.addSample(new Sample(x, inValue));
                    upProvider.addSample(new Sample(x, upValue));
                    delProvider.addSample(new Sample(x, delValue));
                } while ((entry = entry.next) != null);
            } else {
                do {
                    ValueLog log = (ValueLog)entry.item;
                    double x = log.time;
                    double delValue = log.delete;
                    double upValue = log.update;
                    double inValue = log.insert;
                    double selValue = log.select;
                    selProvider.addSample(new Sample(x, selValue));
                    inProvider.addSample(new Sample(x, inValue));
                    upProvider.addSample(new Sample(x, upValue));
                    delProvider.addSample(new Sample(x, delValue));
                } while ((entry = entry.next) != null);
            }
        }
        if (this.isStackView) {
            this.deleteTrace.setTraceType(Trace.TraceType.AREA);
            this.updateTrace.setTraceType(Trace.TraceType.AREA);
            this.insertTrace.setTraceType(Trace.TraceType.AREA);
            this.selectTrace.setTraceType(Trace.TraceType.AREA);
        } else {
            this.deleteTrace.setTraceType(Trace.TraceType.SOLID_LINE);
            this.updateTrace.setTraceType(Trace.TraceType.SOLID_LINE);
            this.insertTrace.setTraceType(Trace.TraceType.SOLID_LINE);
            this.selectTrace.setTraceType(Trace.TraceType.SOLID_LINE);
        }
    }

    public void checkDBList() {
        if (!this.isDefaultView) {
            return;
        }
        if (ActiveDbInfo.getInstance().getActiveDBInfo(this.serverId).hashCode() == this.prvActiveDBHash) {
            return;
        }
        this.prvActiveDBHash = ActiveDbInfo.getInstance().getActiveDBInfo(this.serverId).hashCode();
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                CubridRealtimeDmlView.this.dbListCombo.removeAll();
            }
        });
        if (!ActiveDbInfo.getInstance().isEmpty(this.serverId)) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    for (String dbName : ActiveDbInfo.getInstance().keySet(CubridRealtimeDmlView.this.serverId)) {
                        CubridRealtimeDmlView.this.dbListCombo.add(dbName);
                    }
                    CubridRealtimeDmlView.this.dbListCombo.setEnabled(true);
                }
            });
        } else {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    CubridRealtimeDmlView.this.dbListCombo.setEnabled(false);
                }
            });
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < CubridRealtimeDmlView.this.dbListCombo.getItemCount()) {
                    if (CubridRealtimeDmlView.this.dbListCombo.getItem(i).equals(CubridRealtimeDmlView.this.selectionDB)) {
                        CubridRealtimeDmlView.this.dbListCombo.select(i);
                        CubridRealtimeDmlView.this.selectionDB = CubridRealtimeDmlView.this.dbListCombo.getItem(CubridRealtimeDmlView.this.dbListCombo.getSelectionIndex());
                        return;
                    }
                    ++i;
                }
                if (CubridRealtimeDmlView.this.dbListCombo.getItemCount() != 0) {
                    CubridRealtimeDmlView.this.dbListCombo.select(0);
                    CubridRealtimeDmlView.this.selectionDB = CubridRealtimeDmlView.this.dbListCombo.getItem(CubridRealtimeDmlView.this.dbListCombo.getSelectionIndex());
                }
            }
        });
    }

    private static class ValueLog {
        long time;
        double delete;
        double update;
        double insert;
        double select;

        private ValueLog() {
        }
    }
}

