/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid.views;

import java.util.ArrayList;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.cubrid.ActiveDbInfo;
import scouter.client.model.AgentModelThread;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.sorter.TableLabelSorter;
import scouter.client.util.ExUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.StatusPack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

public class CubridServerInfoView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = CubridServerInfoView.class.getName();
    static long TIME_RANGE = 300000L;
    static int REFRESH_INTERVAL = 5000;
    int serverId;
    private ArrayList<ServerInfo> dataList;
    private ArrayList<MapValue> responseData;
    private TableViewer tableViewer;
    private TableColumnLayout tableColumnLayout;
    RefreshThread thread;
    String date;
    long stime;
    long etime;
    MapValue prvData;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        this.serverId = CastUtil.cint((Object)secId);
        this.dataList = new ArrayList();
        this.responseData = new ArrayList();
    }

    public void createPartControl(Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        ActiveDbInfo activeDBList = ActiveDbInfo.getInstance();
        if (server != null) {
            this.setPartName("CUBRID ServerInfo[" + server.getName() + "]");
            activeDBList.addServerInfo(this.serverId);
        } else {
            this.setPartName("CUBRID ServerInfo");
        }
        Composite tableComposite = new Composite(parent, 0);
        this.tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)this.tableColumnLayout);
        this.tableViewer = new TableViewer(tableComposite, 67586);
        this.tableViewer.setComparator((ViewerComparator)new TableLabelSorter(this.tableViewer));
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.createColumns();
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener arg0) {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public String getColumnText(Object arg0, int arg1) {
                ServerInfo info = (ServerInfo)arg0;
                switch (arg1) {
                    case 0: {
                        return info.dbName;
                    }
                    case 1: {
                        return info.ipAddress;
                    }
                    case 2: {
                        return String.valueOf(info.cpuUsed) + "%";
                    }
                    case 3: {
                        return info.activeSession;
                    }
                    case 4: {
                        return info.lockWaitSession;
                    }
                }
                return "";
            }

            public Image getColumnImage(Object arg0, int arg1) {
                return null;
            }
        });
        this.createTableContextMenu();
        this.thread = new RefreshThread(this, REFRESH_INTERVAL);
        this.thread.start();
    }

    private void createTableContextMenu() {
    }

    private void createColumns() {
        ColumnEnum[] columnEnumArray = ColumnEnum.values();
        int n = columnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnEnum column = columnEnumArray[n2];
            this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(width, width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableLabelSorter sorter = (TableLabelSorter)CubridServerInfoView.this.tableViewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    @Override
    public void refresh() {
        block14: {
            ActiveDbInfo activeDBList = ActiveDbInfo.getInstance();
            long now = TimeUtil.getCurrentTime(this.serverId);
            this.date = DateUtil.yyyymmdd((long)now);
            this.stime = now - TIME_RANGE;
            this.etime = now;
            if (!this.getDBList()) {
                this.dataList.clear();
                ExUtil.exec((Composite)this.tableViewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        if (CubridServerInfoView.this.tableViewer != null) {
                            CubridServerInfoView.this.tableViewer.setInput(CubridServerInfoView.this.dataList);
                        }
                    }
                });
                return;
            }
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            Pack p = null;
            try {
                try {
                    this.responseData.clear();
                    MapPack param = new MapPack();
                    ListValue objHashLv = AgentModelThread.getInstance().getLiveObjHashLV(this.serverId, "cubridagent");
                    StatusPack sp = null;
                    MapValue mv = null;
                    if (objHashLv.size() > 0) {
                        if (activeDBList.isEmpty(this.serverId)) {
                            this.dataList.clear();
                        }
                        for (String dbName : activeDBList.keySet(this.serverId)) {
                            param.put("objHash", (Value)objHashLv);
                            param.put("date", this.date);
                            param.put("stime", this.stime);
                            param.put("etime", this.etime);
                            param.put("time", now);
                            param.put("key", "cubrid_server_info_" + dbName);
                            p = tcp.getSingle("CUBRID_DB_SERVER_INFO", (Pack)param);
                            if (p != null) {
                                sp = (StatusPack)p;
                                mv = sp.data;
                                this.responseData.add(mv);
                                continue;
                            }
                            System.out.println("CubridServerInfoView p is null");
                        }
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        boolean isSearched = false;
        int i = 0;
        while (i < this.responseData.size()) {
            isSearched = false;
            String dbName = this.responseData.get(i).getText("db_name");
            String ipAddress = this.responseData.get(i).getText("ip_address");
            String cpuUsed = this.responseData.get(i).getText("cpu_used");
            String activeSession = this.responseData.get(i).getText("active_session");
            String lockWaitSession = this.responseData.get(i).getText("lock_wait_sessions");
            int j = 0;
            while (j < this.dataList.size()) {
                if (this.dataList.get((int)j).dbName.equals(dbName)) {
                    this.dataList.get((int)j).ipAddress = ipAddress;
                    this.dataList.get((int)j).cpuUsed = cpuUsed;
                    this.dataList.get((int)j).activeSession = activeSession;
                    this.dataList.get((int)j).lockWaitSession = lockWaitSession;
                    isSearched = true;
                    break;
                }
                ++j;
            }
            if (!isSearched) {
                this.dataList.add(new ServerInfo(this.responseData.get(i).getText("db_name"), this.responseData.get(i).getText("ip_address"), this.responseData.get(i).getText("cpu_used"), this.responseData.get(i).getText("active_session"), this.responseData.get(i).getText("lock_wait_sessions")));
            }
            ++i;
        }
        ExUtil.exec((Composite)this.tableViewer.getTable(), new Runnable(){

            @Override
            public void run() {
                if (CubridServerInfoView.this.tableViewer != null) {
                    CubridServerInfoView.this.tableViewer.setInput(CubridServerInfoView.this.dataList);
                }
            }
        });
    }

    private boolean getDBList() {
        block14: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            Pack p = null;
            ActiveDbInfo activeDBList = ActiveDbInfo.getInstance();
            try {
                MapPack param = new MapPack();
                ListValue objHashLv = AgentModelThread.getInstance().getLiveObjHashLV(this.serverId, "cubridagent");
                if (objHashLv.size() > 0) {
                    param.put("objHash", (Value)objHashLv);
                    param.put("key", "cubrid_active_db_list");
                    param.put("date", this.date);
                    param.put("time", this.stime);
                    p = tcp.getSingle("CUBRID_ACTIVE_DB_LIST", (Pack)param);
                }
                if (p != null) {
                    StatusPack sp = (StatusPack)p;
                    MapValue mv = sp.data;
                    if (mv == null || mv.isEmpty()) {
                        if (this.prvData != null) {
                            this.prvData.clear();
                        }
                        return false;
                    }
                    if (this.prvData != null && this.prvData.equals((Object)mv)) {
                        return true;
                    }
                    this.prvData = mv;
                    activeDBList.clear(this.serverId);
                    for (String key : mv.keySet()) {
                        activeDBList.put(this.serverId, key, String.valueOf(mv.get(key)));
                    }
                    break block14;
                }
                if (this.prvData != null) {
                    this.prvData.clear();
                }
                activeDBList.clear(this.serverId);
                return false;
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
        }
        return true;
    }

    public void setFocus() {
    }

    static enum ColumnEnum {
        DB_NAME("DB NAME", 25, 0x1000000, true, true, false),
        IP_ADDRESS("IP ADDRESS", 40, 0x1000000, true, true, false),
        CPU_USED("CPU", 20, 0x1000000, true, true, true),
        ACTIVE_SESSION("ACTIVE SESSION", 40, 0x1000000, true, true, true),
        LOCK_WAIT_SESSION("LOCK WAIT SESSIONS", 45, 0x1000000, true, true, true);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private ColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }

    private class ServerInfo {
        String dbName;
        String ipAddress;
        String cpuUsed;
        String activeSession;
        String lockWaitSession;

        public ServerInfo(String dbName, String ip, String cpu, String active, String lockWait) {
            this.dbName = dbName;
            this.ipAddress = ip;
            this.cpuUsed = cpu;
            this.activeSession = active;
            this.lockWaitSession = lockWait;
        }
    }
}

