/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.cubrid.ActiveDbInfo;
import scouter.client.cubrid.CubridMenuUtil;
import scouter.client.cubrid.CubridSingleItem;
import scouter.client.listeners.RangeMouseListener;
import scouter.client.model.RefreshThread;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.popup.DualCalendarDialog;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.StringUtil;

public class CubridSingleDailyPeriodMultiView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = CubridSingleDailyPeriodMultiView.class.getName();
    int serverId;
    CubridSingleItem viewType;
    long TIME_RANGE;
    FigureCanvas canvas;
    XYGraph xyGraph;
    Combo dbListCombo;
    Combo dbCounterCombo;
    Menu contextMenu;
    String selectionDB;
    boolean isDefaultView = false;
    Trace nearestTrace;
    ArrayList<Trace> traces = new ArrayList();
    protected Map<Integer, CircularBufferDataProvider> datas = new HashMap<Integer, CircularBufferDataProvider>();
    long pastStime;
    long pastEtime;
    String pastSdate;
    String pastEdate;
    RefreshThread thread;
    Label serverText;
    Label sDateText;
    Label eDateText;
    DualCalendarDialog calDialog;
    Combo periodCombo;
    Composite headerComp;
    Button applyBtn;
    int prvActiveDBHash;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = StringUtil.split((String)secId, (String)"&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.selectionDB = CastUtil.cString((Object)ids[1]);
        int ordinal = CastUtil.cint((Object)ids[2]);
        this.pastSdate = CastUtil.cString((Object)ids[3]);
        this.pastEdate = CastUtil.cString((Object)ids[4]);
        this.viewType = CubridSingleItem.values()[ordinal];
        this.pastStime = DateUtil.getTime((String)this.pastSdate, (String)"yyyyMMdd");
        this.pastEtime = DateUtil.getTime((String)this.pastEdate, (String)"yyyyMMdd") + 86400000L;
        this.TIME_RANGE = this.pastEtime - this.pastStime;
        if (this.selectionDB.equals("default")) {
            this.isDefaultView = true;
        }
    }

    public void createPartControl(Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        this.setPartName("Daily Period - " + this.viewType.getTitle() + " [" + server.getName() + "]");
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.dbCounterCombo = new Combo(parent, 12);
        this.dbCounterCombo.setLayoutData((Object)new GridData(16388));
        CubridSingleItem[] cubridSingleItemArray = CubridSingleItem.values();
        int n = cubridSingleItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CubridSingleItem counterName = cubridSingleItemArray[n2];
            this.dbCounterCombo.add(counterName.getTitle());
            if (counterName.ordinal() == this.viewType.ordinal()) {
                this.dbCounterCombo.select(this.viewType.ordinal());
            }
            ++n2;
        }
        if (!this.isDefaultView) {
            this.dbCounterCombo.setEnabled(false);
        }
        this.dbCounterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ExUtil.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).CubridSingleDailyPeriodMultiView.this.viewType = CubridSingleItem.values()[(this).CubridSingleDailyPeriodMultiView.this.dbCounterCombo.getSelectionIndex()];
                        (this).CubridSingleDailyPeriodMultiView.this.applyBtn.setEnabled(true);
                        if ((this).CubridSingleDailyPeriodMultiView.this.viewType.getInfoType() == CubridSingleItem.InfoType.BROKER_INFO) {
                            (this).CubridSingleDailyPeriodMultiView.this.dbListCombo.setEnabled(false);
                            (this).CubridSingleDailyPeriodMultiView.this.dbListCombo.removeAll();
                            (this).CubridSingleDailyPeriodMultiView.this.dbListCombo.add("BROKER_INFO");
                            (this).CubridSingleDailyPeriodMultiView.this.dbListCombo.select(0);
                            if (ActiveDbInfo.getInstance().getDbList((this).CubridSingleDailyPeriodMultiView.this.serverId).isEmpty()) {
                                (this).CubridSingleDailyPeriodMultiView.this.selectionDB = ActiveDbInfo.getInstance().getDbList((this).CubridSingleDailyPeriodMultiView.this.serverId).get(0);
                            }
                        } else {
                            (this).CubridSingleDailyPeriodMultiView.this.dbListCombo.removeAll();
                            if ((this).CubridSingleDailyPeriodMultiView.this.isDefaultView) {
                                (this).CubridSingleDailyPeriodMultiView.this.dbListCombo.setEnabled(true);
                            }
                            (this).CubridSingleDailyPeriodMultiView.this.prvActiveDBHash = -1;
                            CubridSingleDailyPeriodMultiView.this.checkDBList();
                        }
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.dbListCombo = new Combo(parent, 12);
        this.dbListCombo.setLayoutData((Object)new GridData(16388));
        if (!this.isDefaultView) {
            this.dbListCombo.add(this.selectionDB);
            this.dbListCombo.select(0);
            this.dbListCombo.setEnabled(false);
        }
        if (this.viewType.getInfoType() == CubridSingleItem.InfoType.BROKER_INFO) {
            this.dbListCombo.setEnabled(false);
            this.dbListCombo.removeAll();
            this.dbListCombo.add(CubridSingleItem.InfoType.BROKER_INFO.getTitle());
            this.dbListCombo.select(0);
        }
        this.dbListCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ExUtil.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).CubridSingleDailyPeriodMultiView.this.applyBtn.setEnabled(true);
                        (this).CubridSingleDailyPeriodMultiView.this.selectionDB = (this).CubridSingleDailyPeriodMultiView.this.dbListCombo.getText();
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Button dbRefresh = new Button(parent, 8);
        dbRefresh.setLayoutData((Object)new GridData(16384));
        dbRefresh.setImage(Images.refresh);
        dbRefresh.setToolTipText("refresh DB List");
        dbRefresh.setVisible(false);
        dbRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (CubridSingleDailyPeriodMultiView.this.viewType.getInfoType() != CubridSingleItem.InfoType.BROKER_INFO) {
                    CubridSingleDailyPeriodMultiView.this.checkDBList();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        GridData gdata = new GridData();
        gdata.horizontalAlignment = 3;
        composite.setLayoutData((Object)gdata);
        this.createUpperMenu(composite);
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        GridData gdataXyGraph = new GridData(1808);
        gdataXyGraph.horizontalSpan = 4;
        this.canvas.setLayoutData((Object)gdataXyGraph);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                Rectangle r = CubridSingleDailyPeriodMultiView.this.canvas.getClientArea();
                CubridSingleDailyPeriodMultiView.this.xyGraph.setSize(r.width, r.height);
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(true);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        if (this.viewType.isPercent()) {
            this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
        }
        this.xyGraph.primaryXAxis.setFormatPattern("yyyy-MM-dd\n  HH:mm:ss");
        this.xyGraph.primaryYAxis.setFormatPattern("#,##0");
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.primaryYAxis.addMouseListener((MouseListener)new RangeMouseListener(this.getViewSite().getShell(), this.xyGraph.primaryYAxis));
        final DefaultToolTip toolTip = new DefaultToolTip((Control)this.canvas, 1, true);
        toolTip.setFont(new Font(null, "Arial", 10, 1));
        toolTip.setBackgroundColor(Display.getCurrent().getSystemColor(29));
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent arg0) {
            }
        });
        this.canvas.addMouseListener(new org.eclipse.swt.events.MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (CubridSingleDailyPeriodMultiView.this.nearestTrace != null) {
                    CubridSingleDailyPeriodMultiView.this.nearestTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
                    CubridSingleDailyPeriodMultiView.this.nearestTrace = null;
                }
                toolTip.hide();
            }

            public void mouseDown(MouseEvent e) {
                double x = CubridSingleDailyPeriodMultiView.this.xyGraph.primaryXAxis.getPositionValue(e.x, false);
                double y = CubridSingleDailyPeriodMultiView.this.xyGraph.primaryYAxis.getPositionValue(e.y, false);
                if (x < 0.0 || y < 0.0) {
                    return;
                }
                double minDistance = 30.0;
                long time = 0L;
                double value = 0.0;
                for (Trace t : CubridSingleDailyPeriodMultiView.this.traces) {
                    int y2;
                    int x2;
                    double distance;
                    ISample s = ScouterUtil.getNearestPoint(t.getDataProvider(), x);
                    if (s == null || !(minDistance > (distance = ScouterUtil.getPointDistance(e.x, e.y, x2 = CubridSingleDailyPeriodMultiView.this.xyGraph.primaryXAxis.getValuePosition(s.getXValue(), false), y2 = CubridSingleDailyPeriodMultiView.this.xyGraph.primaryYAxis.getValuePosition(s.getYValue(), false))))) continue;
                    minDistance = distance;
                    CubridSingleDailyPeriodMultiView.this.nearestTrace = t;
                    time = (long)s.getXValue();
                    value = s.getYValue();
                }
                if (CubridSingleDailyPeriodMultiView.this.nearestTrace != null) {
                    int width = PManager.getInstance().getInt("lineWidth");
                    CubridSingleDailyPeriodMultiView.this.nearestTrace.setLineWidth(width + 2);
                    toolTip.setText(String.valueOf(CubridSingleDailyPeriodMultiView.this.nearestTrace.getName()) + "\nTime : " + DateUtil.format((long)time, (String)"HH:mm:ss") + "\nValue : " + FormatUtil.print((Object)value, (String)"#,###.##"));
                    toolTip.show(new Point(e.x, e.y));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        CubridMenuUtil.createAddViewContextMenu(this.getSite().getWorkbenchWindow(), this.serverId, this.canvas);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("refresh", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ExUtil.asyncRun(new Runnable(){

                    @Override
                    public void run() {
                        CubridSingleDailyPeriodMultiView.this.longPastLoad();
                    }
                });
            }
        });
        this.thread = new RefreshThread(this, 1000);
        this.thread.start();
    }

    private void createUpperMenu(Composite composite) {
        this.headerComp = new Composite(composite, 0);
        this.headerComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.headerComp.setLayout((Layout)UIUtil.formLayout(0, 0));
        this.applyBtn = new Button(this.headerComp, 8);
        this.applyBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, 100, -5, null, -1));
        this.applyBtn.setText("Apply");
        this.applyBtn.setEnabled(false);
        this.applyBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        ((Button)event.widget).setEnabled(false);
                        try {
                            CubridSingleDailyPeriodMultiView.this.modifyData();
                            CubridSingleDailyPeriodMultiView.this.longPastLoad();
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        Button manualBtn = new Button(this.headerComp, 8);
        manualBtn.setImage(Images.CTXMENU_RDC);
        manualBtn.setText("Manual");
        manualBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, this.applyBtn, -5, null, -1));
        manualBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        Display display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        CubridSingleDailyPeriodMultiView.this.calDialog = new DualCalendarDialog(display, new DualCalendarDialog.ILoadDualCounterDialog(){

                            @Override
                            public void onPressedOk(final String sDate, final String eDate) {
                                ExUtil.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((this).this).CubridSingleDailyPeriodMultiView.this.applyBtn.setEnabled(true);
                                        ((this).this).CubridSingleDailyPeriodMultiView.this.pastSdate = sDate;
                                        ((this).this).CubridSingleDailyPeriodMultiView.this.pastEdate = eDate;
                                        ((this).this).CubridSingleDailyPeriodMultiView.this.pastStime = DateUtil.getTime((String)((this).this).CubridSingleDailyPeriodMultiView.this.pastSdate, (String)"yyyyMMdd");
                                        ((this).this).CubridSingleDailyPeriodMultiView.this.pastEtime = DateUtil.getTime((String)((this).this).CubridSingleDailyPeriodMultiView.this.pastEdate, (String)"yyyyMMdd") + 86400000L;
                                        ((this).this).CubridSingleDailyPeriodMultiView.this.TIME_RANGE = ((this).this).CubridSingleDailyPeriodMultiView.this.pastEtime - ((this).this).CubridSingleDailyPeriodMultiView.this.pastStime;
                                        ((this).this).CubridSingleDailyPeriodMultiView.this.sDateText.setText(DateUtil.format((long)((this).this).CubridSingleDailyPeriodMultiView.this.pastStime, (String)"yyyy-MM-dd"));
                                        ((this).this).CubridSingleDailyPeriodMultiView.this.eDateText.setText(DateUtil.format((long)((this).this).CubridSingleDailyPeriodMultiView.this.pastEtime, (String)"yyyy-MM-dd"));
                                    }
                                });
                            }

                            @Override
                            public void onPressedOk(long startTime, long endTime) {
                            }

                            @Override
                            public void onPressedCancel() {
                            }
                        });
                        CubridSingleDailyPeriodMultiView.this.calDialog.show(UIUtil.getMousePosition());
                    }
                }
            }
        });
        this.periodCombo = new Combo(this.headerComp, 2568);
        this.periodCombo.setLayoutData((Object)UIUtil.formData(null, -1, 0, 3, manualBtn, -5, null, -1));
        ArrayList<String> periodStrList = new ArrayList<String>();
        DatePeriodUnit[] datePeriodUnitArray = DatePeriodUnit.values();
        int n = datePeriodUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatePeriodUnit minute = datePeriodUnitArray[n2];
            periodStrList.add(minute.getLabel());
            ++n2;
        }
        this.periodCombo.setItems(periodStrList.toArray(new String[DatePeriodUnit.values().length]));
        this.periodCombo.select(2);
        this.periodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CubridSingleDailyPeriodMultiView.this.applyBtn.setEnabled(true);
                if (((Combo)e.widget).getSelectionIndex() == 0) {
                    this.setStartEndDate(30);
                } else if (((Combo)e.widget).getSelectionIndex() == 1) {
                    this.setStartEndDate(7);
                } else {
                    this.setStartEndDate(1);
                }
            }

            private void setStartEndDate(int i) {
                long yesterday = TimeUtil.getCurrentTime(CubridSingleDailyPeriodMultiView.this.serverId) - DatePeriodUnit.A_DAY.getTime();
                long startDate = TimeUtil.getCurrentTime(CubridSingleDailyPeriodMultiView.this.serverId) - DatePeriodUnit.A_DAY.getTime() * (long)i;
                CubridSingleDailyPeriodMultiView.this.sDateText.setText(DateUtil.format((long)startDate, (String)"yyyy-MM-dd"));
                CubridSingleDailyPeriodMultiView.this.eDateText.setText(DateUtil.format((long)yesterday, (String)"yyyy-MM-dd"));
                CubridSingleDailyPeriodMultiView.this.pastSdate = DateUtil.format((long)startDate, (String)"yyyyMMdd");
                CubridSingleDailyPeriodMultiView.this.pastEdate = DateUtil.format((long)yesterday, (String)"yyyyMMdd");
                CubridSingleDailyPeriodMultiView.this.pastStime = DateUtil.getTime((String)CubridSingleDailyPeriodMultiView.this.pastSdate, (String)"yyyyMMdd");
                CubridSingleDailyPeriodMultiView.this.pastEtime = DateUtil.getTime((String)CubridSingleDailyPeriodMultiView.this.pastEdate, (String)"yyyyMMdd") + 86400000L;
            }
        });
        this.eDateText = new Label(this.headerComp, 0);
        this.eDateText.setLayoutData((Object)UIUtil.formData(null, -1, 0, 7, this.periodCombo, -5, null, -1));
        this.eDateText.setText(DateUtil.format((long)this.pastEtime, (String)"yyyy-MM-dd"));
        Label windbarLabel = new Label(this.headerComp, 0);
        windbarLabel.setLayoutData((Object)UIUtil.formData(null, -1, 0, 7, this.eDateText, -5, null, -1));
        windbarLabel.setText("~");
        this.sDateText = new Label(this.headerComp, 0);
        this.sDateText.setLayoutData((Object)UIUtil.formData(null, -1, 0, 7, windbarLabel, -5, null, -1));
        this.sDateText.setText(DateUtil.format((long)this.pastStime, (String)"yyyy-MM-dd"));
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }

    private CircularBufferDataProvider getDataProvider(int serverId) {
        CircularBufferDataProvider data = this.datas.get(serverId);
        if (data == null) {
            data = new CircularBufferDataProvider(true);
            this.datas.put(serverId, data);
            int bufferSize = (int)(this.TIME_RANGE / 300000L) + 1;
            data.setBufferSize(bufferSize);
            data.setCurrentXDataArray(new double[0]);
            data.setCurrentYDataArray(new double[0]);
            Trace trace = new Trace(this.viewType.getTitle(), this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, data);
            trace.setPointStyle(Trace.PointStyle.NONE);
            trace.setAreaAlpha(255);
            trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
            trace.setTraceType(this.viewType.getTraceType());
            trace.setTraceColor(ColorUtil.getInstance().getColor(this.viewType.getColor()));
            this.xyGraph.addTrace(trace);
            this.traces.add(trace);
        }
        return data;
    }

    public void checkDBList() {
        if (!this.isDefaultView) {
            return;
        }
        if (ActiveDbInfo.getInstance().getActiveDBInfo(this.serverId).hashCode() == this.prvActiveDBHash) {
            return;
        }
        this.prvActiveDBHash = ActiveDbInfo.getInstance().getActiveDBInfo(this.serverId).hashCode();
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                CubridSingleDailyPeriodMultiView.this.dbListCombo.removeAll();
            }
        });
        if (!ActiveDbInfo.getInstance().isEmpty(this.serverId)) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    for (String dbName : ActiveDbInfo.getInstance().keySet(CubridSingleDailyPeriodMultiView.this.serverId)) {
                        CubridSingleDailyPeriodMultiView.this.dbListCombo.add(dbName);
                    }
                    CubridSingleDailyPeriodMultiView.this.dbListCombo.setEnabled(true);
                }
            });
        } else {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    CubridSingleDailyPeriodMultiView.this.dbListCombo.setEnabled(false);
                }
            });
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < CubridSingleDailyPeriodMultiView.this.dbListCombo.getItemCount()) {
                    if (CubridSingleDailyPeriodMultiView.this.dbListCombo.getItem(i).equals(CubridSingleDailyPeriodMultiView.this.selectionDB)) {
                        CubridSingleDailyPeriodMultiView.this.dbListCombo.select(i);
                        return;
                    }
                    ++i;
                }
                if (CubridSingleDailyPeriodMultiView.this.dbListCombo.getItemCount() != 0) {
                    CubridSingleDailyPeriodMultiView.this.dbListCombo.select(0);
                    CubridSingleDailyPeriodMultiView.this.selectionDB = CubridSingleDailyPeriodMultiView.this.dbListCombo.getItem(CubridSingleDailyPeriodMultiView.this.dbListCombo.getSelectionIndex());
                }
            }
        });
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
            this.xyGraph.repaint();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void longPastLoad() {
        ArrayList values;
        block9: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            values = new ArrayList();
            if (ActiveDbInfo.getInstance() == null) {
                return;
            }
            if (this.viewType.getInfoType() == CubridSingleItem.InfoType.BROKER_INFO) {
                if (ActiveDbInfo.getInstance().getDbList(this.serverId).isEmpty()) return;
                this.selectionDB = ActiveDbInfo.getInstance().getDbList(this.serverId).get(0);
            } else {
                if (this.selectionDB.equals("default")) {
                    this.checkDBList();
                    return;
                }
                this.checkDBList();
            }
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    CubridSingleDailyPeriodMultiView.this.selectionDB = CubridSingleDailyPeriodMultiView.this.dbListCombo.getText();
                    if (CubridSingleDailyPeriodMultiView.this.selectionDB == "") {
                        return;
                    }
                }
            });
            try {
                try {
                    MapPack param = new MapPack();
                    ListValue objHashLv = new ListValue();
                    objHashLv.add((long)ActiveDbInfo.getInstance().getObjectHash(this.serverId, this.selectionDB));
                    param.put("objHash", (Value)objHashLv);
                    param.put("counter", this.viewType.getCounterName());
                    param.put("sDate", this.pastSdate);
                    param.put("eDate", this.pastEdate);
                    tcp.process("CUBRID_DB_LONG_PERIOD_MULTI_DATA", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            MapPack mpack = (MapPack)in.readPack();
                            values.add(mpack);
                        }
                    });
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                CubridSingleDailyPeriodMultiView.this.xyGraph.primaryXAxis.setRange(CubridSingleDailyPeriodMultiView.this.pastStime, CubridSingleDailyPeriodMultiView.this.pastEtime);
                for (MapPack mpack : values) {
                    ListValue time = mpack.getList("time");
                    ListValue value = mpack.getList("value");
                    if (time == null || time.size() < 1) continue;
                    CircularBufferDataProvider provider = CubridSingleDailyPeriodMultiView.this.getDataProvider(CubridSingleDailyPeriodMultiView.this.serverId);
                    provider.clearTrace();
                    int i = 0;
                    while (time != null && i < time.size()) {
                        CubridSingleDailyPeriodMultiView.this.setTitleImage(Images.active);
                        long x = time.getLong(i);
                        if (value.getString(i) != null) {
                            long y = Long.parseLong(value.getString(i));
                            long prevY = 0L;
                            if (i != 0 && value.getString(i - 1) != null) {
                                prevY = Long.parseLong(value.getString(i - 1));
                            }
                            if (y >= 0L && prevY >= 0L) {
                                provider.addSample(new Sample(x, y));
                            }
                        }
                        ++i;
                    }
                    if (CubridSingleDailyPeriodMultiView.this.viewType.isPercent()) {
                        CubridSingleDailyPeriodMultiView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                        continue;
                    }
                    double max = ChartUtil.getMax(provider.iterator());
                    CubridSingleDailyPeriodMultiView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void refresh() {
        if (ActiveDbInfo.getInstance() == null) {
            return;
        }
        if (this.viewType.getInfoType() == CubridSingleItem.InfoType.BROKER_INFO) {
            if (ActiveDbInfo.getInstance().getDbList(this.serverId).isEmpty()) return;
            this.selectionDB = ActiveDbInfo.getInstance().getDbList(this.serverId).get(0);
        } else {
            if (this.selectionDB.equals("default")) {
                this.checkDBList();
                return;
            }
            this.checkDBList();
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                if (CubridSingleDailyPeriodMultiView.this.dbListCombo != null && CubridSingleDailyPeriodMultiView.this.dbListCombo.getItemCount() != 0 && CubridSingleDailyPeriodMultiView.this.dbListCombo.getSelection() != null) {
                    CubridSingleDailyPeriodMultiView.this.selectionDB = CubridSingleDailyPeriodMultiView.this.dbListCombo.getText();
                    if (CubridSingleDailyPeriodMultiView.this.selectionDB == "") {
                        return;
                    }
                }
            }
        });
        if (ActiveDbInfo.getInstance().isEmpty(this.serverId)) {
            return;
        }
        this.longPastLoad();
        this.thread.shutdown();
    }

    private void modifyData() {
        this.redraw();
        this.getDataProvider(this.serverId).clearTrace();
        Trace trace = this.traces.get(0);
        trace.setName(this.viewType.getTitle());
        trace.setTraceColor(ColorUtil.getInstance().getColor(this.viewType.getColor()));
        int bufferSize = (int)(this.TIME_RANGE / 300000L) + 1;
        this.getDataProvider(this.serverId).setBufferSize(bufferSize);
    }

    public static enum DatePeriodUnit {
        A_MONTH("1 Month", -1702967296L),
        A_WEEK("1 Week", 604800000L),
        A_DAY("1 Day", 86400000L);

        private String label;
        private long time;

        private DatePeriodUnit(String label, long time) {
            this.label = label;
            this.time = time;
        }

        public String getLabel() {
            return this.label;
        }

        public long getTime() {
            return this.time;
        }

        public static DatePeriodUnit fromString(String text) {
            if (text != null) {
                DatePeriodUnit[] datePeriodUnitArray = DatePeriodUnit.values();
                int n = datePeriodUnitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DatePeriodUnit b = datePeriodUnitArray[n2];
                    if (text.equalsIgnoreCase(b.label)) {
                        return b;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }
}

