/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.cubrid.ActiveDbInfo;
import scouter.client.cubrid.CubridMenuUtil;
import scouter.client.cubrid.CubridSingleItem;
import scouter.client.listeners.RangeMouseListener;
import scouter.client.model.RefreshThread;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.popup.CalendarDialog;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.StringUtil;

public class CubridSinglePeriodMultiView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = CubridSinglePeriodMultiView.class.getName();
    int serverId;
    CubridSingleItem viewType;
    RefreshThread thread;
    long TIME_RANGE = 600000L;
    static int REFRESH_INTERVAL = 5000;
    static long CHECK_ACTIVE_REALTIME = 600000L;
    FigureCanvas canvas;
    XYGraph xyGraph;
    Combo dbListCombo;
    Combo dbCounterCombo;
    Menu contextMenu;
    String selectionDB;
    boolean isDefaultView = false;
    Trace nearestTrace;
    ArrayList<Trace> traces = new ArrayList();
    protected Map<Integer, CircularBufferDataProvider> datas = new HashMap<Integer, CircularBufferDataProvider>();
    String date;
    long stime;
    long etime;
    long pastStime;
    long pastEtime;
    boolean manulRefresh = true;
    Label serverText;
    Label sDateText;
    Label sTimeText;
    Label eTimeText;
    Composite headerComp;
    CalendarDialog calDialog;
    Button applyBtn;
    int prvActiveDBHash;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = StringUtil.split((String)secId, (String)"&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.selectionDB = CastUtil.cString((Object)ids[1]);
        int ordinal = CastUtil.cint((Object)ids[2]);
        this.viewType = CubridSingleItem.values()[ordinal];
        this.pastStime = CastUtil.cLong((Object)ids[3]);
        this.pastEtime = CastUtil.cLong((Object)ids[4]);
        this.TIME_RANGE = this.pastEtime - this.pastStime;
        if (this.selectionDB == "default") {
            this.isDefaultView = true;
        }
    }

    public void createPartControl(Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        this.setPartName("ShortPeriod - " + this.viewType.getTitle() + "[" + server.getName() + "]");
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.dbCounterCombo = new Combo(parent, 12);
        this.dbCounterCombo.setLayoutData((Object)new GridData(16388));
        CubridSingleItem[] cubridSingleItemArray = CubridSingleItem.values();
        int n = cubridSingleItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CubridSingleItem counterName = cubridSingleItemArray[n2];
            this.dbCounterCombo.add(counterName.getTitle());
            if (counterName.ordinal() == this.viewType.ordinal()) {
                this.dbCounterCombo.select(this.viewType.ordinal());
            }
            ++n2;
        }
        if (!this.isDefaultView) {
            this.dbCounterCombo.setEnabled(false);
        }
        this.dbCounterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ExUtil.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).CubridSinglePeriodMultiView.this.viewType = CubridSingleItem.values()[(this).CubridSinglePeriodMultiView.this.dbCounterCombo.getSelectionIndex()];
                        (this).CubridSinglePeriodMultiView.this.applyBtn.setEnabled(true);
                        if ((this).CubridSinglePeriodMultiView.this.viewType.getInfoType() == CubridSingleItem.InfoType.BROKER_INFO) {
                            (this).CubridSinglePeriodMultiView.this.dbListCombo.setEnabled(false);
                            (this).CubridSinglePeriodMultiView.this.dbListCombo.removeAll();
                            (this).CubridSinglePeriodMultiView.this.dbListCombo.add("BROKER_INFO");
                            (this).CubridSinglePeriodMultiView.this.dbListCombo.select(0);
                        } else {
                            if ((this).CubridSinglePeriodMultiView.this.isDefaultView) {
                                (this).CubridSinglePeriodMultiView.this.dbListCombo.setEnabled(true);
                            }
                            (this).CubridSinglePeriodMultiView.this.dbListCombo.removeAll();
                            (this).CubridSinglePeriodMultiView.this.prvActiveDBHash = -1;
                            CubridSinglePeriodMultiView.this.checkDBList();
                        }
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.dbListCombo = new Combo(parent, 12);
        this.dbListCombo.setLayoutData((Object)new GridData(16388));
        if (!this.isDefaultView) {
            this.dbListCombo.add(this.selectionDB);
            this.dbListCombo.select(0);
            this.dbListCombo.setEnabled(false);
        }
        if (this.viewType.getInfoType() == CubridSingleItem.InfoType.BROKER_INFO) {
            this.dbListCombo.setEnabled(false);
            this.dbListCombo.removeAll();
            this.dbListCombo.add(CubridSingleItem.InfoType.BROKER_INFO.getTitle());
            this.dbListCombo.select(0);
        }
        this.dbListCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                CubridSinglePeriodMultiView.this.selectionDB = CubridSinglePeriodMultiView.this.dbListCombo.getItem(CubridSinglePeriodMultiView.this.dbListCombo.getSelectionIndex());
                CubridSinglePeriodMultiView.this.applyBtn.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Button dbRefresh = new Button(parent, 8);
        dbRefresh.setLayoutData((Object)new GridData(16384));
        dbRefresh.setImage(Images.refresh);
        dbRefresh.setToolTipText("refresh DB List");
        dbRefresh.setVisible(false);
        dbRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (CubridSinglePeriodMultiView.this.viewType.getInfoType() != CubridSingleItem.InfoType.BROKER_INFO) {
                    CubridSinglePeriodMultiView.this.checkDBList();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        GridData gdata = new GridData();
        gdata.horizontalAlignment = 3;
        composite.setLayoutData((Object)gdata);
        this.createUpperMenu(composite);
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        GridData gdataXyGraph = new GridData(1808);
        gdataXyGraph.horizontalSpan = 4;
        this.canvas.setLayoutData((Object)gdataXyGraph);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                Rectangle r = CubridSinglePeriodMultiView.this.canvas.getClientArea();
                CubridSinglePeriodMultiView.this.xyGraph.setSize(r.width, r.height);
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(true);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        if (this.viewType.isPercent()) {
            this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
        }
        this.xyGraph.primaryXAxis.setFormatPattern("HH:mm:ss");
        this.xyGraph.primaryYAxis.setFormatPattern("#,##0");
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.primaryYAxis.addMouseListener((MouseListener)new RangeMouseListener(this.getViewSite().getShell(), this.xyGraph.primaryYAxis));
        final DefaultToolTip toolTip = new DefaultToolTip((Control)this.canvas, 1, true);
        toolTip.setFont(new Font(null, "Arial", 10, 1));
        toolTip.setBackgroundColor(Display.getCurrent().getSystemColor(29));
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent arg0) {
            }
        });
        this.canvas.addMouseListener(new org.eclipse.swt.events.MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (CubridSinglePeriodMultiView.this.nearestTrace != null) {
                    CubridSinglePeriodMultiView.this.nearestTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
                    CubridSinglePeriodMultiView.this.nearestTrace = null;
                }
                toolTip.hide();
            }

            public void mouseDown(MouseEvent e) {
                double x = CubridSinglePeriodMultiView.this.xyGraph.primaryXAxis.getPositionValue(e.x, false);
                double y = CubridSinglePeriodMultiView.this.xyGraph.primaryYAxis.getPositionValue(e.y, false);
                if (x < 0.0 || y < 0.0) {
                    return;
                }
                double minDistance = 30.0;
                long time = 0L;
                double value = 0.0;
                for (Trace t : CubridSinglePeriodMultiView.this.traces) {
                    int y2;
                    int x2;
                    double distance;
                    ISample s = ScouterUtil.getNearestPoint(t.getDataProvider(), x);
                    if (s == null || !(minDistance > (distance = ScouterUtil.getPointDistance(e.x, e.y, x2 = CubridSinglePeriodMultiView.this.xyGraph.primaryXAxis.getValuePosition(s.getXValue(), false), y2 = CubridSinglePeriodMultiView.this.xyGraph.primaryYAxis.getValuePosition(s.getYValue(), false))))) continue;
                    minDistance = distance;
                    CubridSinglePeriodMultiView.this.nearestTrace = t;
                    time = (long)s.getXValue();
                    value = s.getYValue();
                }
                if (CubridSinglePeriodMultiView.this.nearestTrace != null) {
                    int width = PManager.getInstance().getInt("lineWidth");
                    CubridSinglePeriodMultiView.this.nearestTrace.setLineWidth(width + 2);
                    toolTip.setText(String.valueOf(CubridSinglePeriodMultiView.this.nearestTrace.getName()) + "\nTime : " + DateUtil.format((long)time, (String)"HH:mm:ss") + "\nValue : " + FormatUtil.print((Object)value, (String)"#,###.##"));
                    toolTip.show(new Point(e.x, e.y));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        CubridMenuUtil.createAddViewContextMenu(this.getSite().getWorkbenchWindow(), this.serverId, this.canvas);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("refresh", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                CubridSinglePeriodMultiView.this.manulRefresh = true;
                CubridSinglePeriodMultiView.this.thread.interrupt();
            }
        });
        this.thread = new RefreshThread(this, REFRESH_INTERVAL);
        this.thread.start();
    }

    private void createUpperMenu(Composite composite) {
        this.headerComp = new Composite(composite, 0);
        this.headerComp.setLayoutData((Object)new GridData(131072));
        this.headerComp.setLayout((Layout)UIUtil.formLayout(0, 0));
        this.applyBtn = new Button(this.headerComp, 8);
        this.applyBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, 100, -5, null, -1));
        this.applyBtn.setText("Apply");
        this.applyBtn.setEnabled(false);
        this.applyBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        ((Button)event.widget).setEnabled(false);
                        try {
                            CubridSinglePeriodMultiView.this.modifyData();
                            CubridSinglePeriodMultiView.this.manulRefresh = true;
                            CubridSinglePeriodMultiView.this.thread.interrupt();
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        Button manualBtn = new Button(this.headerComp, 8);
        manualBtn.setImage(Images.CTXMENU_RDC);
        manualBtn.setText("Manual");
        manualBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, this.applyBtn, -5, null, -1));
        manualBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        Display display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        CubridSinglePeriodMultiView.this.calDialog = new CalendarDialog(display, new CalendarDialog.ILoadCalendarDialog(){

                            @Override
                            public void onPressedOk(String date) {
                            }

                            @Override
                            public void onPressedOk(final long startTime, final long endTime) {
                                ExUtil.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((this).this).CubridSinglePeriodMultiView.this.pastStime = startTime;
                                        ((this).this).CubridSinglePeriodMultiView.this.pastEtime = endTime;
                                        ((this).this).CubridSinglePeriodMultiView.this.applyBtn.setEnabled(true);
                                        ((this).this).CubridSinglePeriodMultiView.this.TIME_RANGE = ((this).this).CubridSinglePeriodMultiView.this.pastEtime - ((this).this).CubridSinglePeriodMultiView.this.pastStime;
                                        ((this).this).CubridSinglePeriodMultiView.this.eTimeText.setText(DateUtil.format((long)((this).this).CubridSinglePeriodMultiView.this.pastEtime, (String)"hh:mm a", (Locale)Locale.ENGLISH));
                                        ((this).this).CubridSinglePeriodMultiView.this.sTimeText.setText(DateUtil.format((long)((this).this).CubridSinglePeriodMultiView.this.pastStime, (String)"hh:mm a", (Locale)Locale.ENGLISH));
                                        ((this).this).CubridSinglePeriodMultiView.this.sDateText.setText(DateUtil.format((long)((this).this).CubridSinglePeriodMultiView.this.pastStime, (String)"yyyy-MM-dd"));
                                    }
                                });
                            }

                            @Override
                            public void onPressedCancel() {
                            }
                        });
                        int hourRange = DateUtil.getHour((long)TimeUtil.getCurrentTime(CubridSinglePeriodMultiView.this.serverId));
                        int MiniteRange = DateUtil.getMin((long)TimeUtil.getCurrentTime(CubridSinglePeriodMultiView.this.serverId));
                        if (hourRange > 4) {
                            CubridSinglePeriodMultiView.this.calDialog.showWithEndTime(UIUtil.getMousePosition(), TimeUtil.getCurrentTime(CubridSinglePeriodMultiView.this.serverId) - 14400000L, TimeUtil.getCurrentTime(CubridSinglePeriodMultiView.this.serverId));
                            break;
                        }
                        CubridSinglePeriodMultiView.this.calDialog.showWithEndTime(UIUtil.getMousePosition(), TimeUtil.getCurrentTime(CubridSinglePeriodMultiView.this.serverId) - 3600000L * (long)hourRange - 60000L * (long)MiniteRange, TimeUtil.getCurrentTime(CubridSinglePeriodMultiView.this.serverId));
                    }
                }
            }
        });
        this.eTimeText = new Label(this.headerComp, 0);
        this.eTimeText.setLayoutData((Object)UIUtil.labelFormData((Control)manualBtn));
        this.eTimeText.setText(DateUtil.format((long)this.pastEtime, (String)"hh:mm a", (Locale)Locale.ENGLISH));
        Label label = new Label(this.headerComp, 0);
        label.setLayoutData((Object)UIUtil.labelFormData((Control)this.eTimeText));
        label.setText("~");
        this.sTimeText = new Label(this.headerComp, 0);
        this.sTimeText.setLayoutData((Object)UIUtil.labelFormData((Control)label));
        this.sTimeText.setText(DateUtil.format((long)this.pastStime, (String)"hh:mm a", (Locale)Locale.ENGLISH));
        this.sDateText = new Label(this.headerComp, 0);
        this.sDateText.setLayoutData((Object)UIUtil.labelFormData((Control)this.sTimeText));
        this.sDateText.setText(DateUtil.format((long)this.pastStime, (String)"yyyy-MM-dd"));
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void refresh() {
        Value v;
        block14: {
            if (ActiveDbInfo.getInstance() == null) {
                return;
            }
            if (this.viewType.getInfoType() == CubridSingleItem.InfoType.BROKER_INFO) {
                if (ActiveDbInfo.getInstance().getDbList(this.serverId).isEmpty()) return;
                this.selectionDB = ActiveDbInfo.getInstance().getDbList(this.serverId).get(0);
            } else {
                if (this.selectionDB.equals("default")) {
                    this.checkDBList();
                    return;
                }
                this.checkDBList();
            }
            if (this.manulRefresh) {
                this.manulRefresh = false;
                if (TimeUtil.getCurrentTime(this.serverId) - this.pastEtime > CHECK_ACTIVE_REALTIME) {
                    this.pastLoad();
                    return;
                }
                this.pastEtime = TimeUtil.getCurrentTime(this.serverId);
                this.pastLoad();
                ExUtil.exec((Composite)this.canvas, new Runnable(){

                    @Override
                    public void run() {
                        CubridSinglePeriodMultiView.this.eTimeText.setText("RealTime");
                    }
                });
            } else if (TimeUtil.getCurrentTime(this.serverId) - this.pastEtime > CHECK_ACTIVE_REALTIME) {
                return;
            }
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            v = null;
            try {
                try {
                    MapPack param = new MapPack();
                    ListValue objHashLv = new ListValue();
                    objHashLv.add((long)ActiveDbInfo.getInstance().getObjectHash(this.serverId, this.selectionDB));
                    param.put("objHash", (Value)objHashLv);
                    param.put("counter", this.viewType.getCounterName());
                    v = tcp.getSingleValue("CUBRID_DB_REALTIME_MULTI_DATA", (Pack)param);
                }
                catch (Exception e) {
                    ConsoleProxy.errorSafe(e.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (v == null) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    CubridSinglePeriodMultiView.this.setTitleImage(Images.inactive);
                    long now = TimeUtil.getCurrentTime(CubridSinglePeriodMultiView.this.serverId);
                    long stime = now - CubridSinglePeriodMultiView.this.TIME_RANGE;
                    CubridSinglePeriodMultiView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                }
            });
            return;
        }
        MapValue value = (MapValue)v;
        final long data = value.getLong(this.viewType.getCounterName());
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                CubridSinglePeriodMultiView.this.setTitleImage(Images.active);
                long now = TimeUtil.getCurrentTime(CubridSinglePeriodMultiView.this.serverId);
                long stime = now - CubridSinglePeriodMultiView.this.TIME_RANGE;
                CubridSinglePeriodMultiView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                CubridSinglePeriodMultiView.this.getDataProvider(CubridSinglePeriodMultiView.this.serverId).addSample(new Sample(now, data));
                double max = ChartUtil.getMax(CubridSinglePeriodMultiView.this.getDataProvider(CubridSinglePeriodMultiView.this.serverId).iterator());
                if (CubridSinglePeriodMultiView.this.viewType.isPercent()) {
                    CubridSinglePeriodMultiView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    CubridSinglePeriodMultiView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
            }
        });
    }

    private CircularBufferDataProvider getDataProvider(int serverId) {
        CircularBufferDataProvider data = this.datas.get(serverId);
        if (data == null) {
            data = new CircularBufferDataProvider(true);
            this.datas.put(serverId, data);
            int bufferSize = (int)(this.TIME_RANGE / (long)REFRESH_INTERVAL) + 1;
            data.setBufferSize(bufferSize);
            data.setCurrentXDataArray(new double[0]);
            data.setCurrentYDataArray(new double[0]);
            Trace trace = new Trace(this.viewType.getTitle(), this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, data);
            trace.setPointStyle(Trace.PointStyle.NONE);
            trace.setAreaAlpha(255);
            trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
            trace.setTraceType(this.viewType.getTraceType());
            trace.setTraceColor(ColorUtil.getInstance().getColor(this.viewType.getColor()));
            this.xyGraph.addTrace(trace);
            this.traces.add(trace);
        }
        return data;
    }

    public void checkDBList() {
        if (!this.isDefaultView) {
            return;
        }
        if (ActiveDbInfo.getInstance().getActiveDBInfo(this.serverId).hashCode() == this.prvActiveDBHash) {
            return;
        }
        this.prvActiveDBHash = ActiveDbInfo.getInstance().getActiveDBInfo(this.serverId).hashCode();
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                CubridSinglePeriodMultiView.this.dbListCombo.removeAll();
            }
        });
        if (!ActiveDbInfo.getInstance().isEmpty(this.serverId)) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    for (String dbName : ActiveDbInfo.getInstance().keySet(CubridSinglePeriodMultiView.this.serverId)) {
                        CubridSinglePeriodMultiView.this.dbListCombo.add(dbName);
                    }
                    CubridSinglePeriodMultiView.this.dbListCombo.setEnabled(true);
                }
            });
        } else {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    CubridSinglePeriodMultiView.this.dbListCombo.setEnabled(false);
                }
            });
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < CubridSinglePeriodMultiView.this.dbListCombo.getItemCount()) {
                    if (CubridSinglePeriodMultiView.this.dbListCombo.getItem(i).equals(CubridSinglePeriodMultiView.this.selectionDB)) {
                        CubridSinglePeriodMultiView.this.dbListCombo.select(i);
                        return;
                    }
                    ++i;
                }
                if (CubridSinglePeriodMultiView.this.dbListCombo.getItemCount() != 0) {
                    CubridSinglePeriodMultiView.this.dbListCombo.select(0);
                    CubridSinglePeriodMultiView.this.selectionDB = CubridSinglePeriodMultiView.this.dbListCombo.getItem(CubridSinglePeriodMultiView.this.dbListCombo.getSelectionIndex());
                }
            }
        });
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
            this.xyGraph.repaint();
        }
    }

    private void pastLoad() {
        ArrayList values;
        block5: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            values = new ArrayList();
            try {
                try {
                    MapPack param = new MapPack();
                    ListValue objHashLv = new ListValue();
                    objHashLv.add((long)ActiveDbInfo.getInstance().getObjectHash(this.serverId, this.selectionDB));
                    param.put("objHash", (Value)objHashLv);
                    param.put("counter", this.viewType.getCounterName());
                    param.put("stime", this.pastStime);
                    param.put("etime", this.pastEtime);
                    param.put("objName", ActiveDbInfo.getInstance().getObjectName(this.serverId, this.selectionDB));
                    tcp.process("CUBRID_DB_PERIOD_MULTI_DATA", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            MapPack mpack = (MapPack)in.readPack();
                            values.add(mpack);
                        }
                    });
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                CubridSinglePeriodMultiView.this.xyGraph.primaryXAxis.setRange(CubridSinglePeriodMultiView.this.pastStime, CubridSinglePeriodMultiView.this.pastEtime);
                for (MapPack mpack : values) {
                    ListValue time = mpack.getList("time");
                    ListValue value = mpack.getList("value");
                    if (time == null || time.size() < 1) continue;
                    CircularBufferDataProvider provider = CubridSinglePeriodMultiView.this.getDataProvider(CubridSinglePeriodMultiView.this.serverId);
                    provider.clearTrace();
                    int i = 0;
                    while (time != null && i < time.size()) {
                        CubridSinglePeriodMultiView.this.setTitleImage(Images.active);
                        long x = time.getLong(i);
                        long y = Long.parseLong(value.getString(i));
                        long prevY = 0L;
                        if (i != 0) {
                            prevY = Long.parseLong(value.getString(i - 1));
                        }
                        if (y >= 0L && prevY >= 0L) {
                            provider.addSample(new Sample(x, y));
                        }
                        ++i;
                    }
                    double max = ChartUtil.getMax(provider.iterator());
                    if (CubridSinglePeriodMultiView.this.viewType.isPercent()) {
                        CubridSinglePeriodMultiView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                        continue;
                    }
                    CubridSinglePeriodMultiView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
            }
        });
    }

    private void modifyData() {
        this.redraw();
        this.getDataProvider(this.serverId).clearTrace();
        Trace trace = this.traces.get(0);
        trace.setName(this.viewType.getTitle());
        trace.setTraceColor(ColorUtil.getInstance().getColor(this.viewType.getColor()));
        int bufferSize = (int)(this.TIME_RANGE / (long)REFRESH_INTERVAL) + 1;
        this.getDataProvider(this.serverId).setBufferSize(bufferSize);
    }
}

