/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.cubrid.ActiveDbInfo;
import scouter.client.cubrid.CubridMenuUtil;
import scouter.client.cubrid.CubridSingleItem;
import scouter.client.cubrid.CubridTypeShotPeriod;
import scouter.client.cubrid.actions.AlertSettingDialog;
import scouter.client.listeners.RangeMouseListener;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.StringUtil;

public class CubridSingleRealTimeMultiView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = CubridSingleRealTimeMultiView.class.getName();
    int serverId;
    int objhash;
    CubridSingleItem viewType;
    RefreshThread thread;
    static int REFRESH_INTERVAL = 5000;
    FigureCanvas canvas;
    XYGraph xyGraph;
    Combo dbListCombo;
    Combo dbCounterCombo;
    Combo timeRangeCombo;
    Menu contextMenu;
    String selectionDB;
    boolean isDefaultView = false;
    Trace nearestTrace;
    ArrayList<Trace> traces = new ArrayList();
    protected Map<Integer, CircularBufferDataProvider> datas = new HashMap<Integer, CircularBufferDataProvider>();
    String date;
    long stime;
    long etime;
    long timeRange;
    long pastStime;
    long pastEtime;
    int prvActiveDBHash;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = StringUtil.split((String)secId, (String)"&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.selectionDB = CastUtil.cString((Object)ids[1]);
        int ordinal = CastUtil.cint((Object)ids[2]);
        this.timeRange = CastUtil.clong((Object)ids[3]);
        this.viewType = CubridSingleItem.values()[ordinal];
        if (this.selectionDB.equals("default")) {
            this.isDefaultView = true;
        }
    }

    public void createPartControl(Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        if (this.viewType != null && server != null) {
            this.setPartName("SingleRealTimeMultiView " + this.viewType.getTitle() + " [" + server.getName() + "]");
        }
        final IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Warning Alert Setting", ImageUtil.getImageDescriptor(Images.preference)){

            public void run() {
                AlertSettingDialog dialog = new AlertSettingDialog(window.getShell().getDisplay(), CubridSingleRealTimeMultiView.this.serverId, CubridSingleRealTimeMultiView.this.dbCounterCombo.getSelectionIndex());
                dialog.show();
            }
        });
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.dbCounterCombo = new Combo(parent, 12);
        this.dbCounterCombo.setLayoutData((Object)new GridData(4));
        if (!this.isDefaultView) {
            this.dbCounterCombo.setEnabled(false);
        }
        CubridSingleItem[] cubridSingleItemArray = CubridSingleItem.values();
        int n = cubridSingleItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CubridSingleItem counterName = cubridSingleItemArray[n2];
            this.dbCounterCombo.add(counterName.getTitle());
            if (counterName.ordinal() == this.viewType.ordinal()) {
                this.dbCounterCombo.select(this.viewType.ordinal());
            }
            ++n2;
        }
        this.dbCounterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ExUtil.exec((Composite)CubridSingleRealTimeMultiView.this.canvas, new Runnable(){

                    @Override
                    public void run() {
                        (this).CubridSingleRealTimeMultiView.this.viewType = CubridSingleItem.values()[(this).CubridSingleRealTimeMultiView.this.dbCounterCombo.getSelectionIndex()];
                        CubridSingleRealTimeMultiView.this.modifyData(true);
                        if ((this).CubridSingleRealTimeMultiView.this.viewType.getInfoType() == CubridSingleItem.InfoType.BROKER_INFO) {
                            (this).CubridSingleRealTimeMultiView.this.dbListCombo.setEnabled(false);
                            (this).CubridSingleRealTimeMultiView.this.dbListCombo.removeAll();
                            (this).CubridSingleRealTimeMultiView.this.dbListCombo.add(CubridSingleItem.InfoType.BROKER_INFO.getTitle());
                            (this).CubridSingleRealTimeMultiView.this.dbListCombo.select(0);
                        } else {
                            if ((this).CubridSingleRealTimeMultiView.this.isDefaultView) {
                                (this).CubridSingleRealTimeMultiView.this.dbListCombo.setEnabled(true);
                            }
                            (this).CubridSingleRealTimeMultiView.this.dbListCombo.removeAll();
                            (this).CubridSingleRealTimeMultiView.this.prvActiveDBHash = -1;
                            CubridSingleRealTimeMultiView.this.checkDBList();
                        }
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.dbListCombo = new Combo(parent, 12);
        this.dbListCombo.setLayoutData((Object)new GridData(131072));
        if (!this.isDefaultView) {
            this.dbListCombo.add(this.selectionDB);
            this.dbListCombo.select(0);
            this.dbListCombo.setEnabled(false);
        }
        if (this.viewType.getInfoType() == CubridSingleItem.InfoType.BROKER_INFO) {
            this.dbListCombo.setEnabled(false);
            this.dbListCombo.removeAll();
            this.dbListCombo.add("BROKER_INFO");
            this.dbListCombo.select(0);
        }
        this.dbListCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ExUtil.exec((Composite)CubridSingleRealTimeMultiView.this.canvas, new Runnable(){

                    @Override
                    public void run() {
                        (this).CubridSingleRealTimeMultiView.this.selectionDB = (this).CubridSingleRealTimeMultiView.this.dbListCombo.getText();
                        CubridSingleRealTimeMultiView.this.modifyData(true);
                        (this).CubridSingleRealTimeMultiView.this.thread.interrupt();
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.timeRangeCombo = new Combo(parent, 12);
        ArrayList<String> minuteStrList = new ArrayList<String>();
        CubridTypeShotPeriod[] cubridTypeShotPeriodArray = CubridTypeShotPeriod.values();
        int n3 = cubridTypeShotPeriodArray.length;
        n = 0;
        while (n < n3) {
            CubridTypeShotPeriod minute = cubridTypeShotPeriodArray[n];
            minuteStrList.add(minute.getLabel());
            ++n;
        }
        this.timeRangeCombo.setItems(minuteStrList.toArray(new String[CubridTypeShotPeriod.values().length]));
        CubridTypeShotPeriod m = CubridTypeShotPeriod.fromTime(this.timeRange);
        this.timeRangeCombo.select(m.ordinal());
        this.timeRangeCombo.setLayoutData((Object)new GridData(16384));
        this.timeRangeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                CubridSingleRealTimeMultiView.this.timeRange = CubridTypeShotPeriod.values()[CubridSingleRealTimeMultiView.this.timeRangeCombo.getSelectionIndex()].getTime();
                CubridSingleRealTimeMultiView.this.modifyData(false);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        GridData gdataXyGraph = new GridData(1808);
        gdataXyGraph.horizontalSpan = 3;
        this.canvas.setLayoutData((Object)gdataXyGraph);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                Rectangle r = CubridSingleRealTimeMultiView.this.canvas.getClientArea();
                CubridSingleRealTimeMultiView.this.xyGraph.setSize(r.width, r.height);
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(true);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setFormatPattern("HH:mm:ss");
        if (this.viewType.isPercent()) {
            this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
        }
        this.xyGraph.primaryYAxis.setFormatPattern("#,##0");
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.primaryYAxis.addMouseListener((MouseListener)new RangeMouseListener(this.getViewSite().getShell(), this.xyGraph.primaryYAxis));
        final DefaultToolTip toolTip = new DefaultToolTip((Control)this.canvas, 1, true);
        toolTip.setFont(new Font(null, "Arial", 10, 1));
        toolTip.setBackgroundColor(Display.getCurrent().getSystemColor(29));
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent arg0) {
            }
        });
        this.canvas.addMouseListener(new org.eclipse.swt.events.MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (CubridSingleRealTimeMultiView.this.nearestTrace != null) {
                    CubridSingleRealTimeMultiView.this.nearestTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
                    CubridSingleRealTimeMultiView.this.nearestTrace = null;
                }
                toolTip.hide();
            }

            public void mouseDown(MouseEvent e) {
                double x = CubridSingleRealTimeMultiView.this.xyGraph.primaryXAxis.getPositionValue(e.x, false);
                double y = CubridSingleRealTimeMultiView.this.xyGraph.primaryYAxis.getPositionValue(e.y, false);
                if (x < 0.0 || y < 0.0) {
                    return;
                }
                double minDistance = 30.0;
                long time = 0L;
                double value = 0.0;
                for (Trace t : CubridSingleRealTimeMultiView.this.traces) {
                    int y2;
                    int x2;
                    double distance;
                    ISample s = ScouterUtil.getNearestPoint(t.getDataProvider(), x);
                    if (s == null || !(minDistance > (distance = ScouterUtil.getPointDistance(e.x, e.y, x2 = CubridSingleRealTimeMultiView.this.xyGraph.primaryXAxis.getValuePosition(s.getXValue(), false), y2 = CubridSingleRealTimeMultiView.this.xyGraph.primaryYAxis.getValuePosition(s.getYValue(), false))))) continue;
                    minDistance = distance;
                    CubridSingleRealTimeMultiView.this.nearestTrace = t;
                    time = (long)s.getXValue();
                    value = s.getYValue();
                }
                if (CubridSingleRealTimeMultiView.this.nearestTrace != null) {
                    int width = PManager.getInstance().getInt("lineWidth");
                    CubridSingleRealTimeMultiView.this.nearestTrace.setLineWidth(width + 2);
                    toolTip.setText(String.valueOf(CubridSingleRealTimeMultiView.this.nearestTrace.getName()) + "\nTime : " + DateUtil.format((long)time, (String)"HH:mm:ss") + "\nValue : " + FormatUtil.print((Object)value, (String)"#,###.##"));
                    toolTip.show(new Point(e.x, e.y));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        CubridMenuUtil.createAddViewContextMenu(this.getSite().getWorkbenchWindow(), this.serverId, this.canvas);
        this.thread = new RefreshThread(this, REFRESH_INTERVAL);
        this.thread.start();
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void refresh() {
        Value v;
        block11: {
            if (ActiveDbInfo.getInstance() == null || ActiveDbInfo.getInstance().getDbList(this.serverId) == null) {
                return;
            }
            if (this.viewType.getInfoType() == CubridSingleItem.InfoType.BROKER_INFO) {
                if (ActiveDbInfo.getInstance().getDbList(this.serverId).isEmpty()) return;
                this.selectionDB = ActiveDbInfo.getInstance().getDbList(this.serverId).get(0);
            } else {
                if (this.selectionDB.equals("default")) {
                    this.checkDBList();
                    return;
                }
                this.checkDBList();
            }
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            v = null;
            try {
                try {
                    MapPack param = new MapPack();
                    ListValue objHashLv = new ListValue();
                    objHashLv.add((long)ActiveDbInfo.getInstance().getObjectHash(this.serverId, this.selectionDB));
                    param.put("objHash", (Value)objHashLv);
                    param.put("counter", this.viewType.getCounterName());
                    v = tcp.getSingleValue("CUBRID_DB_REALTIME_MULTI_DATA", (Pack)param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ConsoleProxy.errorSafe(e.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (v == null) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    CubridSingleRealTimeMultiView.this.setTitleImage(Images.inactive);
                    long now = TimeUtil.getCurrentTime(CubridSingleRealTimeMultiView.this.serverId);
                    long stime = now - CubridSingleRealTimeMultiView.this.timeRange;
                    CubridSingleRealTimeMultiView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                }
            });
            return;
        } else {
            MapValue value = (MapValue)v;
            final long data = value.getLong(this.viewType.getCounterName());
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    CubridSingleRealTimeMultiView.this.setTitleImage(Images.active);
                    long now = TimeUtil.getCurrentTime(CubridSingleRealTimeMultiView.this.serverId);
                    long stime = now - CubridSingleRealTimeMultiView.this.timeRange;
                    CubridSingleRealTimeMultiView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                    CubridSingleRealTimeMultiView.this.getDataProvider(CubridSingleRealTimeMultiView.this.serverId).addSample(new Sample(now, data));
                    if (CubridSingleRealTimeMultiView.this.viewType.isPercent()) {
                        CubridSingleRealTimeMultiView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                    } else {
                        double max = ChartUtil.getMax(CubridSingleRealTimeMultiView.this.getDataProvider(CubridSingleRealTimeMultiView.this.serverId).iterator());
                        CubridSingleRealTimeMultiView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                    }
                }
            });
        }
    }

    private CircularBufferDataProvider getDataProvider(int serverId) {
        CircularBufferDataProvider data = this.datas.get(serverId);
        if (data == null) {
            data = new CircularBufferDataProvider(true);
            this.datas.put(serverId, data);
            int bufferSize = (int)(this.timeRange / (long)REFRESH_INTERVAL) + 1;
            data.setBufferSize(bufferSize);
            data.setCurrentXDataArray(new double[0]);
            data.setCurrentYDataArray(new double[0]);
            Trace trace = new Trace(this.viewType.getTitle(), this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, data);
            trace.setPointStyle(Trace.PointStyle.NONE);
            trace.setAreaAlpha(90);
            trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
            trace.setTraceType(this.viewType.getTraceType());
            trace.setTraceColor(ColorUtil.getInstance().getColor(this.viewType.getColor()));
            this.xyGraph.addTrace(trace);
            this.traces.add(trace);
        }
        return data;
    }

    public void checkDBList() {
        if (!this.isDefaultView) {
            return;
        }
        if (ActiveDbInfo.getInstance().getActiveDBInfo(this.serverId) == null) {
            return;
        }
        if (ActiveDbInfo.getInstance().getActiveDBInfo(this.serverId).hashCode() == this.prvActiveDBHash) {
            return;
        }
        this.prvActiveDBHash = ActiveDbInfo.getInstance().getActiveDBInfo(this.serverId).hashCode();
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                CubridSingleRealTimeMultiView.this.dbListCombo.removeAll();
            }
        });
        if (!ActiveDbInfo.getInstance().isEmpty(this.serverId)) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    for (String dbName : ActiveDbInfo.getInstance().keySet(CubridSingleRealTimeMultiView.this.serverId)) {
                        CubridSingleRealTimeMultiView.this.dbListCombo.add(dbName);
                    }
                    CubridSingleRealTimeMultiView.this.dbListCombo.setEnabled(true);
                }
            });
        } else {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    CubridSingleRealTimeMultiView.this.dbListCombo.setEnabled(false);
                }
            });
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < CubridSingleRealTimeMultiView.this.dbListCombo.getItemCount()) {
                    if (CubridSingleRealTimeMultiView.this.dbListCombo.getItem(i).equals(CubridSingleRealTimeMultiView.this.selectionDB)) {
                        CubridSingleRealTimeMultiView.this.dbListCombo.select(i);
                        return;
                    }
                    ++i;
                }
                if (CubridSingleRealTimeMultiView.this.dbListCombo.getItemCount() != 0) {
                    CubridSingleRealTimeMultiView.this.dbListCombo.select(0);
                    CubridSingleRealTimeMultiView.this.selectionDB = CubridSingleRealTimeMultiView.this.dbListCombo.getItem(CubridSingleRealTimeMultiView.this.dbListCombo.getSelectionIndex());
                }
            }
        });
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
            this.xyGraph.repaint();
        }
    }

    private void modifyData(boolean clean) {
        this.redraw();
        if (clean) {
            this.getDataProvider(this.serverId).clearTrace();
        }
        Trace trace = this.traces.get(0);
        trace.setName(this.viewType.getTitle());
        trace.setTraceType(this.viewType.getTraceType());
        trace.setTraceColor(ColorUtil.getInstance().getColor(this.viewType.getColor()));
        int bufferSize = (int)(this.timeRange / (long)REFRESH_INTERVAL) + 1;
        this.getDataProvider(this.serverId).setBufferSize(bufferSize);
    }
}

