/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.cubrid.ActiveDbInfo;
import scouter.client.cubrid.actions.AddLongTransactionList;
import scouter.client.model.AgentModelThread;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ExUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.StatusPack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

public class CubridSpaceDbView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = CubridSpaceDbView.class.getName();
    static long TIME_RANGE = 300000L;
    static int REFRESH_INTERVAL = 5000;
    int serverId;
    private Composite tableComposite;
    private Table table;
    private TableItem tableItem;
    private ArrayList<DbSpace> dbSpaceData = new ArrayList();
    private Composite composite;
    Combo dbListCombo;
    boolean isDefaultView = false;
    RefreshThread thread;
    String date;
    long stime;
    long etime;
    MapValue prvData;
    String selectionDB;
    int prvActiveDBHash;
    private static final String DBSPACE_PERM_AND_PERM_TOTAL = "perm_and_perm_total";
    private static final String DBSPACE_PERM_AND_PERM_USED = "perm_and_perm_used";
    private static final String DBSPACE_PERM_AND_TEMP_TOTAL = "perm_and_temp_total";
    private static final String DBSPACE_PERM_AND_TEMP_USED = "perm_and_temp_used";
    private static final String DBSPACE_TEMP_AND_TEMP_TOTAL = "temp_and_temp_total";
    private static final String DBSPACE_TEMP_AND_TEMP_USED = "temp_and_temp_used";

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.selectionDB = CastUtil.cString((Object)ids[1]);
        if (this.selectionDB.equals("default")) {
            this.isDefaultView = true;
        }
        this.makeDbSpaceData();
    }

    public void createPartControl(Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        if (server != null) {
            this.setPartName("CUBRID DBSpaceInfo[" + server.getName() + "]");
        } else {
            this.setPartName("CUBRID DBSpaceInfo");
        }
        this.composite = parent;
        GridLayout layout = new GridLayout(3, true);
        parent.setLayout((Layout)layout);
        this.dbListCombo = new Combo(this.composite, 12);
        if (!this.isDefaultView) {
            this.dbListCombo.add(this.selectionDB);
            this.dbListCombo.select(0);
            this.dbListCombo.setEnabled(false);
        }
        this.dbListCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ExUtil.exec(CubridSpaceDbView.this.composite, new Runnable(){

                    @Override
                    public void run() {
                        (this).CubridSpaceDbView.this.selectionDB = (this).CubridSpaceDbView.this.dbListCombo.getItem((this).CubridSpaceDbView.this.dbListCombo.getSelectionIndex());
                        (this).CubridSpaceDbView.this.thread.interrupt();
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.tableComposite = new Composite(this.composite, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 3;
        this.tableComposite.setLayoutData((Object)data);
        this.tableComposite.setLayout((Layout)new FillLayout());
        this.table = new Table(this.tableComposite, 2048);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.createContextMenu();
        int i = 0;
        while (i < ColumnEnum.values().length) {
            new TableColumn(this.table, 0);
            this.table.getColumn(i).setText(ColumnEnum.values()[i].getTitle());
            ++i;
        }
        this.tableItem = new TableItem(this.table, 0);
        this.tableItem.setText(ListTypeEnum.TYPE1.getTypeArray());
        this.tableItem = new TableItem(this.table, 0);
        this.tableItem.setText(ListTypeEnum.TYPE2.getTypeArray());
        this.tableItem = new TableItem(this.table, 0);
        this.tableItem.setText(ListTypeEnum.TYPE3.getTypeArray());
        this.table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == 2) {
                    GC gc = event.gc;
                    int percent = 0;
                    int total = 0;
                    int used = 0;
                    TableItem item = (TableItem)event.item;
                    int i = 0;
                    while (i < CubridSpaceDbView.this.dbSpaceData.size()) {
                        if (item.getText(0).equals(CubridSpaceDbView.this.dbSpaceData.get((int)i).listType.getPurpose()) && item.getText(1).equals(CubridSpaceDbView.this.dbSpaceData.get((int)i).listType.getType())) {
                            percent = CubridSpaceDbView.this.dbSpaceData.get(i).getPercent();
                            total = CubridSpaceDbView.this.dbSpaceData.get(i).getTotal();
                            used = CubridSpaceDbView.this.dbSpaceData.get(i).getUsed();
                        }
                        ++i;
                    }
                    Color foreground = gc.getForeground();
                    Color background = gc.getBackground();
                    if (percent < 90) {
                        gc.setForeground(Display.getCurrent().getSystemColor(6));
                        gc.setBackground(Display.getCurrent().getSystemColor(5));
                    } else {
                        gc.setForeground(Display.getCurrent().getSystemColor(4));
                        gc.setBackground(Display.getCurrent().getSystemColor(3));
                    }
                    int width = (CubridSpaceDbView.this.table.getColumn(event.index).getWidth() - 1) * percent / 100;
                    gc.fillGradientRectangle(event.x, event.y, width, event.height, true);
                    Rectangle rect2 = new Rectangle(event.x, event.y, width - 1, event.height - 1);
                    gc.drawRectangle(rect2);
                    gc.setForeground(Display.getCurrent().getSystemColor(24));
                    String text = String.valueOf(percent) + "%" + " ( " + used + "MB" + " / " + total + "MB )";
                    Point size = event.gc.textExtent(text);
                    int offset = Math.max(0, (event.height - size.y) / 2);
                    gc.drawText(text, event.x + 5, event.y + offset, true);
                    gc.setForeground(background);
                    gc.setBackground(foreground);
                }
            }
        });
        i = 0;
        while (i < ColumnEnum.values().length) {
            this.table.getColumn(i).pack();
            this.table.getColumn(i).setToolTipText("aaaa");
            this.table.getColumn(2).setWidth(this.table.getBounds().width - this.table.getColumn(0).getWidth() - this.table.getColumn(1).getWidth() - 2);
            ++i;
        }
        this.thread = new RefreshThread(this, REFRESH_INTERVAL);
        this.thread.start();
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        this.table.setMenu(manager.createContextMenu((Control)this.table));
        manager.add((IAction)new Action("&Add DBSpaceInfo", ImageDescriptor.createFromImage((Image)Images.add)){

            public void run() {
                final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                AddLongTransactionList dialog = new AddLongTransactionList(window.getShell().getDisplay(), CubridSpaceDbView.this.serverId, new AddLongTransactionList.IAddLongTransactionList(){

                    @Override
                    public void onPressedOk(String dbName) {
                        try {
                            window.getActivePage().showView(ID, String.valueOf((this).CubridSpaceDbView.this.serverId) + "&" + dbName, 1);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onPressedCancel() {
                    }
                });
                dialog.show();
            }
        });
    }

    @Override
    public void refresh() {
        block10: {
            ExUtil.exec((Composite)this.table, new Runnable(){

                @Override
                public void run() {
                }
            });
            long now = TimeUtil.getCurrentTime(this.serverId);
            this.date = DateUtil.yyyymmdd((long)now);
            this.stime = now - TIME_RANGE;
            this.etime = now;
            if (this.isDefaultView) {
                this.checkDBList();
            }
            if (this.selectionDB == null || this.selectionDB.isEmpty()) {
                return;
            }
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            Pack p = null;
            try {
                try {
                    MapPack param = new MapPack();
                    ListValue objHashLv = AgentModelThread.getInstance().getLiveObjHashLV(this.serverId, "cubridagent");
                    StatusPack sp = null;
                    MapValue mv = null;
                    if (objHashLv.size() > 0) {
                        param.put("objHash", (Value)objHashLv);
                        param.put("date", this.date);
                        param.put("stime", this.stime);
                        param.put("etime", this.etime);
                        param.put("time", now);
                        param.put("key", "cubrid_server_info_" + this.selectionDB);
                        p = tcp.getSingle("CUBRID_DB_SERVER_INFO", (Pack)param);
                        if (p != null) {
                            sp = (StatusPack)p;
                            mv = sp.data;
                        }
                        if (mv != null) {
                            this.dbSpaceData.get((int)ListTypeEnum.TYPE1.ordinal()).total = Integer.parseInt(mv.getText(DBSPACE_PERM_AND_PERM_TOTAL));
                            this.dbSpaceData.get((int)ListTypeEnum.TYPE1.ordinal()).used = Integer.parseInt(mv.getText(DBSPACE_PERM_AND_PERM_USED));
                            this.dbSpaceData.get((int)ListTypeEnum.TYPE2.ordinal()).total = Integer.parseInt(mv.getText(DBSPACE_PERM_AND_TEMP_TOTAL));
                            this.dbSpaceData.get((int)ListTypeEnum.TYPE2.ordinal()).used = Integer.parseInt(mv.getText(DBSPACE_PERM_AND_TEMP_USED));
                            this.dbSpaceData.get((int)ListTypeEnum.TYPE3.ordinal()).total = Integer.parseInt(mv.getText(DBSPACE_TEMP_AND_TEMP_TOTAL));
                            this.dbSpaceData.get((int)ListTypeEnum.TYPE3.ordinal()).used = Integer.parseInt(mv.getText(DBSPACE_TEMP_AND_TEMP_USED));
                        }
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        ExUtil.exec((Composite)this.table, new Runnable(){

            @Override
            public void run() {
                CubridSpaceDbView.this.table.setSize(CubridSpaceDbView.this.table.getSize().x, CubridSpaceDbView.this.table.getSize().y + 1);
                CubridSpaceDbView.this.table.setSize(CubridSpaceDbView.this.table.getSize().x, CubridSpaceDbView.this.table.getSize().y - 1);
                CubridSpaceDbView.this.table.getColumn(2).setWidth(CubridSpaceDbView.this.table.getBounds().width - CubridSpaceDbView.this.table.getColumn(0).getWidth() - CubridSpaceDbView.this.table.getColumn(1).getWidth() - 4);
            }
        });
    }

    public void checkDBList() {
        if (ActiveDbInfo.getInstance().getActiveDBInfo(this.serverId) == null) {
            return;
        }
        if (ActiveDbInfo.getInstance().getActiveDBInfo(this.serverId).hashCode() == this.prvActiveDBHash) {
            return;
        }
        this.prvActiveDBHash = ActiveDbInfo.getInstance().getActiveDBInfo(this.serverId).hashCode();
        ExUtil.exec(this.composite, new Runnable(){

            @Override
            public void run() {
                CubridSpaceDbView.this.dbListCombo.removeAll();
            }
        });
        if (!ActiveDbInfo.getInstance().isEmpty(this.serverId)) {
            ExUtil.exec(this.composite, new Runnable(){

                @Override
                public void run() {
                    for (String dbName : ActiveDbInfo.getInstance().keySet(CubridSpaceDbView.this.serverId)) {
                        CubridSpaceDbView.this.dbListCombo.add(dbName);
                    }
                    CubridSpaceDbView.this.dbListCombo.setEnabled(true);
                }
            });
        } else {
            ExUtil.exec(this.composite, new Runnable(){

                @Override
                public void run() {
                    CubridSpaceDbView.this.dbListCombo.setEnabled(false);
                }
            });
        }
        ExUtil.exec(this.composite, new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < CubridSpaceDbView.this.dbListCombo.getItemCount()) {
                    if (CubridSpaceDbView.this.dbListCombo.getItem(i).equals(CubridSpaceDbView.this.selectionDB)) {
                        CubridSpaceDbView.this.dbListCombo.select(i);
                        return;
                    }
                    ++i;
                }
                if (CubridSpaceDbView.this.dbListCombo.getItemCount() != 0) {
                    CubridSpaceDbView.this.dbListCombo.select(0);
                    CubridSpaceDbView.this.selectionDB = CubridSpaceDbView.this.dbListCombo.getItem(CubridSpaceDbView.this.dbListCombo.getSelectionIndex());
                }
            }
        });
    }

    private void makeDbSpaceData() {
        DbSpace type1 = new DbSpace(ListTypeEnum.TYPE1, 0, 0);
        DbSpace type2 = new DbSpace(ListTypeEnum.TYPE2, 0, 0);
        DbSpace type3 = new DbSpace(ListTypeEnum.TYPE3, 0, 0);
        this.dbSpaceData.add(type1);
        this.dbSpaceData.add(type2);
        this.dbSpaceData.add(type3);
    }

    public void setFocus() {
    }

    static enum ColumnEnum {
        PURPOSE("Purpose"),
        TYPE("Type"),
        FREE_PERCENTAGE("Free");

        private final String title;

        private ColumnEnum(String text) {
            this.title = text;
        }

        public String getTitle() {
            return this.title;
        }
    }

    class DbSpace {
        ListTypeEnum listType;
        int total;
        int used;

        public DbSpace(ListTypeEnum listType, int total, int used) {
            this.listType = listType;
            this.total = total;
            this.used = used;
        }

        public String getPurpose() {
            return this.listType.getPurpose();
        }

        public String getType() {
            return this.listType.getType();
        }

        public int getTotal() {
            return this.total;
        }

        public int getUsed() {
            return this.used;
        }

        public void setTotal(int value) {
            this.total = value;
        }

        public void setUsed(int value) {
            this.used = value;
        }

        public int getPercent() {
            if (this.used != 0 && this.total != 0) {
                return (int)((float)this.used / (float)this.total * 100.0f);
            }
            return 0;
        }

        public String getString() {
            return "listType purpose : " + this.listType.getPurpose() + " type : " + this.listType.getType() + " total : " + Integer.toString(this.total) + " used : " + Integer.toString(this.used) + " percent : " + this.getPercent();
        }
    }

    static enum ListTypeEnum {
        TYPE1("PEMANENT", "PEMANENT"),
        TYPE2("PEMANENT", "TEMPORARY"),
        TYPE3("TEMPORARY", "TEMPORARY");

        private final String purpose;
        private final String type;

        private ListTypeEnum(String purpose, String type) {
            this.purpose = purpose;
            this.type = type;
        }

        public String getPurpose() {
            return this.purpose;
        }

        public String getType() {
            return this.type;
        }

        public String[] getTypeArray() {
            return new String[]{this.purpose, this.type};
        }
    }
}

