/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.dashboard.figure;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import scouter.client.Images;
import scouter.client.model.AgentObject;
import scouter.client.server.ServerManager;
import scouter.client.util.ScouterUtil;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.AlertPack;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.FormatUtil;

public class AgentObjectFigure
extends Figure {
    public AgentObjectFigure(AgentObject ao, Font font) {
        this(ao, font, null);
    }

    public AgentObjectFigure(AgentObject ao, Font font, AlertPack alertPack) {
        ToolbarLayout layout = new ToolbarLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.setOpaque(false);
        Image img = null;
        if (!ao.isAlive()) {
            img = Images.getObject48Icon(ao.getObjType(), false, ao.getServerId());
        } else if (alertPack != null) {
            img = Images.getObjectAlert48Icon(ao.getObjType(), ao.getServerId());
            Label alertTitle = new Label(alertPack.title, null);
            alertTitle.setFont(font);
            this.add((IFigure)alertTitle);
        } else {
            img = Images.getObject48Icon(ao.getObjType(), ao.isAlive(), ao.getServerId());
        }
        if (img == null || img == Images.folder_48) {
            img = Images.getObjectIcon(ao.getObjType(), ao.isAlive(), ao.getServerId());
        }
        this.add((IFigure)new ImageFigure(img));
        Label title = new Label(ao.getDisplayName(), null);
        this.add((IFigure)title);
        Value v = ao.getMasterCounter();
        if (v != null && ao.isAlive()) {
            CounterEngine engine = ServerManager.getInstance().getServer(ao.getServerId()).getCounterEngine();
            String unit = engine.getMasterCounterUnit(ao.getObjType());
            String value = unit != null && "bytes".equals(unit) ? ScouterUtil.humanReadableByteCount(CastUtil.cdouble((Object)v), true) : String.valueOf(FormatUtil.print((Object)v, (String)"#,###")) + " " + unit;
            Label masterCounter = new Label(value, null);
            masterCounter.setFont(font);
            this.add((IFigure)masterCounter);
        }
        this.setSize(-1, -1);
    }
}

