/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.group;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.RCPUtil;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.TextValue;
import scouter.lang.value.Value;
import scouter.util.CacheTable;
import scouter.util.FileUtil;
import scouter.util.StringUtil;

public class GroupManager {
    private File groupFile = new File(RCPUtil.getWorkingDirectory(), "groupfile");
    private static volatile GroupManager instance;
    private Set<String> reserved = new HashSet<String>();
    private MapPack objGroupMap;
    private MapValue groupTypeMap;
    private static final String KEY_OBJTYPE = "_objType_";
    public static final String OTHERS = "Others";
    private CacheTable<String, Set> groupObjTable = new CacheTable().setDefaultKeepTime(10000L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GroupManager getInstance() {
        if (instance != null) return instance;
        Class<GroupManager> clazz = GroupManager.class;
        synchronized (GroupManager.class) {
            if (instance != null) return instance;
            instance = new GroupManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private GroupManager() {
        this.reserved.add(KEY_OBJTYPE);
        this.reserved.add(OTHERS);
        this.loadGroupFile();
    }

    private synchronized void loadGroupFile() {
        try {
            byte[] bytes;
            if (this.groupFile.exists() && (bytes = FileUtil.readAll((File)this.groupFile)) != null) {
                this.objGroupMap = (MapPack)new DataInputX(bytes).readPack();
                this.groupTypeMap = (MapValue)this.objGroupMap.get(KEY_OBJTYPE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.objGroupMap == null) {
            this.objGroupMap = new MapPack();
            this.groupTypeMap = new MapValue();
            this.objGroupMap.put(KEY_OBJTYPE, (Value)this.groupTypeMap);
        }
    }

    private void saveGroupFile() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] b = new DataOutputX().writePack((Pack)GroupManager.this.objGroupMap).toByteArray();
                    if (GroupManager.this.groupFile.exists()) {
                        GroupManager.this.groupFile.delete();
                    }
                    FileUtil.save((File)GroupManager.this.groupFile, (byte[])b);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public boolean addGroup(String objType, String groupName) {
        if (this.reserved.contains(groupName)) {
            return false;
        }
        if (StringUtil.isEmpty((String)(groupName = groupName.trim()))) {
            return false;
        }
        this.groupTypeMap.put(groupName, objType);
        this.saveGroupFile();
        return true;
    }

    public boolean addObject(int objHash, String groupName) {
        if (this.groupTypeMap.get(groupName) != null) {
            this.addObjGroupMap(objHash, groupName);
            this.saveGroupFile();
            return true;
        }
        return false;
    }

    public boolean addObject(int[] objHashs, String groupName) {
        if (this.groupTypeMap.get(groupName) != null) {
            int[] nArray = objHashs;
            int n = objHashs.length;
            int n2 = 0;
            while (n2 < n) {
                int objHash = nArray[n2];
                this.addObjGroupMap(objHash, groupName);
                ++n2;
            }
            this.saveGroupFile();
            return true;
        }
        return false;
    }

    private void addObjGroupMap(int objHash, String groupName) {
        String objStr = String.valueOf(objHash);
        Value v2 = this.objGroupMap.get(objStr);
        if (v2 != null && v2 instanceof ListValue) {
            ListValue lv = (ListValue)v2;
            lv.add(groupName);
        } else {
            ListValue lv = this.objGroupMap.newList(objStr);
            lv.add(groupName);
        }
    }

    public List<String> listGroup() {
        ArrayList<String> groupList = new ArrayList<String>();
        Enumeration groups = this.groupTypeMap.keys();
        while (groups.hasMoreElements()) {
            String name = (String)groups.nextElement();
            groupList.add(name);
        }
        return groupList;
    }

    public Set<String> getObjGroups(int objHash) {
        ArrayList<TextValue> groupList = new ArrayList<TextValue>();
        HashSet<String> groups = new HashSet<String>();
        Value v = this.objGroupMap.get(String.valueOf(objHash));
        if (v != null && v instanceof ListValue) {
            ListValue lv = (ListValue)v;
            int i = 0;
            while (i < lv.size()) {
                TextValue groupName = (TextValue)lv.get(i);
                if (this.groupTypeMap.containsKey(groupName.value)) {
                    groupList.add(groupName);
                    groups.add(groupName.value);
                }
                ++i;
            }
            this.objGroupMap.put(String.valueOf(objHash), (Value)new ListValue(groupList));
        }
        return groups;
    }

    public String getGroupObjType(String groupName) {
        return this.groupTypeMap.getText(groupName);
    }

    public Set<String> getObjTypeList() {
        LinkedHashSet<String> typeSet = new LinkedHashSet<String>();
        Enumeration groupList = this.groupTypeMap.keys();
        while (groupList.hasMoreElements()) {
            String group = (String)groupList.nextElement();
            String objType = this.groupTypeMap.getText(group);
            if (objType == null) continue;
            typeSet.add(objType);
        }
        return typeSet;
    }

    public void removeGroup(String groupName) {
        if (this.groupTypeMap.remove(groupName) != null) {
            this.saveGroupFile();
        }
    }

    private void removeObject(int objHash, String groupName) {
        Value v = this.objGroupMap.get(String.valueOf(objHash));
        if (v != null && v instanceof ListValue) {
            ListValue groups = (ListValue)v;
            ListValue newLv = new ListValue();
            int i = 0;
            while (i < groups.size()) {
                String name = groups.getString(i);
                if (!groupName.equals(name)) {
                    newLv.add(name);
                }
                ++i;
            }
            this.objGroupMap.put(String.valueOf(objHash), (Value)newLv);
        }
    }

    public void removeObject(int[] objHashs, String groupName) {
        int[] nArray = objHashs;
        int n = objHashs.length;
        int n2 = 0;
        while (n2 < n) {
            int objHash = nArray[n2];
            this.removeObject(objHash, groupName);
            ++n2;
        }
        this.saveGroupFile();
    }

    public void assginGroups(int objHash, String[] groups) {
        ListValue groupList = new ListValue();
        String[] stringArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            groupList.add(group);
            ++n2;
        }
        this.objGroupMap.put(String.valueOf(objHash), (Value)groupList);
        this.saveGroupFile();
    }

    public Set<String> getGroupsByType(String objType) {
        HashSet<String> groupSet = new HashSet<String>();
        Enumeration names = this.groupTypeMap.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!objType.equals(this.groupTypeMap.getText(name))) continue;
            groupSet.add(name);
        }
        return groupSet;
    }

    public Set<Integer> getObjectsByGroup(String grpName) {
        HashSet<Integer> objSet = (HashSet<Integer>)this.groupObjTable.get((Object)grpName);
        if (objSet != null) {
            return objSet;
        }
        objSet = new HashSet<Integer>();
        Iterator keys = this.objGroupMap.keys();
        block0: while (keys.hasNext()) {
            String objHash = (String)keys.next();
            Value v = this.objGroupMap.get(objHash);
            if (v == null || !(v instanceof ListValue)) continue;
            ListValue groupLv = (ListValue)v;
            int i = 0;
            while (i < groupLv.size()) {
                if (grpName.equals(groupLv.getString(i))) {
                    objSet.add(Integer.valueOf(objHash));
                    continue block0;
                }
                ++i;
            }
        }
        this.groupObjTable.put((Object)grpName, objSet);
        return objSet;
    }

    public void printAll() {
        System.out.println("********************************");
        System.out.println(this.objGroupMap);
        System.out.println("********************************");
        ConsoleProxy.infoSafe(this.objGroupMap.toString());
    }
}

