/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.group.view;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.group.GroupManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.util.ConsoleProxy;
import scouter.client.views.ActiveSpeedCommonView;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;

public class ActiveSpeedGroupView
extends ActiveSpeedCommonView {
    public static final String ID = ActiveSpeedGroupView.class.getName();
    private Map<Integer, ListValue> serverObjMap = new HashMap<Integer, ListValue>();
    private String grpName;
    private String objType;
    private GroupManager manager = GroupManager.getInstance();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] datas = secId.split("&");
        this.grpName = datas[0];
        this.objType = datas[1];
    }

    @Override
    public void createPartControl(Composite parent) {
        this.setPartName("ActiveSpeed - " + this.grpName);
        super.createPartControl(parent);
        this.thread = new RefreshThread(this, 150);
        this.thread.start();
        this.thread.setName(String.valueOf(this.toString()) + " - " + "grpName:" + this.grpName);
    }

    private void collectObj() {
        this.serverObjMap.clear();
        Set<Integer> objHashs = this.manager.getObjectsByGroup(this.grpName);
        for (int objHash : objHashs) {
            AgentObject agentObj = AgentModelThread.getInstance().getAgentObject(objHash);
            if (agentObj == null || !agentObj.isAlive()) continue;
            int serverId = agentObj.getServerId();
            ListValue lv = this.serverObjMap.get(serverId);
            if (lv == null) {
                lv = new ListValue();
                this.serverObjMap.put(serverId, lv);
            }
            lv.add((long)objHash);
        }
    }

    @Override
    public void fetch() {
        this.collectObj();
        Iterator<Integer> itr = this.serverObjMap.keySet().iterator();
        ActiveSpeedCommonView.ActiveSpeedData a = new ActiveSpeedCommonView.ActiveSpeedData();
        while (itr.hasNext()) {
            MapPack p;
            TcpProxy tcp;
            block7: {
                int serverId = itr.next();
                tcp = TcpProxy.getTcpProxy(serverId);
                MapPack param = new MapPack();
                param.put("objHash", (Value)this.serverObjMap.get(serverId));
                p = (MapPack)tcp.getSingle("ACTIVESPEED_GROUP_REAL_TIME_GROUP", (Pack)param);
                if (p != null) break block7;
                TcpProxy.putTcpProxy(tcp);
                continue;
            }
            try {
                try {
                    if (p != null) {
                        a.act1 += CastUtil.cint((Object)p.get("act1"));
                        a.act2 += CastUtil.cint((Object)p.get("act2"));
                        a.act3 += CastUtil.cint((Object)p.get("act3"));
                        a.tps += (float)CastUtil.cint((Object)p.get("tps"));
                    }
                }
                catch (Exception e) {
                    ConsoleProxy.errorSafe(e.toString());
                    TcpProxy.putTcpProxy(tcp);
                    continue;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        this.activeSpeedData = a;
    }
}

