/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.group.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.views.ScouterViewPart;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;

public class CounterPastDateGroupCountView
extends ScouterViewPart {
    public static final String ID = CounterPastDateGroupCountView.class.getName();
    private String grpName;
    private String objType;
    private String counter;
    private String date;
    private String mode;
    private Server defaultServer = ServerManager.getInstance().getDefaultServer();
    protected XYGraph xyGraph;
    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    private Map<Integer, ListValue> serverObjMap = new HashMap<Integer, ListValue>();
    protected CircularBufferDataProvider traceDataProvider;
    protected Trace trace;
    protected FigureCanvas canvas;
    int xAxisUnitWidth;
    int lineWidth;
    boolean writedValueMode = false;
    int lastWritedX;

    public void init(IViewSite site) throws PartInitException {
        String secId;
        super.init(site);
        this.statusMessage = secId = site.getSecondaryId();
        String[] datas = secId.split("&");
        this.grpName = datas[0];
        this.objType = datas[1];
        this.counter = datas[2];
        this.date = datas[3];
    }

    @Override
    public void createPartControl(Composite parent) {
        String displayCounter = this.defaultServer.getCounterEngine().getCounterDisplayName(this.objType, this.counter);
        String objectDisplay = this.defaultServer.getCounterEngine().getDisplayNameObjectType(this.objType);
        this.setPartName(String.valueOf(this.grpName) + " - " + displayCounter);
        this.desc = String.valueOf(this.grpName) + " | (Past) [" + objectDisplay + "][" + this.date.substring(0, 4) + "-" + this.date.substring(4, 6) + "-" + this.date.substring(6, 8) + "]" + displayCounter;
        this.mode = CounterUtil.getTotalMode(this.objType, this.counter);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterPastDateGroupCountView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterPastDateGroupCountView.this.setContentDescription(CounterPastDateGroupCountView.this.desc);
                    } else {
                        CounterPastDateGroupCountView.this.setContentDescription("");
                    }
                    r = CounterPastDateGroupCountView.this.canvas.getClientArea();
                    CounterPastDateGroupCountView.this.xyGraph.setSize(r.width, r.height);
                    this.lock = false;
                }
                CounterPastDateGroupCountView.this.lineWidth = r.width / 30;
                CounterPastDateGroupCountView.this.trace.setLineWidth(CounterPastDateGroupCountView.this.lineWidth);
                CounterPastDateGroupCountView.this.xAxisUnitWidth = CounterPastDateGroupCountView.this.xyGraph.primaryXAxis.getValuePosition(1.0, false) - CounterPastDateGroupCountView.this.xyGraph.primaryXAxis.getValuePosition(0.0, false);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                CounterPastDateGroupCountView.this.writedValueMode = false;
                CounterPastDateGroupCountView.this.canvas.redraw();
            }

            public void mouseDown(MouseEvent e) {
                CounterPastDateGroupCountView.this.writeValue(e.x);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(false);
        this.xyGraph.primaryXAxis.setShowMajorGrid(false);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.traceDataProvider = new CircularBufferDataProvider(true);
        this.traceDataProvider.setBufferSize(24);
        this.traceDataProvider.setCurrentXDataArray(new double[0]);
        this.traceDataProvider.setCurrentYDataArray(new double[0]);
        this.xyGraph.primaryXAxis.setRange(0.0, 24.0);
        this.trace = new Trace("TotalCount", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, this.traceDataProvider);
        this.trace.setPointStyle(Trace.PointStyle.NONE);
        this.trace.getYAxis().setFormatPattern("#,##0");
        this.trace.setLineWidth(15);
        this.trace.setTraceType(Trace.TraceType.BAR);
        this.trace.setAreaAlpha(200);
        this.trace.setTraceColor(ColorUtil.getInstance().TOTAL_CHART_COLOR);
        this.xyGraph.addTrace(this.trace);
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                CounterPastDateGroupCountView.this.load();
            }
        });
    }

    public void load() {
        ScouterUtil.collectGroupObjcts(this.grpName, this.serverObjMap);
        Iterator<Integer> serverIds = this.serverObjMap.keySet().iterator();
        final ArrayList<Pack> result = new ArrayList<Pack>();
        while (serverIds.hasNext()) {
            int serverId = serverIds.next();
            TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("counter", this.counter);
                    param.put("date", this.date);
                    param.put("objHash", (Value)this.serverObjMap.get(serverId));
                    tcp.process("COUNTER_PAST_DATE_GROUP", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            Pack p = in.readPack();
                            if (p != null) {
                                result.add(p);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    continue;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        final long[] values = new long[24];
        if (result.size() > 0) {
            Map<Long, Double> valueMap = ScouterUtil.getLoadTotalMap(this.counter, result, this.mode, (byte)3);
            for (long time : valueMap.keySet()) {
                int index;
                int n = index = (int)((long)DateUtil.getDateMillis((long)time) / 3600000L);
                values[n] = (long)((double)values[n] + valueMap.get(time));
            }
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                double max = 0.0;
                CounterPastDateGroupCountView.this.traceDataProvider.clearTrace();
                int i = 0;
                while (i < values.length) {
                    CounterPastDateGroupCountView.this.traceDataProvider.addSample(new Sample(CastUtil.cdouble((Object)i) + 0.5, CastUtil.cdouble((Object)values[i])));
                    ++i;
                }
                max = Math.max(ChartUtil.getMax(CounterPastDateGroupCountView.this.traceDataProvider.iterator()), max);
                if (CounterUtil.isPercentValue(CounterPastDateGroupCountView.this.objType, CounterPastDateGroupCountView.this.counter)) {
                    CounterPastDateGroupCountView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    CounterPastDateGroupCountView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
                CounterPastDateGroupCountView.this.canvas.redraw();
                CounterPastDateGroupCountView.this.xyGraph.repaint();
            }
        });
    }

    public void writeValue(int ex) {
        double x = this.xyGraph.primaryXAxis.getPositionValue(ex, false);
        int index = (int)x;
        if (index < 0) {
            return;
        }
        Sample sample = (Sample)this.trace.getDataProvider().getSample(index);
        if (sample != null) {
            double y = sample.getYValue();
            int height = this.xyGraph.primaryYAxis.getValuePosition(y, false);
            int startX = this.xyGraph.primaryXAxis.getValuePosition((int)x, false);
            GC gc = new GC((Drawable)this.canvas);
            Font font = new Font(null, "Verdana", 10, 1);
            gc.setFont(font);
            String value = FormatUtil.print((Object)y, (String)"#,###");
            Point textSize = gc.textExtent(value);
            gc.drawText(value, startX + (this.xAxisUnitWidth - textSize.x) / 2, height - 20, true);
            int ground = this.xyGraph.primaryYAxis.getValuePosition(0.0, false);
            gc.setForeground(Display.getCurrent().getSystemColor(2));
            gc.setBackground(Display.getCurrent().getSystemColor(12));
            gc.drawRectangle(startX + (this.xAxisUnitWidth - this.lineWidth) / 2, height, this.lineWidth, ground - height);
            gc.fillRectangle(startX + (this.xAxisUnitWidth - this.lineWidth) / 2, height, this.lineWidth, ground - height);
            gc.dispose();
            this.writedValueMode = true;
            this.lastWritedX = ex;
        }
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(String objType:" + this.objType + ", String counter:" + this.counter + ", int grpName:" + this.grpName + ")";
        super.setFocus();
    }
}

