/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.group.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.IDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.group.DatePeriodUnit;
import scouter.client.group.GroupManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.popup.DualCalendarDialog;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.client.views.ScouterViewPart;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.StringUtil;

public class CounterPastDateGroupTotalView
extends ScouterViewPart
implements DualCalendarDialog.ILoadDualCounterDialog {
    public static final String ID = CounterPastDateGroupTotalView.class.getName();
    private String grpName;
    private String objType;
    private String counter;
    private String mode;
    private String sDate = DateUtil.yyyymmdd((long)(TimeUtil.getCurrentTime() - 86400000L));
    private String eDate = DateUtil.yyyymmdd((long)(TimeUtil.getCurrentTime() - 86400000L));
    private Server defaultServer = ServerManager.getInstance().getDefaultServer();
    protected XYGraph xyGraph;
    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    protected List<Trace> traces = new ArrayList<Trace>();
    private Map<Integer, ListValue> serverObjMap = new HashMap<Integer, ListValue>();
    protected FigureCanvas canvas;
    Label serverText;
    Label sDateText;
    Label eDateText;
    DualCalendarDialog calDialog;
    Combo periodCombo;
    Composite headerComp;
    Button applyBtn;
    private GroupManager manager = GroupManager.getInstance();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] datas = secId.split("&");
        this.grpName = datas[0];
        this.objType = datas[1];
        this.counter = datas[2];
    }

    @Override
    public void createPartControl(Composite parent) {
        String displayCounter = this.defaultServer.getCounterEngine().getCounterDisplayName(this.objType, this.counter);
        this.setPartName(String.valueOf(this.grpName) + " - " + displayCounter);
        this.setTitleImage(Images.getCounterImage(this.objType, this.counter, this.defaultServer.getId()));
        String unit = this.defaultServer.getCounterEngine().getCounterUnit(this.objType, this.counter);
        this.mode = CounterUtil.getTotalMode(this.objType, this.counter);
        this.statusMessage = String.valueOf(this.grpName) + " | (PastDate) Total " + displayCounter + (StringUtil.isNotEmpty((String)unit) ? "(" + unit + ")" : "");
        Composite composite = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(1, true);
        gLayout.horizontalSpacing = 0;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        composite.setLayout((Layout)gLayout);
        this.createUpperMenu(composite);
        Composite chartComposite = new Composite(composite, 0);
        chartComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        chartComposite.setLayout((Layout)UIUtil.formLayout(0, 0));
        chartComposite.setLayout((Layout)UIUtil.formLayout(0, 0));
        chartComposite.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas = new FigureCanvas(chartComposite);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas.setLayoutData((Object)UIUtil.formData(0, 0, 0, 0, 100, 0, 100, 0));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterPastDateGroupTotalView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    CounterPastDateGroupTotalView.this.xyGraph.setSize(r.width, r.height);
                    this.lock = false;
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    CounterPastDateGroupTotalView.this.forceRefresh();
                }
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowTitle(false);
        this.xyGraph.setShowLegend(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        ScouterUtil.addShowTotalValueListener(this.canvas, this.xyGraph);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                CounterPastDateGroupTotalView.this.forceRefresh();
            }
        });
        man.add((IContributionItem)new Separator());
        man.add((IAction)new Action("Duplicate", ImageUtil.getImageDescriptor(Images.copy)){

            public void run() {
                ExUtil.exec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            (this).CounterPastDateGroupTotalView.this.window.getActivePage().showView(ID, String.valueOf((this).CounterPastDateGroupTotalView.this.grpName) + "&" + (this).CounterPastDateGroupTotalView.this.objType + "&" + (this).CounterPastDateGroupTotalView.this.counter + "&" + TimeUtil.getCurrentTime(), 1);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        this.forceRefresh();
    }

    private void createUpperMenu(Composite composite) {
        this.headerComp = new Composite(composite, 0);
        this.headerComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.headerComp.setLayout((Layout)UIUtil.formLayout(0, 0));
        this.applyBtn = new Button(this.headerComp, 8);
        this.applyBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, 100, -5, null, -1));
        this.applyBtn.setText("Apply");
        this.applyBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        CounterPastDateGroupTotalView.this.applyBtn.setEnabled(false);
                        CounterPastDateGroupTotalView.this.forceRefresh();
                    }
                }
            }
        });
        Button manualBtn = new Button(this.headerComp, 8);
        manualBtn.setImage(Images.CTXMENU_RDC);
        manualBtn.setText("Manual");
        manualBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, this.applyBtn, -5, null, -1));
        manualBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        Display display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        CounterPastDateGroupTotalView.this.calDialog = new DualCalendarDialog(display, CounterPastDateGroupTotalView.this);
                        CounterPastDateGroupTotalView.this.calDialog.show(UIUtil.getMousePosition());
                    }
                }
            }
        });
        this.periodCombo = new Combo(this.headerComp, 2568);
        this.periodCombo.setLayoutData((Object)UIUtil.formData(null, -1, 0, 3, manualBtn, -5, null, -1));
        DatePeriodUnit[] periodArray = DatePeriodUnit.values();
        int index = 0;
        while (index < periodArray.length) {
            this.periodCombo.add(periodArray[index].getLabel(), index);
            this.periodCombo.setData(periodArray[index].getLabel(), (Object)periodArray[index].getTime());
            ++index;
        }
        this.periodCombo.select(index - 1);
        this.periodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                long time = (Long)CounterPastDateGroupTotalView.this.periodCombo.getData(CounterPastDateGroupTotalView.this.periodCombo.getText());
                long etime = DateUtil.getTime((String)CounterPastDateGroupTotalView.this.eDate, (String)"yyyyMMdd");
                CounterPastDateGroupTotalView.this.sDate = DateUtil.yyyymmdd((long)(etime - (time - 86400000L)));
                CounterPastDateGroupTotalView.this.setHeadText();
            }
        });
        this.eDateText = new Label(this.headerComp, 0);
        this.eDateText.setLayoutData((Object)UIUtil.formData(null, -1, 0, 7, this.periodCombo, -5, null, -1));
        Label windbarLabel = new Label(this.headerComp, 0);
        windbarLabel.setLayoutData((Object)UIUtil.formData(null, -1, 0, 7, this.eDateText, -5, null, -1));
        windbarLabel.setText("~");
        this.sDateText = new Label(this.headerComp, 0);
        this.sDateText.setLayoutData((Object)UIUtil.formData(null, -1, 0, 7, windbarLabel, -5, null, -1));
        this.serverText = new Label(this.headerComp, 131072);
        this.serverText.setLayoutData((Object)UIUtil.formData(0, 0, 0, 7, this.sDateText, -5, null, -1));
        this.setHeadText();
    }

    private void setHeadText() {
        this.serverText.setText(String.valueOf(this.grpName) + " |");
        this.sDateText.setText(String.valueOf(this.sDate.substring(0, 4)) + "-" + this.sDate.substring(4, 6) + "-" + this.sDate.substring(6, 8));
        this.eDateText.setText(String.valueOf(this.eDate.substring(0, 4)) + "-" + this.eDate.substring(4, 6) + "-" + this.eDate.substring(6, 8));
    }

    public void onPressedOk(String date) {
    }

    @Override
    public void onPressedCancel() {
    }

    @Override
    public void setFocus() {
        super.setFocus();
    }

    private IDataProvider getDataProvider(int size) {
        CircularBufferDataProvider provider = new CircularBufferDataProvider(true);
        provider.setBufferSize(size);
        Trace trace = new Trace(this.grpName, this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, provider);
        trace.setPointStyle(Trace.PointStyle.NONE);
        trace.getXAxis().setFormatPattern("yyyy-MM-dd\n  HH:mm:ss");
        trace.getYAxis().setFormatPattern("#,##0");
        trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        trace.setTraceType(Trace.TraceType.AREA);
        trace.setTraceColor(ColorUtil.getInstance().TOTAL_CHART_COLOR);
        this.xyGraph.addTrace(trace);
        Trace lineTrace = ChartUtil.addSolidLine(this.xyGraph, provider, ColorUtil.getInstance().TOTAL_CHART_COLOR);
        this.traces.add(trace);
        this.traces.add(lineTrace);
        return provider;
    }

    private void forceRefresh() {
        for (Trace trace : this.traces) {
            this.xyGraph.removeTrace(trace);
        }
        this.traces.clear();
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                CounterPastDateGroupTotalView.this.load();
            }
        });
    }

    private void collectObj() {
        this.serverObjMap.clear();
        Set<Integer> objHashs = this.manager.getObjectsByGroup(this.grpName);
        for (int objHash : objHashs) {
            AgentObject agentObj = AgentModelThread.getInstance().getAgentObject(objHash);
            if (agentObj == null) continue;
            int serverId = agentObj.getServerId();
            ListValue lv = this.serverObjMap.get(serverId);
            if (lv == null) {
                lv = new ListValue();
                this.serverObjMap.put(serverId, lv);
            }
            lv.add((long)objHash);
        }
    }

    private void load() {
        final long stime = DateUtil.getTime((String)this.sDate, (String)"yyyyMMdd");
        final long etime = DateUtil.getTime((String)this.eDate, (String)"yyyyMMdd") + 86399999L;
        this.collectObj();
        Iterator<Integer> serverIds = this.serverObjMap.keySet().iterator();
        final ArrayList<Pack> result = new ArrayList<Pack>();
        while (serverIds.hasNext()) {
            int serverId = serverIds.next();
            TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("stime", stime);
                    param.put("etime", etime);
                    param.put("counter", this.counter);
                    param.put("objHash", (Value)this.serverObjMap.get(serverId));
                    tcp.process("COUNTER_PAST_LONGDATE_GROUP", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            Pack p = in.readPack();
                            result.add(p);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    continue;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        final Map<Long, Double> valueMap = ScouterUtil.getLoadTotalMap(this.counter, result, this.mode, (byte)3);
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                CounterPastDateGroupTotalView.this.xyGraph.primaryXAxis.setRange(stime, etime);
                CircularBufferDataProvider provider = (CircularBufferDataProvider)CounterPastDateGroupTotalView.this.getDataProvider((int)((etime - stime) / 300000L));
                provider.clearTrace();
                Set timeSet = valueMap.keySet();
                Iterator iterator = timeSet.iterator();
                while (iterator.hasNext()) {
                    long time = (Long)iterator.next();
                    provider.addSample(new Sample(time, CastUtil.cdouble(valueMap.get(time))));
                }
                if (CounterUtil.isPercentValue(CounterPastDateGroupTotalView.this.objType, CounterPastDateGroupTotalView.this.counter)) {
                    CounterPastDateGroupTotalView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    double max = ChartUtil.getMax(provider.iterator());
                    CounterPastDateGroupTotalView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
                CounterPastDateGroupTotalView.this.applyBtn.setEnabled(true);
                CounterPastDateGroupTotalView.this.canvas.redraw();
            }
        });
    }

    @Override
    public void onPressedOk(String sDate, String eDate) {
        this.sDate = sDate;
        this.eDate = eDate;
        this.setHeadText();
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
    }
}

