/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.group.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.IDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.group.GroupManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.popup.CalendarDialog;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.client.views.ScouterViewPart;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.StringUtil;

public class CounterPastTimeGroupTotalView
extends ScouterViewPart
implements CalendarDialog.ILoadCalendarDialog {
    public static final String ID = CounterPastTimeGroupTotalView.class.getName();
    private String grpName;
    private String objType;
    private String counter;
    private String mode;
    private long etime = TimeUtil.getCurrentTime();
    private long stime = this.etime - 300000L;
    private Server defaultServer = ServerManager.getInstance().getDefaultServer();
    protected XYGraph xyGraph;
    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    protected List<Trace> traces = new ArrayList<Trace>();
    private Map<Integer, ListValue> serverObjMap = new HashMap<Integer, ListValue>();
    protected FigureCanvas canvas;
    Label serverText;
    Label sDateText;
    Label sTimeText;
    Label eTimeText;
    CalendarDialog calDialog;
    Composite headerComp;
    private GroupManager manager = GroupManager.getInstance();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] datas = secId.split("&");
        this.grpName = datas[0];
        this.objType = datas[1];
        this.counter = datas[2];
    }

    @Override
    public void createPartControl(Composite parent) {
        String displayCounter = this.defaultServer.getCounterEngine().getCounterDisplayName(this.objType, this.counter);
        this.setPartName(String.valueOf(this.grpName) + " - " + displayCounter);
        this.setTitleImage(Images.getCounterImage(this.objType, this.counter, this.defaultServer.getId()));
        String unit = this.defaultServer.getCounterEngine().getCounterUnit(this.objType, this.counter);
        this.mode = CounterUtil.getTotalMode(this.objType, this.counter);
        this.statusMessage = String.valueOf(this.grpName) + " | (PastTime) Total " + displayCounter + (StringUtil.isNotEmpty((String)unit) ? "(" + unit + ")" : "");
        Composite composite = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(1, true);
        gLayout.horizontalSpacing = 0;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        composite.setLayout((Layout)gLayout);
        this.createUpperMenu(composite);
        Composite chartComposite = new Composite(composite, 0);
        chartComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        chartComposite.setLayout((Layout)UIUtil.formLayout(0, 0));
        chartComposite.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas = new FigureCanvas(chartComposite);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas.setLayoutData((Object)UIUtil.formData(0, 0, 0, 0, 100, 0, 100, 0));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterPastTimeGroupTotalView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    CounterPastTimeGroupTotalView.this.xyGraph.setSize(r.width, r.height);
                    this.lock = false;
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    CounterPastTimeGroupTotalView.this.forceRefresh();
                }
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowTitle(false);
        this.xyGraph.setShowLegend(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        ScouterUtil.addShowTotalValueListener(this.canvas, this.xyGraph);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                CounterPastTimeGroupTotalView.this.forceRefresh();
            }
        });
        man.add((IContributionItem)new Separator());
        man.add((IAction)new Action("Duplicate", ImageUtil.getImageDescriptor(Images.copy)){

            public void run() {
                ExUtil.exec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            (this).CounterPastTimeGroupTotalView.this.window.getActivePage().showView(ID, String.valueOf((this).CounterPastTimeGroupTotalView.this.grpName) + "&" + (this).CounterPastTimeGroupTotalView.this.objType + "&" + (this).CounterPastTimeGroupTotalView.this.counter + "&" + TimeUtil.getCurrentTime(), 1);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        this.forceRefresh();
    }

    private void createUpperMenu(Composite composite) {
        this.headerComp = new Composite(composite, 0);
        this.headerComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.headerComp.setLayout((Layout)UIUtil.formLayout(0, 0));
        Button manualBtn = new Button(this.headerComp, 8);
        manualBtn.setImage(Images.CTXMENU_RDC);
        manualBtn.setText("Manual");
        manualBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, 100, -5, null, -1));
        manualBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        Display display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        CounterPastTimeGroupTotalView.this.calDialog = new CalendarDialog(display, CounterPastTimeGroupTotalView.this);
                        CounterPastTimeGroupTotalView.this.calDialog.showWithTime(UIUtil.getMousePosition(), CounterPastTimeGroupTotalView.this.stime);
                    }
                }
            }
        });
        this.eTimeText = new Label(this.headerComp, 0);
        this.eTimeText.setLayoutData((Object)UIUtil.labelFormData((Control)manualBtn));
        Label label = new Label(this.headerComp, 0);
        label.setLayoutData((Object)UIUtil.labelFormData((Control)this.eTimeText));
        label.setText("~");
        this.sTimeText = new Label(this.headerComp, 0);
        this.sTimeText.setLayoutData((Object)UIUtil.labelFormData((Control)label));
        this.sDateText = new Label(this.headerComp, 0);
        this.sDateText.setLayoutData((Object)UIUtil.labelFormData((Control)this.sTimeText));
        this.serverText = new Label(this.headerComp, 131072);
        this.serverText.setLayoutData((Object)UIUtil.formData(0, 0, 0, 7, this.sDateText, -5, null, -1));
        this.setHeadText();
    }

    private void setHeadText() {
        this.serverText.setText(String.valueOf(this.grpName) + " |");
        this.sDateText.setText(DateUtil.format((long)this.stime, (String)"yyyy-MM-dd"));
        this.sTimeText.setText(DateUtil.format((long)this.stime, (String)"hh:mm a", (Locale)Locale.ENGLISH));
        this.eTimeText.setText(DateUtil.format((long)this.etime, (String)"hh:mm a", (Locale)Locale.ENGLISH));
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
        this.stime = startTime;
        this.etime = endTime;
        this.forceRefresh();
        this.setHeadText();
    }

    @Override
    public void onPressedOk(String date) {
    }

    @Override
    public void onPressedCancel() {
    }

    @Override
    public void setFocus() {
        super.setFocus();
    }

    private IDataProvider getDataProvider() {
        CircularBufferDataProvider provider = new CircularBufferDataProvider(true);
        provider.setBufferSize((int)((this.etime - this.stime) / 2000L) + 1);
        Trace trace = new Trace(this.grpName, this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, provider);
        trace.setPointStyle(Trace.PointStyle.NONE);
        trace.getXAxis().setFormatPattern("HH:mm:ss");
        trace.getYAxis().setFormatPattern("#,##0");
        trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        trace.setTraceType(Trace.TraceType.AREA);
        trace.setTraceColor(ColorUtil.getInstance().TOTAL_CHART_COLOR);
        this.xyGraph.addTrace(trace);
        Trace lineTrace = ChartUtil.addSolidLine(this.xyGraph, provider, ColorUtil.getInstance().TOTAL_CHART_COLOR);
        this.traces.add(trace);
        this.traces.add(lineTrace);
        return provider;
    }

    private void forceRefresh() {
        for (Trace t : this.traces) {
            this.xyGraph.removeTrace(t);
        }
        this.traces.clear();
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                CounterPastTimeGroupTotalView.this.load();
            }
        });
    }

    private void collectObj() {
        this.serverObjMap.clear();
        Set<Integer> objHashs = this.manager.getObjectsByGroup(this.grpName);
        for (int objHash : objHashs) {
            AgentObject agentObj = AgentModelThread.getInstance().getAgentObject(objHash);
            if (agentObj == null) continue;
            int serverId = agentObj.getServerId();
            ListValue lv = this.serverObjMap.get(serverId);
            if (lv == null) {
                lv = new ListValue();
                this.serverObjMap.put(serverId, lv);
            }
            lv.add((long)objHash);
        }
    }

    private void load() {
        this.collectObj();
        Iterator<Integer> serverIds = this.serverObjMap.keySet().iterator();
        final ArrayList<Pack> result = new ArrayList<Pack>();
        while (serverIds.hasNext()) {
            int serverId = serverIds.next();
            TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("stime", this.stime);
                    param.put("etime", this.etime);
                    param.put("counter", this.counter);
                    param.put("objHash", (Value)this.serverObjMap.get(serverId));
                    tcp.process("COUNTER_PAST_TIME_GROUP", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            Pack p = in.readPack();
                            result.add(p);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    continue;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        final Map<Long, Double> valueMap = ScouterUtil.getLoadTotalMap(this.counter, result, this.mode, (byte)1);
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                CounterPastTimeGroupTotalView.this.xyGraph.primaryXAxis.setRange(CounterPastTimeGroupTotalView.this.stime, CounterPastTimeGroupTotalView.this.etime);
                CircularBufferDataProvider provider = (CircularBufferDataProvider)CounterPastTimeGroupTotalView.this.getDataProvider();
                provider.clearTrace();
                Set timeSet = valueMap.keySet();
                Iterator iterator = timeSet.iterator();
                while (iterator.hasNext()) {
                    long time = (Long)iterator.next();
                    provider.addSample(new Sample(time, CastUtil.cdouble(valueMap.get(time))));
                }
                if (CounterUtil.isPercentValue(CounterPastTimeGroupTotalView.this.objType, CounterPastTimeGroupTotalView.this.counter)) {
                    CounterPastTimeGroupTotalView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    double max = ChartUtil.getMax(provider.iterator());
                    CounterPastTimeGroupTotalView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
            }
        });
    }
}

