/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.group.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.IDataProvider;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.group.GroupManager;
import scouter.client.listeners.RangeMouseListener;
import scouter.client.model.AgentColorManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.model.RefreshThread;
import scouter.client.model.TextProxy;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.threads.ObjectSelectManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.views.ScouterViewPart;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.HashUtil;
import scouter.util.StringUtil;

public class CounterRealTimeGroupAllView
extends ScouterViewPart
implements RefreshThread.Refreshable,
ObjectSelectManager.IObjectCheckListener {
    public static final String ID = CounterRealTimeGroupAllView.class.getName();
    protected RefreshThread thread;
    private String grpName;
    private String objType;
    private String counter;
    private Server defaultServer = ServerManager.getInstance().getDefaultServer();
    protected XYGraph xyGraph;
    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    protected Map<Integer, Trace> traces = new HashMap<Integer, Trace>();
    private Map<Integer, ListValue> serverObjMap = new HashMap<Integer, ListValue>();
    protected FigureCanvas canvas;
    private boolean init = false;
    boolean isActive = false;
    private GroupManager manager = GroupManager.getInstance();
    boolean selectedMode = false;

    public void init(IViewSite site) throws PartInitException {
        String secId;
        super.init(site);
        this.statusMessage = secId = site.getSecondaryId();
        String[] datas = secId.split("&");
        this.grpName = datas[0];
        this.objType = datas[1];
        this.counter = datas[2];
    }

    @Override
    public void createPartControl(Composite parent) {
        String displayCounter = this.defaultServer.getCounterEngine().getCounterDisplayName(this.objType, this.counter);
        this.setPartName(String.valueOf(this.grpName) + " - " + displayCounter);
        String unit = this.defaultServer.getCounterEngine().getCounterUnit(this.objType, this.counter);
        this.desc = String.valueOf(this.grpName) + " | (Realtime) All " + displayCounter + (StringUtil.isNotEmpty((String)unit) ? "(" + unit + ")" : "");
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterRealTimeGroupAllView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowLegendAllowSize(r.width, r.height)) {
                        CounterRealTimeGroupAllView.this.xyGraph.setShowLegend(true);
                    } else {
                        CounterRealTimeGroupAllView.this.xyGraph.setShowLegend(false);
                    }
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterRealTimeGroupAllView.this.setContentDescription(CounterRealTimeGroupAllView.this.desc);
                    } else {
                        CounterRealTimeGroupAllView.this.setContentDescription("");
                    }
                    r = CounterRealTimeGroupAllView.this.canvas.getClientArea();
                    CounterRealTimeGroupAllView.this.xyGraph.setSize(r.width, r.height);
                    this.lock = false;
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    CounterRealTimeGroupAllView.this.forceRefresh();
                }
            }
        });
        final DefaultToolTip toolTip = new DefaultToolTip((Control)this.canvas, 1, true);
        toolTip.setFont(new Font(null, "Arial", 10, 1));
        toolTip.setBackgroundColor(Display.getCurrent().getSystemColor(29));
        this.canvas.addMouseListener(new org.eclipse.swt.events.MouseListener(){

            public void mouseUp(MouseEvent e) {
                CounterRealTimeGroupAllView.this.onDeselectObject();
                toolTip.hide();
            }

            public void mouseDown(MouseEvent e) {
                double x = CounterRealTimeGroupAllView.this.xyGraph.primaryXAxis.getPositionValue(e.x, false);
                double y = CounterRealTimeGroupAllView.this.xyGraph.primaryYAxis.getPositionValue(e.y, false);
                if (x < 0.0 || y < 0.0) {
                    return;
                }
                double minDistance = 30.0;
                long time = 0L;
                double value = 0.0;
                Trace nearestTrace = null;
                for (Trace t : CounterRealTimeGroupAllView.this.traces.values()) {
                    int y2;
                    int x2;
                    double distance;
                    ISample s = ScouterUtil.getNearestPoint(t.getDataProvider(), x);
                    if (s == null || !(minDistance > (distance = ScouterUtil.getPointDistance(e.x, e.y, x2 = CounterRealTimeGroupAllView.this.xyGraph.primaryXAxis.getValuePosition(s.getXValue(), false), y2 = CounterRealTimeGroupAllView.this.xyGraph.primaryYAxis.getValuePosition(s.getYValue(), false))))) continue;
                    minDistance = distance;
                    nearestTrace = t;
                    time = (long)s.getXValue();
                    value = s.getYValue();
                }
                if (nearestTrace != null) {
                    int width = PManager.getInstance().getInt("lineWidth");
                    nearestTrace.setLineWidth(width + 2);
                    toolTip.setText(String.valueOf(nearestTrace.getName()) + "\nTime : " + DateUtil.format((long)time, (String)"HH:mm:ss") + "\nValue : " + FormatUtil.print((Object)value, (String)"#,###.##"));
                    toolTip.show(new Point(e.x, e.y));
                    CounterRealTimeGroupAllView.this.onSelectObject(HashUtil.hash((String)nearestTrace.getName()), nearestTrace.getName(), CounterRealTimeGroupAllView.this.objType);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.primaryYAxis.addMouseListener((MouseListener)new RangeMouseListener(this.getViewSite().getShell(), this.xyGraph.primaryYAxis));
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                CounterRealTimeGroupAllView.this.forceRefresh();
            }
        });
        ObjectSelectManager.getInstance().addObjectCheckStateListener(this);
        this.thread = new RefreshThread(this, 2000);
        this.thread.start();
    }

    @Override
    public void setFocus() {
        super.setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
        ObjectSelectManager.getInstance().removeObjectCheckStateListener(this);
    }

    private double getMaxValue() {
        Iterator<Integer> objHashs = this.traces.keySet().iterator();
        Range xRange = this.xyGraph.primaryXAxis.getRange();
        double lower = xRange.getLower();
        double upper = xRange.getUpper();
        double max = 0.0;
        while (objHashs.hasNext()) {
            int objHash = objHashs.next();
            CircularBufferDataProvider data = (CircularBufferDataProvider)this.traces.get(objHash).getDataProvider();
            if (data == null) continue;
            int inx = 0;
            while (inx < data.getSize()) {
                double y;
                Sample sample = (Sample)data.getSample(inx);
                double x = sample.getXValue();
                if (!(x < lower) && !(x > upper) && (y = sample.getYValue()) > max) {
                    max = y;
                }
                ++inx;
            }
        }
        return ChartUtil.getMaxValue(max);
    }

    private IDataProvider getDataProvider(int objHash) {
        Trace trace = this.traces.get(objHash);
        if (trace == null) {
            CircularBufferDataProvider provider = new CircularBufferDataProvider(true);
            provider.setBufferSize(155);
            String name = StringUtil.trimToEmpty((String)TextProxy.object.getText(objHash));
            trace = new Trace(name, this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, provider);
            trace.setPointStyle(Trace.PointStyle.NONE);
            trace.getXAxis().setFormatPattern("HH:mm:ss");
            trace.getYAxis().setFormatPattern("#,##0");
            trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
            trace.setTraceType(Trace.TraceType.SOLID_LINE);
            trace.setTraceColor(AgentColorManager.getInstance().assignColor(this.objType, objHash));
            this.xyGraph.addTrace(trace);
            this.traces.put(objHash, trace);
        }
        return trace.getDataProvider();
    }

    private void loadPrev5min() {
        Iterator<Integer> serverIds = this.serverObjMap.keySet().iterator();
        final ArrayList result = new ArrayList();
        while (serverIds.hasNext()) {
            int serverId = serverIds.next();
            TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    long etime = TimeUtil.getCurrentTime();
                    long stime = etime - 300000L;
                    param.put("stime", stime);
                    param.put("etime", etime);
                    param.put("counter", this.counter);
                    param.put("objHash", (Value)this.serverObjMap.get(serverId));
                    tcp.process("COUNTER_PAST_TIME_GROUP", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            Pack p = in.readPack();
                            result.add(p);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    continue;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                for (Pack pack : result) {
                    if (!(pack instanceof MapPack)) continue;
                    MapPack m = (MapPack)pack;
                    int objHash = m.getInt("objHash");
                    ListValue time = m.getList("time");
                    ListValue value = m.getList("value");
                    if (time == null || time.size() < 1) continue;
                    CircularBufferDataProvider provider = (CircularBufferDataProvider)CounterRealTimeGroupAllView.this.getDataProvider(objHash);
                    provider.clearTrace();
                    int i = 0;
                    while (time != null && i < time.size()) {
                        long x = time.getLong(i);
                        double y = value.getDouble(i);
                        provider.addSample(new Sample(x, y));
                        ++i;
                    }
                }
            }
        });
    }

    private void forceRefresh() {
        this.init = true;
        for (Trace trace : this.traces.values()) {
            this.xyGraph.removeTrace(trace);
        }
        this.traces.clear();
        this.thread.interrupt();
    }

    private void collectObj() {
        this.serverObjMap.clear();
        Set<Integer> objHashs = this.manager.getObjectsByGroup(this.grpName);
        for (int objHash : objHashs) {
            AgentObject agentObj = AgentModelThread.getInstance().getAgentObject(objHash);
            if (agentObj == null || !agentObj.isAlive()) continue;
            int serverId = agentObj.getServerId();
            ListValue lv = this.serverObjMap.get(serverId);
            if (lv == null) {
                lv = new ListValue();
                this.serverObjMap.put(serverId, lv);
            }
            lv.add((long)objHash);
        }
    }

    @Override
    public void refresh() {
        this.collectObj();
        if (this.init) {
            this.loadPrev5min();
            this.init = false;
        }
        this.isActive = false;
        Iterator<Integer> serverIds = this.serverObjMap.keySet().iterator();
        final ArrayList<Pack> result = new ArrayList<Pack>();
        while (serverIds.hasNext()) {
            int serverId = serverIds.next();
            TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("counter", this.counter);
                    param.put("objHash", (Value)this.serverObjMap.get(serverId));
                    Pack p = tcp.getSingle("COUNTER_REAL_TIME_GROUP", (Pack)param);
                    if (p != null) {
                        result.add(p);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    continue;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (result.size() > 0) {
            this.isActive = true;
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                if (CounterRealTimeGroupAllView.this.isActive) {
                    CounterRealTimeGroupAllView.this.setActive();
                } else {
                    CounterRealTimeGroupAllView.this.setInactive();
                }
                long now = TimeUtil.getCurrentTime();
                CounterRealTimeGroupAllView.this.xyGraph.primaryXAxis.setRange(now - 300000L, now + 1L);
                for (Pack p : result) {
                    MapPack m = (MapPack)p;
                    ListValue objHashLv = m.getList("objHash");
                    ListValue valueLv = m.getList("value");
                    int i = 0;
                    while (i < objHashLv.size()) {
                        int objHash = (int)objHashLv.getLong(i);
                        Value value = valueLv.get(i);
                        if (value != null && value.getValueType() != 0) {
                            CircularBufferDataProvider data = (CircularBufferDataProvider)CounterRealTimeGroupAllView.this.getDataProvider(objHash);
                            double v = CastUtil.cdouble((Object)value);
                            data.addSample(new Sample(now, v));
                        }
                        ++i;
                    }
                }
                if (CounterUtil.isPercentValue(CounterRealTimeGroupAllView.this.objType, CounterRealTimeGroupAllView.this.counter)) {
                    CounterRealTimeGroupAllView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    double max = CounterRealTimeGroupAllView.this.getMaxValue();
                    CounterRealTimeGroupAllView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
            }
        });
        this.checkSettingChange();
    }

    private void checkSettingChange() {
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int width = PManager.getInstance().getInt("lineWidth");
                Map<Integer, Trace> map = CounterRealTimeGroupAllView.this.traces;
                synchronized (map) {
                    for (Trace t : CounterRealTimeGroupAllView.this.traces.values()) {
                        if (!CounterRealTimeGroupAllView.this.selectedMode && t.getLineWidth() != width) {
                            t.setLineWidth(width);
                        }
                        int objHash = HashUtil.hash((String)t.getName());
                        AgentObject agent = AgentModelThread.getInstance().getAgentObject(objHash);
                        if (agent == null || !agent.isAlive() || agent.getColor() == null) {
                            return;
                        }
                        if (t.getTraceColor() == agent.getColor()) continue;
                        t.setTraceColor(agent.getColor());
                    }
                }
            }
        });
    }

    public void onSelectObject(int objHash, final String objName, String objType) {
        if (!objType.equals(this.objType)) {
            return;
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                int width = PManager.getInstance().getInt("lineWidth");
                for (Trace t : CounterRealTimeGroupAllView.this.traces.values()) {
                    if (!t.getName().equals(objName)) continue;
                    t.setLineWidth(width + 2);
                    CounterRealTimeGroupAllView.this.selectedMode = true;
                    break;
                }
            }
        });
    }

    public void onDeselectObject() {
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                int width = PManager.getInstance().getInt("lineWidth");
                for (Trace t : CounterRealTimeGroupAllView.this.traces.values()) {
                    t.setLineWidth(width);
                }
                CounterRealTimeGroupAllView.this.selectedMode = false;
            }
        });
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
            this.xyGraph.repaint();
        }
    }

    @Override
    public void notifyChangeState() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                for (Integer objHash : CounterRealTimeGroupAllView.this.traces.keySet()) {
                    if (ObjectSelectManager.getInstance().isUnselectedObject(objHash)) {
                        CounterRealTimeGroupAllView.this.traces.get(objHash).setVisible(false);
                        continue;
                    }
                    CounterRealTimeGroupAllView.this.traces.get(objHash).setVisible(true);
                }
                ExUtil.exec((Composite)CounterRealTimeGroupAllView.this.canvas, new Runnable(){

                    @Override
                    public void run() {
                        CounterRealTimeGroupAllView.this.redraw();
                    }
                });
            }
        });
    }
}

