/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.group.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.group.GroupManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.model.RefreshThread;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.views.ScouterViewPart;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.StringUtil;

public class CounterRealTimeGroupTotalView
extends ScouterViewPart
implements RefreshThread.Refreshable {
    public static final String ID = CounterRealTimeGroupTotalView.class.getName();
    protected RefreshThread thread;
    private String grpName;
    private String objType;
    private String counter;
    private String mode;
    private Server defaultServer = ServerManager.getInstance().getDefaultServer();
    protected XYGraph xyGraph;
    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    protected Trace trace;
    private Map<Integer, ListValue> serverObjMap = new HashMap<Integer, ListValue>();
    protected FigureCanvas canvas;
    private boolean init = false;
    boolean isActive = false;
    private GroupManager manager = GroupManager.getInstance();

    public void init(IViewSite site) throws PartInitException {
        String secId;
        super.init(site);
        this.statusMessage = secId = site.getSecondaryId();
        String[] datas = secId.split("&");
        this.grpName = datas[0];
        this.objType = datas[1];
        this.counter = datas[2];
    }

    @Override
    public void createPartControl(Composite parent) {
        String displayCounter = this.defaultServer.getCounterEngine().getCounterDisplayName(this.objType, this.counter);
        this.setPartName(String.valueOf(this.grpName) + " - " + displayCounter);
        String unit = this.defaultServer.getCounterEngine().getCounterUnit(this.objType, this.counter);
        this.mode = CounterUtil.getTotalMode(this.objType, this.counter);
        this.desc = String.valueOf(this.grpName) + " | (Realtime) Total " + displayCounter + (StringUtil.isNotEmpty((String)unit) ? "(" + unit + ") " : " ") + this.mode;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterRealTimeGroupTotalView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterRealTimeGroupTotalView.this.setContentDescription(CounterRealTimeGroupTotalView.this.desc);
                    } else {
                        CounterRealTimeGroupTotalView.this.setContentDescription("");
                    }
                    r = CounterRealTimeGroupTotalView.this.canvas.getClientArea();
                    CounterRealTimeGroupTotalView.this.xyGraph.setSize(r.width, r.height);
                    this.lock = false;
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    CounterRealTimeGroupTotalView.this.init = false;
                    CounterRealTimeGroupTotalView.this.refresh();
                }
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowTitle(false);
        this.xyGraph.setShowLegend(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        CircularBufferDataProvider provider = new CircularBufferDataProvider(true);
        provider.setBufferSize(155);
        this.trace = new Trace(String.valueOf(this.grpName) + "_TOTAL", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, provider);
        this.trace.setPointStyle(Trace.PointStyle.NONE);
        this.trace.getXAxis().setFormatPattern("HH:mm:ss");
        this.trace.getYAxis().setFormatPattern("#,##0");
        this.trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.trace.setTraceType(Trace.TraceType.AREA);
        this.trace.setTraceColor(ColorUtil.getInstance().TOTAL_CHART_COLOR);
        this.xyGraph.addTrace(this.trace);
        ChartUtil.addSolidLine(this.xyGraph, provider, ColorUtil.getInstance().TOTAL_CHART_COLOR);
        ScouterUtil.addShowTotalValueListener(this.canvas, this.xyGraph);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                CounterRealTimeGroupTotalView.this.forceRefresh();
            }
        });
        this.thread = new RefreshThread(this, 2000);
        this.thread.start();
    }

    @Override
    public void setFocus() {
        super.setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    private void loadPrev5min() {
        Iterator<Integer> serverIds = this.serverObjMap.keySet().iterator();
        final ArrayList<Pack> result = new ArrayList<Pack>();
        while (serverIds.hasNext()) {
            int serverId = serverIds.next();
            TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    long etime = TimeUtil.getCurrentTime();
                    long stime = etime - 300000L;
                    param.put("stime", stime);
                    param.put("etime", etime);
                    param.put("counter", this.counter);
                    param.put("objHash", (Value)this.serverObjMap.get(serverId));
                    tcp.process("COUNTER_PAST_TIME_GROUP", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            Pack p = in.readPack();
                            result.add(p);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    continue;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        final Map<Long, Double> valueMap = ScouterUtil.getLoadTotalMap(this.counter, result, this.mode, (byte)1);
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                CircularBufferDataProvider provider = (CircularBufferDataProvider)CounterRealTimeGroupTotalView.this.trace.getDataProvider();
                provider.clearTrace();
                Set timeSet = valueMap.keySet();
                Iterator iterator = timeSet.iterator();
                while (iterator.hasNext()) {
                    long time = (Long)iterator.next();
                    provider.addSample(new Sample(CastUtil.cdouble((Object)time), CastUtil.cdouble(valueMap.get(time))));
                }
            }
        });
    }

    private void forceRefresh() {
        this.init = true;
        this.thread.interrupt();
    }

    private void collectObj() {
        this.serverObjMap.clear();
        Set<Integer> objHashs = this.manager.getObjectsByGroup(this.grpName);
        for (int objHash : objHashs) {
            AgentObject agentObj = AgentModelThread.getInstance().getAgentObject(objHash);
            if (agentObj == null || !agentObj.isAlive()) continue;
            int serverId = agentObj.getServerId();
            ListValue lv = this.serverObjMap.get(serverId);
            if (lv == null) {
                lv = new ListValue();
                this.serverObjMap.put(serverId, lv);
            }
            lv.add((long)objHash);
        }
    }

    @Override
    public void refresh() {
        this.collectObj();
        if (this.init) {
            this.loadPrev5min();
            this.init = false;
        }
        this.isActive = false;
        Iterator<Integer> serverIds = this.serverObjMap.keySet().iterator();
        ArrayList<Pack> result = new ArrayList<Pack>();
        while (serverIds.hasNext()) {
            int serverId = serverIds.next();
            TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("counter", this.counter);
                    param.put("objHash", (Value)this.serverObjMap.get(serverId));
                    Pack p = tcp.getSingle("COUNTER_REAL_TIME_GROUP", (Pack)param);
                    if (p != null) {
                        result.add(p);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    continue;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (result.size() > 0) {
            this.isActive = true;
        }
        final double finalValue = ScouterUtil.getRealTotalValue(this.counter, result, this.mode);
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                if (CounterRealTimeGroupTotalView.this.isActive) {
                    CounterRealTimeGroupTotalView.this.setActive();
                } else {
                    CounterRealTimeGroupTotalView.this.setInactive();
                }
                long now = TimeUtil.getCurrentTime();
                CircularBufferDataProvider provider = (CircularBufferDataProvider)CounterRealTimeGroupTotalView.this.trace.getDataProvider();
                provider.addSample(new Sample(CastUtil.cdouble((Object)now), finalValue));
                CounterRealTimeGroupTotalView.this.xyGraph.primaryXAxis.setRange(now - 300000L, now + 1L);
                if (CounterUtil.isPercentValue(CounterRealTimeGroupTotalView.this.objType, CounterRealTimeGroupTotalView.this.counter)) {
                    CounterRealTimeGroupTotalView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    double max = ChartUtil.getMax(provider.iterator());
                    CounterRealTimeGroupTotalView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
            }
        });
    }
}

