/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.group.view;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.actions.OpenAddGroupAction;
import scouter.client.actions.OpenEQGroupViewAction;
import scouter.client.actions.OpenManageGroupAction;
import scouter.client.actions.OpenServiceGroupElapsedGroupAction;
import scouter.client.actions.OpenServiceGroupTPSGroupAction;
import scouter.client.actions.OpenVerticalEQGroupViewAction;
import scouter.client.context.actions.OpenCxtmenuAssginGroupAction;
import scouter.client.counter.actions.OpenActiveSpeedGroupViewAction;
import scouter.client.counter.actions.OpenPastDateGroupAllViewAction;
import scouter.client.counter.actions.OpenPastDateGroupCountViewAction;
import scouter.client.counter.actions.OpenPastDateGroupTotalViewAction;
import scouter.client.counter.actions.OpenPastTimeGroupAllViewAction;
import scouter.client.counter.actions.OpenPastTimeGroupTotalViewAction;
import scouter.client.counter.actions.OpenPastTimeTranXGroupViewAction;
import scouter.client.counter.actions.OpenRealTimeGroupAllViewAction;
import scouter.client.counter.actions.OpenRealTimeGroupTotalViewAction;
import scouter.client.counter.actions.OpenRealTimeTranXGroupViewAction;
import scouter.client.counter.actions.OpenTodayGroupAllViewAction;
import scouter.client.counter.actions.OpenTodayGroupCountViewAction;
import scouter.client.counter.actions.OpenTodayGroupTotalViewAction;
import scouter.client.group.GroupManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.model.DummyObject;
import scouter.client.model.GroupObject;
import scouter.client.model.HierarchyObject;
import scouter.client.model.RefreshThread;
import scouter.client.popup.AddGroupDialog;
import scouter.client.popup.GroupAssignmentDialog;
import scouter.client.popup.ManageGroupDialog;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.DummyAction;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.MenuUtil;
import scouter.client.util.ScouterUtil;
import scouter.lang.Counter;
import scouter.lang.counters.CounterEngine;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.FormatUtil;
import scouter.util.LinkedMap;

public class GroupNavigationView
extends ViewPart
implements RefreshThread.Refreshable,
AddGroupDialog.IAddGroup,
ManageGroupDialog.IManageGroup,
GroupAssignmentDialog.IGroupAssign {
    public static final String ID = GroupNavigationView.class.getName();
    IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    private RefreshThread thread;
    private TreeViewer viewer;
    private Tree tree;
    LinkedMap<String, HierarchyObject> groupMap = new LinkedMap();
    TreeItem selectedItem;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite mainComp = new Composite(parent, 0);
        this.tree = new Tree(mainComp, 2816);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.viewer = new TreeViewer(this.tree);
        TreeColumn column1 = new TreeColumn(this.tree, 16384);
        column1.setAlignment(16384);
        column1.setText("Group/Object");
        TreeColumn column2 = new TreeColumn(this.tree, 131072);
        column2.setAlignment(131072);
        column2.setText("Perf");
        TreeColumnLayout layout = new TreeColumnLayout();
        mainComp.setLayout((Layout)layout);
        layout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(68));
        layout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(22));
        this.viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.viewer.setInput(this.groupMap);
        this.createContextMenu((Viewer)this.viewer, new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (GroupNavigationView.this.selectedItem == null) {
                    manager.add((IAction)new OpenAddGroupAction(GroupNavigationView.this.win, GroupNavigationView.this));
                } else {
                    ISelection selection = GroupNavigationView.this.viewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        IStructuredSelection sel = (IStructuredSelection)selection;
                        Object[] elements = sel.toArray();
                        if (elements == null || elements.length < 1) {
                            return;
                        }
                        Object selObject = elements[elements.length - 1];
                        if (selObject instanceof GroupObject) {
                            GroupObject grpObj = (GroupObject)selObject;
                            String grpName = grpObj.getName();
                            String objType = grpObj.getObjType();
                            boolean userGroupObj = grpObj.getParent() == null || !(grpObj.getParent() instanceof DummyObject);
                            AgentObject defaultObj = grpObj.getFirstChild() != null ? (AgentObject)grpObj.getFirstChild() : null;
                            Server server = ServerManager.getInstance().getDefaultServer();
                            if (defaultObj != null) {
                                server = ServerManager.getInstance().getServer(defaultObj.getServerId());
                            }
                            manager.add((IAction)new DummyAction(grpName, Images.getObjectIcon(objType, false, server.getId())));
                            if (userGroupObj) {
                                MenuManager xLogMenu;
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new OpenManageGroupAction(GroupNavigationView.this.win, grpName, objType, GroupNavigationView.this));
                                manager.add((IAction)new RemoveGroupAction(grpName));
                                manager.add((IContributionItem)new Separator());
                                Set<Counter> counters = GroupNavigationView.this.listCounters(objType);
                                for (Counter counter : counters) {
                                    String name = counter.getName();
                                    String display = counter.getDisplayName();
                                    MenuManager counterMenu = new MenuManager(display, Images.getCounterImageDescriptor(objType, name, server.getId()), "scouter.group." + objType + "." + name);
                                    manager.add((IContributionItem)counterMenu);
                                    MenuManager liveMenuManager = new MenuManager("Live", ImageUtil.getImageDescriptor(Images.monitor), "scouter.group.live.id." + objType + "." + name);
                                    counterMenu.add((IContributionItem)liveMenuManager);
                                    MenuManager loadMenuManager = new MenuManager("Load", ImageUtil.getImageDescriptor(Images.drive), "scouter.group.load.id." + objType + "." + name);
                                    counterMenu.add((IContributionItem)loadMenuManager);
                                    if (counter.isAll()) {
                                        liveMenuManager.add((IAction)new OpenRealTimeGroupAllViewAction(GroupNavigationView.this.win, "Time All", name, grpObj));
                                    }
                                    if (counter.isTotal()) {
                                        liveMenuManager.add((IAction)new OpenRealTimeGroupTotalViewAction(GroupNavigationView.this.win, "Time Total", name, grpObj));
                                    }
                                    if (counter.isAll()) {
                                        liveMenuManager.add((IAction)new OpenTodayGroupAllViewAction(GroupNavigationView.this.win, "Daily All", name, grpObj));
                                    }
                                    if (counter.isTotal()) {
                                        liveMenuManager.add((IAction)new OpenTodayGroupTotalViewAction(GroupNavigationView.this.win, "Daily Total", name, grpObj));
                                    }
                                    if (counter.isAll()) {
                                        loadMenuManager.add((IAction)new OpenPastTimeGroupAllViewAction(GroupNavigationView.this.win, "Time All", name, grpObj));
                                    }
                                    if (counter.isTotal()) {
                                        loadMenuManager.add((IAction)new OpenPastTimeGroupTotalViewAction(GroupNavigationView.this.win, "Time Total", name, grpObj));
                                    }
                                    if (counter.isAll()) {
                                        loadMenuManager.add((IAction)new OpenPastDateGroupAllViewAction(GroupNavigationView.this.win, "Daily All", name, grpObj));
                                    }
                                    if (!counter.isTotal()) continue;
                                    loadMenuManager.add((IAction)new OpenPastDateGroupTotalViewAction(GroupNavigationView.this.win, "Daily Total", name, grpObj));
                                }
                                manager.add((IContributionItem)new Separator());
                                if (GroupNavigationView.this.isChildOf(objType, "javaee")) {
                                    manager.add((IAction)new OpenEQGroupViewAction(GroupNavigationView.this.win, grpObj.getName()));
                                    manager.add((IAction)new OpenVerticalEQGroupViewAction(GroupNavigationView.this.win, grpObj.getName()));
                                    manager.add((IAction)new OpenActiveSpeedGroupViewAction(GroupNavigationView.this.win, "Active Speed", grpObj));
                                    xLogMenu = new MenuManager("XLog", ImageUtil.getImageDescriptor(Images.transrealtime), "scouter.client.actions.counter.XLog");
                                    manager.add((IContributionItem)xLogMenu);
                                    xLogMenu.add((IAction)new OpenRealTimeTranXGroupViewAction(GroupNavigationView.this.win, "Realtime XLog", grpObj));
                                    xLogMenu.add((IAction)new OpenPastTimeTranXGroupViewAction(GroupNavigationView.this.win, "Pasttime XLog", grpObj));
                                    MenuManager scMenu = new MenuManager("Hourly Chart", ImageUtil.getImageDescriptor(Images.bar), "scouter.client.actions.counter.hourlychart");
                                    manager.add((IContributionItem)scMenu);
                                    scMenu.add((IAction)new OpenPastDateGroupCountViewAction(GroupNavigationView.this.win, "Load Service Count ", "ServiceCount", grpObj));
                                    scMenu.add((IAction)new OpenTodayGroupCountViewAction(GroupNavigationView.this.win, "Today Service Count", "ServiceCount", grpObj));
                                    MenuManager serviceGroupMgr = new MenuManager("Serivce Group", ImageUtil.getImageDescriptor(Images.sum), "scouter.menu.id.group.javee.servicegroup");
                                    manager.add((IContributionItem)serviceGroupMgr);
                                    serviceGroupMgr.add((IAction)new OpenServiceGroupTPSGroupAction(GroupNavigationView.this.win, grpName));
                                    serviceGroupMgr.add((IAction)new OpenServiceGroupElapsedGroupAction(GroupNavigationView.this.win, grpName));
                                } else if (GroupNavigationView.this.isChildOf(objType, "golang")) {
                                    manager.add((IAction)new OpenEQGroupViewAction(GroupNavigationView.this.win, grpObj.getName()));
                                    manager.add((IAction)new OpenVerticalEQGroupViewAction(GroupNavigationView.this.win, grpObj.getName()));
                                    xLogMenu = new MenuManager("XLog", ImageUtil.getImageDescriptor(Images.transrealtime), "scouter.client.actions.counter.XLog");
                                    manager.add((IContributionItem)xLogMenu);
                                    xLogMenu.add((IAction)new OpenRealTimeTranXGroupViewAction(GroupNavigationView.this.win, "Realtime XLog", grpObj));
                                    xLogMenu.add((IAction)new OpenPastTimeTranXGroupViewAction(GroupNavigationView.this.win, "Pasttime XLog", grpObj));
                                }
                            }
                        } else if (selObject instanceof AgentObject) {
                            AgentObject agent = (AgentObject)selObject;
                            int objHash = agent.getObjHash();
                            String objName = agent.getObjName();
                            String objType = agent.getObjType();
                            int serverId = agent.getServerId();
                            manager.add((IAction)new DummyAction(ServerManager.getInstance().getServer(serverId).getName(), Images.SERVER_INACT));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new OpenCxtmenuAssginGroupAction(GroupNavigationView.this.win, serverId, objHash, objName, objType, GroupNavigationView.this));
                            manager.add((IContributionItem)new Separator());
                            MenuUtil.addObjectContextMenu(manager, GroupNavigationView.this.win, agent);
                        }
                    }
                }
            }
        });
        this.tree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                GroupNavigationView.this.selectedItem = GroupNavigationView.this.tree.getItem(point);
            }
        });
        this.createQuickMenus();
        this.thread = new RefreshThread(this, 3000);
        this.thread.setName(ID);
        this.thread.start();
    }

    private void createContextMenu(Viewer viewer, IMenuListener listener) {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(listener);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
    }

    private void createQuickMenus() {
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Expand All", ImageUtil.getImageDescriptor(Images.expand)){

            public void run() {
                GroupNavigationView.this.viewer.expandAll();
            }
        });
        man.add((IAction)new Action("Collapse All", ImageUtil.getImageDescriptor(Images.collapse)){

            public void run() {
                GroupNavigationView.this.viewer.collapseAll();
            }
        });
        man.add((IContributionItem)new Separator());
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                GroupNavigationView.this.forceRefresh();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.shutdown();
            this.thread = null;
        }
    }

    private void forceRefresh() {
        AgentModelThread.getInstance().fetchObjectList();
        this.refresh();
    }

    @Override
    public void refresh() {
        this.organizeGroup();
        try {
            ExUtil.exec((Composite)this.tree, new Runnable(){

                @Override
                public void run() {
                    GroupNavigationView.this.viewer.refresh();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Set<Counter> listCounters(String objType) {
        TreeSet<Counter> counterSet = new TreeSet<Counter>();
        Set<Integer> serverList = ServerManager.getInstance().getOpenServerList();
        for (int serverId : serverList) {
            Server server = ServerManager.getInstance().getServer(serverId);
            CounterEngine engine = server.getCounterEngine();
            counterSet.addAll(engine.getCounterObjectSet(objType));
        }
        return counterSet;
    }

    private boolean isActionEnable(String objType, String attrName) {
        boolean result = false;
        Set<Integer> serverList = ServerManager.getInstance().getOpenServerList();
        for (int serverId : serverList) {
            Server server = ServerManager.getInstance().getServer(serverId);
            CounterEngine engine = server.getCounterEngine();
            if (!engine.isTrueAction(objType, attrName)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isChildOf(String objType, String family) {
        boolean result = false;
        Set<Integer> serverList = ServerManager.getInstance().getOpenServerList();
        for (int serverId : serverList) {
            Server server = ServerManager.getInstance().getServer(serverId);
            CounterEngine engine = server.getCounterEngine();
            if (!engine.isChildOf(objType, family)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean addedGroup(String objType, String name) {
        boolean result = GroupManager.getInstance().addGroup(objType, name);
        if (result) {
            this.forceRefresh();
        }
        return result;
    }

    @Override
    public void setResult(String groupName, int[] addObjHashs, int[] removeObjHashs) {
        GroupManager manager = GroupManager.getInstance();
        if (manager.addObject(addObjHashs, groupName)) {
            manager.removeObject(removeObjHashs, groupName);
            this.forceRefresh();
        }
    }

    @Override
    public void endGroupAssignment(int objHash, String[] groups) {
        GroupManager.getInstance().assginGroups(objHash, groups);
        this.forceRefresh();
    }

    private void organizeGroup() {
        AgentObject[] objectList;
        GroupManager manager = GroupManager.getInstance();
        List<String> userGroupList = manager.listGroup();
        Collections.sort(userGroupList);
        this.groupMap.clear();
        int i = 0;
        while (i < userGroupList.size()) {
            String name = userGroupList.get(i);
            String objType = manager.getGroupObjType(name);
            if (objType != null) {
                this.groupMap.put((Object)name, (Object)new GroupObject(objType, name));
            }
            ++i;
        }
        DummyObject othersObj = new DummyObject("Others");
        this.groupMap.put((Object)"Others", (Object)othersObj);
        AgentObject[] agentObjectArray = objectList = AgentModelThread.getInstance().getObjectList();
        int n = objectList.length;
        int n2 = 0;
        while (n2 < n) {
            AgentObject agent = agentObjectArray[n2];
            boolean others = true;
            Set<String> objGroupList = manager.getObjGroups(agent.getObjHash());
            for (String value : objGroupList) {
                GroupObject grpObj;
                HierarchyObject hiObj = (HierarchyObject)this.groupMap.get((Object)value);
                if (hiObj == null || !(hiObj instanceof GroupObject) || !(grpObj = (GroupObject)hiObj).getObjType().equals(agent.getObjType())) continue;
                grpObj.putChild(agent.getObjName(), agent);
                others = false;
            }
            if (others) {
                String objType = agent.getObjType();
                HierarchyObject hiObj = othersObj.getChild(objType);
                if (hiObj == null) {
                    hiObj = new GroupObject(objType, ServerManager.getInstance().getServer(agent.getServerId()).getCounterEngine().getDisplayNameObjectType(objType));
                    othersObj.putChild(objType, hiObj);
                    hiObj.setParent(othersObj);
                }
                hiObj.putChild(agent.getObjName(), agent);
            }
            ++n2;
        }
    }

    public class RemoveGroupAction
    extends Action {
        String groupName;

        public RemoveGroupAction(String groupName) {
            this.groupName = groupName;
            this.setText("&Remove");
            this.setImageDescriptor(ImageUtil.getImageDescriptor(Images.group_delete));
        }

        public void run() {
            if (GroupNavigationView.this.win != null && MessageDialog.openConfirm((Shell)GroupNavigationView.this.win.getShell(), (String)("Remove " + this.groupName), (String)(String.valueOf(this.groupName) + " group will be removed. Continue?"))) {
                GroupManager.getInstance().removeGroup(this.groupName);
                GroupNavigationView.this.forceRefresh();
            }
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof LinkedMap) {
                Enumeration e = ((LinkedMap)inputElement).values();
                Object[] objArray = new Object[((LinkedMap)inputElement).size()];
                int cnt = 0;
                while (e.hasMoreElements()) {
                    objArray[cnt] = e.nextElement();
                    ++cnt;
                }
                return objArray;
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof HierarchyObject) {
                if (parentElement instanceof AgentObject) {
                    return new Object[0];
                }
                return ((HierarchyObject)parentElement).getSortedChildArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof HierarchyObject) {
                return ((HierarchyObject)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof HierarchyObject) {
                if (element instanceof AgentObject) {
                    return false;
                }
                return ((HierarchyObject)element).getChildSize() > 0;
            }
            return false;
        }
    }

    class TreeLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getForeground(Object element) {
            AgentObject a;
            if (element instanceof AgentObject && !(a = (AgentObject)element).isAlive()) {
                return ColorUtil.getInstance().getColor("gray");
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof DummyObject) {
                        DummyObject dummyObj = (DummyObject)element;
                        if (dummyObj.getChildSize() > 0) {
                            return Images.folder;
                        }
                        return Images.default_context;
                    }
                    if (element instanceof GroupObject) {
                        GroupObject grpObj = (GroupObject)element;
                        return Images.getObjectIcon(grpObj.getObjType(), true, 0);
                    }
                    if (!(element instanceof AgentObject)) break;
                    AgentObject agent = (AgentObject)element;
                    if (agent.isAlive()) {
                        return Images.active;
                    }
                    return Images.dead;
                }
            }
            return null;
        }

        public String getColumnText(Object obj, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (obj instanceof AgentObject) {
                        AgentObject agent = (AgentObject)obj;
                        return agent.getObjName();
                    }
                    if (obj instanceof DummyObject) {
                        return ((DummyObject)obj).getName();
                    }
                    if (obj instanceof GroupObject) {
                        return ((GroupObject)obj).getName();
                    }
                    return obj.toString();
                }
                case 1: {
                    AgentObject agent;
                    if (!(obj instanceof AgentObject) || !(agent = (AgentObject)obj).isAlive()) break;
                    Value value = agent.getMasterCounter();
                    if (value == null) {
                        return "";
                    }
                    Server server = ServerManager.getInstance().getServer(agent.getServerId());
                    if (server == null) {
                        return "?";
                    }
                    return this.getColumnTextForByte(value, server.getCounterEngine().getMasterCounterUnit(agent.getObjType()));
                }
            }
            return null;
        }

        public String getColumnTextForByte(Value value, String unit) {
            if ("bytes".equals(unit)) {
                double v = CastUtil.cdouble((Object)value);
                return ScouterUtil.humanReadableByteCount(v, true);
            }
            return String.valueOf(FormatUtil.print((Object)value, (String)"#,###.##")) + " " + unit;
        }
    }
}

