/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.group.view;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.net.TcpProxy;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.views.AbstractServiceGroupElapsedView;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;

public class ServiceGroupElapsedGroupView
extends AbstractServiceGroupElapsedView {
    public static final String ID = ServiceGroupElapsedGroupView.class.getName();
    String grpName;
    private Map<Integer, ListValue> serverObjMap = new HashMap<Integer, ListValue>();

    public void init(IViewSite site) throws PartInitException {
        String secId;
        super.init(site);
        this.grpName = secId = site.getSecondaryId();
    }

    @Override
    public void createPartControl(Composite parent) {
        this.setPartName("Service[Elapsed] - " + this.grpName);
        super.createPartControl(parent);
    }

    @Override
    public MapPack fetch() {
        ScouterUtil.collectGroupObjcts(this.grpName, this.serverObjMap);
        HashMap<String, PerfStat> valueMap = new HashMap<String, PerfStat>();
        for (int serverId : this.serverObjMap.keySet()) {
            TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objHash", (Value)this.serverObjMap.get(serverId));
                    MapPack p = (MapPack)tcp.getSingle("REALTIME_SERVICE_GROUP", (Pack)param);
                    if (p != null) {
                        ListValue nameLv = p.getList("name");
                        ListValue countLv = p.getList("count");
                        ListValue elapsedLv = p.getList("elapsed");
                        ListValue errorLv = p.getList("error");
                        int i = 0;
                        int max = nameLv == null ? 0 : nameLv.size();
                        while (i < max) {
                            String name = nameLv.getString(i);
                            PerfStat perf = (PerfStat)valueMap.get(name);
                            if (perf == null) {
                                perf = new PerfStat();
                                valueMap.put(name, perf);
                            }
                            perf.count += CastUtil.cint((Object)countLv.get(i));
                            perf.elapsed += CastUtil.clong((Object)elapsedLv.get(i));
                            perf.error += CastUtil.cint((Object)errorLv.get(i));
                            ++i;
                        }
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    continue;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        MapPack m = null;
        if (valueMap.size() > 0) {
            m = new MapPack();
            ListValue nameLv = m.newList("name");
            ListValue countLv = m.newList("count");
            ListValue elapsedLv = m.newList("elapsed");
            ListValue errorLv = m.newList("error");
            for (String name : valueMap.keySet()) {
                PerfStat perf = (PerfStat)valueMap.get(name);
                nameLv.add(name);
                countLv.add((long)perf.count);
                elapsedLv.add(perf.elapsed);
                errorLv.add((long)perf.error);
            }
            long time = TimeUtil.getCurrentTime();
            m.put("time", time);
        }
        return m;
    }

    public static class PerfStat {
        public int count;
        public int error;
        public long elapsed;

        public void add(PerfStat o) {
            this.count += o.count;
            this.error += o.error;
            this.elapsed += o.elapsed;
        }
    }
}

