/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.group.view;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.model.AgentModelThread;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ScouterUtil;
import scouter.client.views.VerticalEQCommonView;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;

public class VerticalEQGroupView
extends VerticalEQCommonView {
    public static final String ID = VerticalEQGroupView.class.getName();
    private Map<Integer, ListValue> serverObjMap = new HashMap<Integer, ListValue>();
    private String grpName;

    public void init(IViewSite site) throws PartInitException {
        String secId;
        super.init(site);
        this.grpName = secId = site.getSecondaryId();
    }

    @Override
    public void createPartControl(Composite parent) {
        this.setPartName("Active Service Vertical EQ - " + this.grpName);
        super.createPartControl(parent);
    }

    @Override
    public void fetch() {
        ScouterUtil.collectGroupObjcts(this.grpName, this.serverObjMap);
        for (int serverId : this.serverObjMap.keySet()) {
            TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objHash", (Value)this.serverObjMap.get(serverId));
                    tcp.process("ACTIVESPEED_GROUP_REAL_TIME", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            MapPack m = (MapPack)in.readPack();
                            VerticalEQCommonView.ActiveSpeedData asd = new VerticalEQCommonView.ActiveSpeedData();
                            asd.act1 = CastUtil.cint((Object)m.get("act1"));
                            asd.act2 = CastUtil.cint((Object)m.get("act2"));
                            asd.act3 = CastUtil.cint((Object)m.get("act3"));
                            int objHash = CastUtil.cint((Object)m.get("objHash"));
                            VerticalEQCommonView.EqData data = new VerticalEQCommonView.EqData();
                            data.objHash = objHash;
                            data.asd = asd;
                            data.displayName = ScouterUtil.getFullObjName(objHash);
                            data.isAlive = AgentModelThread.getInstance().getAgentObject(objHash).isAlive();
                            VerticalEQGroupView.this.valueSet.add(data);
                        }
                    });
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    continue;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
    }
}

