/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.group.view;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.group.GroupManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.model.XLogData;
import scouter.client.model.XLogDataComparator;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.popup.CalendarDialog;
import scouter.client.popup.TimeRangeDialog;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.xlog.XLogUtil;
import scouter.client.xlog.views.XLogViewCommon;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.DateUtil;

public class XLogLoadTimeGroupView
extends XLogViewCommon
implements TimeRangeDialog.ITimeRange,
CalendarDialog.ILoadCalendarDialog {
    public static final String ID = XLogLoadTimeGroupView.class.getName();
    private String grpName;
    private Server defaultServer = ServerManager.getInstance().getDefaultServer();
    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    private Map<Integer, ListValue> serverObjMap = new HashMap<Integer, ListValue>();
    private long stime;
    private long etime;
    private int firstServerId;
    LoadXLogJob loadJob;
    private GroupManager manager = GroupManager.getInstance();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] datas = secId.split("&");
        this.grpName = datas[0];
        this.objType = datas[1];
    }

    @Override
    protected void openInExternalLink() {
        Program.launch((String)this.makeExternalUrl(this.firstServerId));
    }

    @Override
    protected void clipboardOfExternalLink() {
        Clipboard clipboard = new Clipboard(this.getViewSite().getShell().getDisplay());
        String linkUrl = this.makeExternalUrl(this.firstServerId);
        clipboard.setContents((Object[])new String[]{linkUrl}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }

    public void createPartControl(Composite parent) {
        this.display = Display.getCurrent();
        this.shell = new Shell(this.display);
        this.setPartName("XLog - " + this.grpName);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        this.create(parent, man);
        man.add((IAction)new Action("zoom in", ImageUtil.getImageDescriptor(Images.zoomin)){

            public void run() {
                TimeRangeDialog dialog = new TimeRangeDialog(XLogLoadTimeGroupView.this.display, XLogLoadTimeGroupView.this, DateUtil.yyyymmdd((long)XLogLoadTimeGroupView.this.stime));
                dialog.show(XLogLoadTimeGroupView.this.stime, XLogLoadTimeGroupView.this.etime);
            }
        });
        man.add((IAction)new Action("zoom out", ImageUtil.getImageDescriptor(Images.zoomout)){

            public void run() {
                if (XLogLoadTimeGroupView.this.viewPainter.isZoomMode()) {
                    XLogLoadTimeGroupView.this.viewPainter.endZoom();
                } else {
                    XLogLoadTimeGroupView.this.viewPainter.keyPressed(16777261);
                    XLogLoadTimeGroupView.this.viewPainter.build();
                }
                XLogLoadTimeGroupView.this.canvas.redraw();
            }
        });
        man.add((IContributionItem)new Separator());
        this.createContextMenu(parent, new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (!XLogLoadTimeGroupView.this.viewPainter.isZoomMode()) {
                    manager.add((IAction)new Action("Load"){

                        public void run() {
                            CalendarDialog dialog = new CalendarDialog(XLogLoadTimeGroupView.this.display, XLogLoadTimeGroupView.this);
                            dialog.showWithEndTime();
                        }
                    });
                    manager.add((IAction)new Action("Zoom In", ImageDescriptor.createFromImage((Image)Images.zoomin)){

                        public void run() {
                            TimeRangeDialog dialog = new TimeRangeDialog(XLogLoadTimeGroupView.this.display, XLogLoadTimeGroupView.this, DateUtil.yyyymmdd((long)(this).XLogLoadTimeGroupView.this.stime));
                            dialog.show((this).XLogLoadTimeGroupView.this.stime, (this).XLogLoadTimeGroupView.this.etime);
                        }
                    });
                }
            }
        });
        this.canvas.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                XLogLoadTimeGroupView.this.viewPainter.set(XLogLoadTimeGroupView.this.canvas.getClientArea());
                XLogLoadTimeGroupView.this.viewPainter.build();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.setObjType(this.objType);
    }

    private void createContextMenu(Composite parent, IMenuListener listener) {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(listener);
        Menu menu = contextMenu.createContextMenu((Control)parent);
        this.canvas.setMenu(menu);
    }

    @Override
    public void setFocus() {
        super.setFocus();
    }

    public void setInput(long stime, long etime) {
        this.stime = stime;
        this.etime = etime;
        this.viewPainter.setEndTime(etime);
        this.viewPainter.setTimeRange(etime - stime);
        this.setDate(DateUtil.yyyymmdd((long)stime));
        String objTypeDisplay = this.defaultServer.getCounterEngine().getDisplayNameObjectType(this.objType);
        this.setContentDescription(String.valueOf(this.grpName) + " | " + objTypeDisplay + "'s " + "XLog Pasttime" + " | " + DateUtil.format((long)stime, (String)"yyyy-MM-dd") + "(" + DateUtil.format((long)stime, (String)"HH:mm") + "~" + DateUtil.format((long)etime, (String)"HH:mm") + ")");
        try {
            this.loadJob = new LoadXLogJob();
            this.loadJob.schedule();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.shell, (String)"Error", (String)e.getMessage());
        }
    }

    private void collectObj() {
        this.serverObjMap.clear();
        Set<Integer> objHashs = this.manager.getObjectsByGroup(this.grpName);
        for (int objHash : objHashs) {
            ListValue lv;
            AgentObject agentObj = AgentModelThread.getInstance().getAgentObject(objHash);
            if (agentObj == null || !agentObj.isAlive()) continue;
            int serverId = agentObj.getServerId();
            if (this.firstServerId == 0) {
                this.firstServerId = serverId;
            }
            if ((lv = this.serverObjMap.get(serverId)) == null) {
                lv = new ListValue();
                this.serverObjMap.put(serverId, lv);
            }
            lv.add((long)objHash);
        }
    }

    @Override
    public void loadAdditinalData(long stime, long etime, boolean reverse) {
        this.collectObj();
        Iterator<Integer> serverIds = this.serverObjMap.keySet().iterator();
        final TreeSet<XLogData> tempSet = new TreeSet<XLogData>(new XLogDataComparator());
        int limit = PManager.getInstance().getInt("xlog_ignore_time");
        final int max = this.getMaxCount();
        while (serverIds.hasNext()) {
            final int serverId = serverIds.next();
            TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("date", DateUtil.yyyymmdd((long)stime));
                    param.put("stime", stime);
                    param.put("etime", etime);
                    param.put("objHash", (Value)this.serverObjMap.get(serverId));
                    param.put("reverse", (Value)new BooleanValue(reverse));
                    if (limit > 0) {
                        param.put("limit", (long)limit);
                    }
                    if (max > 0) {
                        param.put("max", (long)max);
                    }
                    this.twdata.setMax(max);
                    tcp.process("TRANX_LOAD_TIME_GROUP", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            Pack p = in.readPack();
                            XLogPack x = XLogUtil.toXLogPack(p);
                            if (tempSet.size() < max) {
                                tempSet.add(new XLogData(x, serverId));
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    continue;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (reverse) {
            Iterator<XLogData> itr = tempSet.descendingIterator();
            while (itr.hasNext()) {
                XLogData d = itr.next();
                this.twdata.putFirst(d.p.txid, (Object)d);
            }
        } else {
            for (XLogData d : tempSet) {
                this.twdata.putLast(d.p.txid, (Object)d);
            }
        }
    }

    @Override
    public void setTimeRange(long stime, long etime) {
        if (this.viewPainter.zoomIn(stime, etime)) {
            this.canvas.redraw();
        }
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
        this.setInput(startTime, endTime);
    }

    @Override
    public void onPressedOk(String date) {
    }

    @Override
    public void onPressedCancel() {
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.loadJob != null && (this.loadJob.getState() == 2 || this.loadJob.getState() == 4)) {
            this.loadJob.cancel();
        }
    }

    class LoadXLogJob
    extends Job {
        int count;

        public LoadXLogJob() {
            super("XLog Loading...(" + DateUtil.format((long)XLogLoadTimeGroupView.this.stime, (String)"yyyy-MM-dd") + " " + DateUtil.format((long)XLogLoadTimeGroupView.this.stime, (String)"HH:mm") + "~" + DateUtil.format((long)XLogLoadTimeGroupView.this.etime, (String)"HH:mm") + ")");
            this.count = 0;
        }

        protected IStatus run(final IProgressMonitor monitor) {
            monitor.beginTask("Loading...", -1);
            XLogLoadTimeGroupView.this.twdata.clear();
            XLogLoadTimeGroupView.this.collectObj();
            Iterator<Integer> serverIds = XLogLoadTimeGroupView.this.serverObjMap.keySet().iterator();
            final TreeSet<XLogData> tempSet = new TreeSet<XLogData>(new XLogDataComparator());
            int limit = PManager.getInstance().getInt("xlog_ignore_time");
            final int max = XLogLoadTimeGroupView.this.getMaxCount();
            XLogLoadTimeGroupView.this.twdata.setMax(max);
            while (serverIds.hasNext()) {
                final int serverId = serverIds.next();
                Server server = ServerManager.getInstance().getServer(serverId);
                monitor.subTask(String.valueOf(server.getName()) + " data loading...");
                TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
                try {
                    try {
                        MapPack param = new MapPack();
                        param.put("date", DateUtil.yyyymmdd((long)XLogLoadTimeGroupView.this.stime));
                        param.put("stime", XLogLoadTimeGroupView.this.stime);
                        param.put("etime", XLogLoadTimeGroupView.this.etime);
                        param.put("objHash", (Value)XLogLoadTimeGroupView.this.serverObjMap.get(serverId));
                        if (limit > 0) {
                            param.put("limit", (long)limit);
                        }
                        if (max > 0) {
                            param.put("max", (long)max);
                        }
                        tcp.process("TRANX_LOAD_TIME_GROUP", param, new INetReader(){

                            @Override
                            public void process(DataInputX in) throws IOException {
                                Pack p = in.readPack();
                                if (monitor.isCanceled()) {
                                    throw new IOException("User cancelled");
                                }
                                XLogPack x = XLogUtil.toXLogPack(p);
                                if (tempSet.size() < max) {
                                    tempSet.add(new XLogData(x, serverId));
                                    ++LoadXLogJob.this.count;
                                }
                                if (LoadXLogJob.this.count % 10000 == 0) {
                                    monitor.subTask(String.valueOf(LoadXLogJob.this.count) + " XLog data received.");
                                }
                            }
                        });
                    }
                    catch (Throwable e) {
                        ConsoleProxy.errorSafe(e.toString());
                        TcpProxy.putTcpProxy(tcp);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    TcpProxy.putTcpProxy(tcp);
                    throw throwable;
                }
                TcpProxy.putTcpProxy(tcp);
            }
            for (XLogData d : tempSet) {
                XLogLoadTimeGroupView.this.twdata.putLast(d.p.txid, (Object)d);
            }
            monitor.done();
            this.refresh();
            return Status.OK_STATUS;
        }

        private void refresh() {
            XLogLoadTimeGroupView.this.viewPainter.build();
            ExUtil.exec((Composite)XLogLoadTimeGroupView.this.canvas, new Runnable(){

                @Override
                public void run() {
                    XLogLoadTimeGroupView.this.canvas.redraw();
                }
            });
        }
    }
}

