/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.group.view;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.group.GroupManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.model.RefreshThread;
import scouter.client.model.XLogData;
import scouter.client.model.XLogDataComparator;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;
import scouter.client.xlog.XLogUtil;
import scouter.client.xlog.views.XLogViewCommon;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.DateUtil;

public class XLogRealTimeGroupView
extends XLogViewCommon
implements RefreshThread.Refreshable {
    public static final String ID = XLogRealTimeGroupView.class.getName();
    protected RefreshThread thread;
    private String grpName;
    private Server defaultServer = ServerManager.getInstance().getDefaultServer();
    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    private Map<Integer, ListValue> serverObjMap = new HashMap<Integer, ListValue>();
    private Map<Integer, MapPack> paramMap = new HashMap<Integer, MapPack>();
    private int firstServerId;
    private GroupManager manager = GroupManager.getInstance();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] datas = secId.split("&");
        this.grpName = datas[0];
        this.objType = datas[1];
    }

    @Override
    protected void openInExternalLink() {
        Program.launch((String)this.makeExternalUrl(this.firstServerId));
    }

    @Override
    protected void clipboardOfExternalLink() {
        Clipboard clipboard = new Clipboard(this.getViewSite().getShell().getDisplay());
        String linkUrl = this.makeExternalUrl(this.firstServerId);
        clipboard.setContents((Object[])new String[]{linkUrl}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }

    public void createPartControl(Composite parent) {
        this.display = Display.getCurrent();
        this.shell = new Shell(this.display);
        String objTypeDisplay = this.defaultServer.getCounterEngine().getDisplayNameObjectType(this.objType);
        this.setPartName("XLog - " + this.grpName);
        this.setContentDescription(String.valueOf(this.grpName) + " | " + objTypeDisplay + "'s " + "Group XLog Realtime");
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        this.create(parent, man);
        man.add((IAction)new Action("zoom in", ImageUtil.getImageDescriptor(Images.zoomin)){

            public void run() {
                XLogRealTimeGroupView.this.viewPainter.keyPressed(16777259);
                XLogRealTimeGroupView.this.viewPainter.build();
                XLogRealTimeGroupView.this.canvas.redraw();
            }
        });
        man.add((IAction)new Action("zoom out", ImageUtil.getImageDescriptor(Images.zoomout)){

            public void run() {
                XLogRealTimeGroupView.this.viewPainter.keyPressed(16777261);
                XLogRealTimeGroupView.this.viewPainter.build();
                XLogRealTimeGroupView.this.canvas.redraw();
            }
        });
        man.add((IContributionItem)new Separator());
        this.canvas.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                XLogRealTimeGroupView.this.viewPainter.set(XLogRealTimeGroupView.this.canvas.getClientArea());
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.setObjType(this.objType);
        this.thread = new RefreshThread(this, 2000);
        this.thread.setName(String.valueOf(this.toString()) + " - " + "grpName: " + this.grpName);
        this.thread.start();
    }

    @Override
    public void setFocus() {
        super.setFocus();
    }

    private void collectObj() {
        this.serverObjMap.clear();
        Set<Integer> objHashs = this.manager.getObjectsByGroup(this.grpName);
        for (int objHash : objHashs) {
            ListValue lv;
            AgentObject agentObj = AgentModelThread.getInstance().getAgentObject(objHash);
            if (agentObj == null || !agentObj.isAlive()) continue;
            int serverId = agentObj.getServerId();
            if (this.firstServerId == 0) {
                this.firstServerId = serverId;
            }
            if ((lv = this.serverObjMap.get(serverId)) == null) {
                lv = new ListValue();
                this.serverObjMap.put(serverId, lv);
            }
            lv.add((long)objHash);
        }
    }

    public void forceRefresh() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                XLogRealTimeGroupView.this.paramMap.clear();
                XLogRealTimeGroupView.this.refresh();
            }
        });
    }

    @Override
    public void refresh() {
        this.setDate(DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime()));
        this.collectObj();
        Integer[] serverIds = this.serverObjMap.keySet().toArray(new Integer[this.serverObjMap.size()]);
        final TreeSet<XLogData> tempSet = new TreeSet<XLogData>(new XLogDataComparator());
        int limit = PManager.getInstance().getInt("xlog_ignore_time");
        final int max = this.getMaxCount();
        this.twdata.setMax(max);
        Integer[] integerArray = serverIds;
        int n = serverIds.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                final int serverId = integerArray[n2];
                TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
                try {
                    try {
                        ListValue objHashLv;
                        MapPack param = this.paramMap.get(serverId);
                        if (param == null) {
                            param = new MapPack();
                            this.paramMap.put(serverId, param);
                        }
                        if ((objHashLv = this.serverObjMap.get(serverId)).size() > 0) {
                            param.put("objHash", (Value)objHashLv);
                            param.put("limit", (long)limit);
                            tcp.process("TRANX_REAL_TIME_GROUP", param, new INetReader(){

                                @Override
                                public void process(DataInputX in) throws IOException {
                                    Pack p = in.readPack();
                                    if (p instanceof MapPack) {
                                        MapPack param = (MapPack)p;
                                        XLogRealTimeGroupView.this.paramMap.put(serverId, param);
                                    } else {
                                        XLogPack x = XLogUtil.toXLogPack(p);
                                        tempSet.add(new XLogData(x, serverId));
                                        while (tempSet.size() >= max) {
                                            tempSet.pollFirst();
                                        }
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        ConsoleProxy.errorSafe(e.toString());
                        TcpProxy.putTcpProxy(tcp);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    TcpProxy.putTcpProxy(tcp);
                    throw throwable;
                }
                TcpProxy.putTcpProxy(tcp);
            }
            ++n2;
        }
        for (XLogData d : tempSet) {
            this.twdata.putLast(d.p.txid, (Object)d);
        }
        this.viewPainter.build();
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                XLogRealTimeGroupView.this.canvas.redraw();
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    @Override
    public void loadAdditinalData(long stime, long etime, boolean reverse) {
        this.viewPainter.setViewIsInAdditionalDataLoading(true);
        this.collectObj();
        Iterator<Integer> serverIds = this.serverObjMap.keySet().iterator();
        final TreeSet<XLogData> tempSet = new TreeSet<XLogData>(new XLogDataComparator());
        int limit = PManager.getInstance().getInt("xlog_ignore_time");
        final int max = this.getMaxCount();
        this.twdata.setMax(max);
        while (serverIds.hasNext()) {
            final int serverId = serverIds.next();
            TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("date", DateUtil.yyyymmdd((long)stime));
                    param.put("stime", stime);
                    param.put("etime", etime);
                    param.put("objHash", (Value)this.serverObjMap.get(serverId));
                    param.put("reverse", (Value)new BooleanValue(reverse));
                    if (limit > 0) {
                        param.put("limit", (long)limit);
                    }
                    if (max > 0) {
                        param.put("max", (long)max);
                    }
                    tcp.process("TRANX_LOAD_TIME_GROUP", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            Pack p = in.readPack();
                            XLogPack x = XLogUtil.toXLogPack(p);
                            if (tempSet.size() < max) {
                                tempSet.add(new XLogData(x, serverId));
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    this.viewPainter.setViewIsInAdditionalDataLoading(false);
                    TcpProxy.putTcpProxy(tcp);
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.viewPainter.setViewIsInAdditionalDataLoading(false);
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            this.viewPainter.setViewIsInAdditionalDataLoading(false);
            TcpProxy.putTcpProxy(tcp);
        }
        if (reverse) {
            Iterator<XLogData> itr = tempSet.descendingIterator();
            while (itr.hasNext()) {
                XLogData d = itr.next();
                this.twdata.putFirst(d.p.txid, (Object)d);
            }
        } else {
            for (XLogData d : tempSet) {
                this.twdata.putLast(d.p.txid, (Object)d);
            }
        }
    }
}

