/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.heapdump;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.actions.OpenWorkspaceExplorerAction;
import scouter.client.model.XLogProxy;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.RCPUtil;

public class SaveHeapDumpJob
extends Job {
    public static String hprofDirName = "heapdump";
    String workingDir = "";
    public static String hprofExtension = ".hprof";
    public static String hprofFileName = "";
    private int objHash;
    private String fileName;
    private String yyyymmdd;
    private int serverId;
    int maxBlock;
    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();

    public SaveHeapDumpJob(String name, int objHash, String fileName, String objName, int serverId) {
        super(name);
        this.objHash = objHash;
        this.fileName = fileName;
        this.serverId = serverId;
        this.yyyymmdd = fileName.substring(0, 8);
        String serverName = ServerManager.getInstance().getServer(serverId).getName();
        this.workingDir = RCPUtil.getWorkingDirectory() + "/" + serverName + "/" + this.yyyymmdd + "/" + objName + "/" + hprofDirName;
        hprofFileName = fileName;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Saveing Heapdump file to... " + this.workingDir + "/" + this.fileName, -1);
        this.checkAndCreateDir();
        boolean result = this.downloadHeapdump();
        monitor.done();
        if (!result) {
            ConsoleProxy.errorSafe("file writing error occured.");
            return Status.OK_STATUS;
        }
        ExUtil.exec(PlatformUI.getWorkbench().getDisplay(), new Runnable(){

            @Override
            public void run() {
                OpenWorkspaceExplorerAction act = new OpenWorkspaceExplorerAction(SaveHeapDumpJob.this.window, "Workspace Explorer", Images.explorer, true, SaveHeapDumpJob.this.serverId);
                act.run();
            }
        });
        return Status.OK_STATUS;
    }

    private void checkAndCreateDir() {
        File hprofDir = new File(this.workingDir);
        if (!hprofDir.exists()) {
            hprofDir.mkdirs();
        }
    }

    private boolean downloadHeapdump() {
        return XLogProxy.getHeapdumpByteArray(this.objHash, this.fileName, String.valueOf(this.workingDir) + "/" + hprofFileName, this.serverId);
    }
}

