/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.heapdump.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchWindow;
import scouter.client.net.TcpProxy;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.BooleanValue;
import scouter.util.CastUtil;

public class BlockProfileAction
extends Action {
    public static final String ID = BlockProfileAction.class.getName();
    private final IWorkbenchWindow window;
    private String key;
    private int objHash;
    private String objName;
    private String fName;
    private long time;
    private int serverId;

    public BlockProfileAction(IWorkbenchWindow window, String label, String key, int objHash, String fName, long time, Image image, int serverId) {
        this.window = window;
        this.key = key;
        this.objHash = objHash;
        this.objName = fName;
        this.fName = String.valueOf(fName) + "_block";
        this.time = time;
        this.serverId = serverId;
        this.setText(label);
        this.setId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
    }

    public void run() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                TcpProxy tcp = TcpProxy.getTcpProxy(BlockProfileAction.this.serverId);
                try {
                    MapPack param = new MapPack();
                    param.put("objHash", (long)BlockProfileAction.this.objHash);
                    param.put("fName", BlockProfileAction.this.fName);
                    param.put("time", BlockProfileAction.this.time);
                    MapPack out = (MapPack)tcp.getSingle("OBJECT_CALL_BLOCK_PROFILE", (Pack)param);
                    if (out != null && !CastUtil.cboolean((Object)((BooleanValue)out.get("success")))) {
                        ConsoleProxy.infoSafe(out.getText("msg"));
                    }
                }
                finally {
                    TcpProxy.putTcpProxy(tcp);
                }
            }
        });
    }
}

