/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.heapdump.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import scouter.client.heapdump.views.HeapDumpListView;
import scouter.client.util.ImageUtil;

public class HeapDumpListAction
extends Action {
    public static final String ID = HeapDumpListAction.class.getName();
    private final IWorkbenchWindow window;
    private String objName;
    private int objHash;
    private int serverId;

    public HeapDumpListAction(IWorkbenchWindow window, String label, String objName, int objHash, Image image, int serverId) {
        this.window = window;
        this.objName = objName;
        this.objHash = objHash;
        this.serverId = serverId;
        this.setText(label);
        this.setId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
    }

    public void run() {
        if (this.window != null) {
            try {
                HeapDumpListView v = (HeapDumpListView)this.window.getActivePage().showView(HeapDumpListView.ID, "" + this.objHash, 1);
                if (v != null) {
                    v.setInput(this.objHash, this.objName, this.serverId);
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }
}

