/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.heapdump.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.heapdump.actions.HeapDumpDeleteAction;
import scouter.client.heapdump.actions.HeapDumpDownloadAction;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.SortUtil;
import scouter.client.util.TableControlAdapter;
import scouter.client.util.UIUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.FormatUtil;
import scouter.util.StringUtil;

public class HeapDumpListView
extends ViewPart
implements UIUtil.ViewWithTable {
    public static final String ID = HeapDumpListView.class.getName();
    private Table table = null;
    private int objHash;
    private String objName;
    private IMemento memento;
    Display display = null;
    boolean asc = true;
    int col_idx;
    boolean isNum;
    private int serverId;
    TableColumn[] cols;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void createPartControl(Composite parent) {
        this.display = Display.getCurrent();
        parent.setLayout((Layout)ChartUtil.gridlayout(1));
        this.table = this.build(parent);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    HeapDumpListView.this.reload();
                }
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent event) {
                if (event.button == 3) {
                    TableItem[] tebleItems = HeapDumpListView.this.table.getSelection();
                    final String fileName = tebleItems[0].getText();
                    Menu menu = new Menu((Decorations)HeapDumpListView.this.table.getShell(), 8);
                    MenuItem downloadItem = new MenuItem(menu, 8);
                    downloadItem.setText("Download");
                    downloadItem.setImage(Images.download);
                    downloadItem.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            HeapDumpDownloadAction act = new HeapDumpDownloadAction(window, "Download Binary Dump", fileName, (this).HeapDumpListView.this.objName, (this).HeapDumpListView.this.objHash, Images.heap, (this).HeapDumpListView.this.serverId);
                            act.run();
                        }
                    });
                    MenuItem deleteItem = new MenuItem(menu, 8);
                    deleteItem.setText("Delete");
                    deleteItem.setImage(Images.table_delete);
                    deleteItem.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            HeapDumpDeleteAction act = new HeapDumpDeleteAction(window, "Delete Binary Dump", fileName, (this).HeapDumpListView.this.objHash, fileName, Images.heap, (this).HeapDumpListView.this.serverId);
                            act.run();
                            HeapDumpListView.this.reload();
                        }
                    });
                    Point pt = new Point(event.x, event.y);
                    pt = HeapDumpListView.this.table.toDisplay(pt);
                    menu.setLocation(pt.x, pt.y);
                    menu.setVisible(true);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        parent.addControlListener((ControlListener)new TableControlAdapter(this.table, this.cols, new int[]{-1, 6}));
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                HeapDumpListView.this.reload();
            }
        });
        this.restoreState();
    }

    public void setInput(int objHash, String objName, int serverId) {
        this.objHash = objHash;
        this.objName = objName;
        this.serverId = serverId;
        Server server = ServerManager.getInstance().getServer(serverId);
        String svrName = server.getName();
        this.setContentDescription("\u24e2" + svrName + " | Heap Dump files in '" + objName + "'");
        ExUtil.exec(new Runnable(){

            @Override
            public void run() {
                HeapDumpListView.this.reload();
            }
        });
    }

    public void reload() {
        MapPack mpack;
        block13: {
            if (this.table == null) {
                return;
            }
            mpack = null;
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objHash", (long)this.objHash);
                    param.put("objName", this.objName);
                    mpack = (MapPack)tcp.getSingle("OBJECT_LIST_HEAP_DUMP", (Pack)param);
                }
                catch (Exception e) {
                    ConsoleProxy.errorSafe(e.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (mpack == null) {
            this.table.removeAll();
            return;
        }
        ListValue nameLv = mpack.getList("name");
        ListValue sizeLv = mpack.getList("size");
        TableItem[] tItem = this.table.getItems();
        if (tItem.length != nameLv.size()) {
            this.table.removeAll();
            tItem = this.table.getItems();
        }
        int rows = nameLv == null ? 0 : nameLv.size();
        int i = 0;
        while (i < rows) {
            TableItem t = null;
            t = tItem != null && tItem.length > 0 && i < tItem.length && tItem[i] != null ? tItem[i] : new TableItem(this.table, 0, i);
            double size = CastUtil.clong((Object)sizeLv.get(i));
            String fileSize = "";
            if (size > 1048576.0) {
                fileSize = String.valueOf(FormatUtil.print((Object)(size / 1048576.0), (String)"#,##0.0")) + " MB";
            } else if (size > 1024.0) {
                fileSize = String.valueOf(FormatUtil.print((Object)(size / 1024.0), (String)"#,##0.0")) + " KB";
            }
            String[] datas = new String[]{CastUtil.cString((Object)nameLv.get(i)), fileSize};
            int inx = 0;
            while (inx < datas.length) {
                datas[inx] = StringUtil.trimToEmpty((String)datas[inx]);
                ++inx;
            }
            t.setText(datas);
            ++i;
        }
        this.sortTable();
    }

    private Table build(Composite parent) {
        Table table = new Table(parent, 68416);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.cols = new TableColumn[2];
        this.cols[0] = UIUtil.create(table, 16384, "Name", this.cols.length, 0, false, 350, this);
        this.cols[1] = UIUtil.create(table, 131072, "Size", this.cols.length, 1, true, 100, this);
        return table;
    }

    @Override
    public void setSortCriteria(boolean asc, int col_idx, boolean isNum) {
        this.asc = asc;
        this.col_idx = col_idx;
        this.isNum = isNum;
    }

    @Override
    public void setTableItem(TableItem t) {
    }

    public void setFocus() {
    }

    public void sortTable() {
        int col_count = this.table.getColumnCount();
        TableItem[] items = this.table.getItems();
        if (this.isNum) {
            new SortUtil(this.asc).sort_num(items, this.col_idx, col_count);
        } else {
            new SortUtil(this.asc).sort_str(items, this.col_idx, col_count);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento = memento.createChild(ID);
        memento.putInteger("objHash", this.objHash);
        memento.putString("objName", this.objName);
        memento.putInteger("serverId", this.serverId);
    }

    private void restoreState() {
        if (this.memento == null) {
            return;
        }
        IMemento m = this.memento.getChild(ID);
        if (m == null) {
            return;
        }
        int objHash = m.getInteger("objHash");
        String objName = m.getString("objName");
        int serverId = CastUtil.cint((Object)m.getInteger("serverId"));
        this.setInput(objHash, objName, serverId);
    }
}

