/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.host.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.FormatUtil;

public class DiskUsageView
extends ViewPart {
    public static final String ID = DiskUsageView.class.getName();
    private TableViewer viewer;
    private TableColumnLayout tableColumnLayout;
    private Clipboard clipboard;
    private int objHash;
    private int serverId;
    boolean ctrlPressed = false;

    public void createPartControl(Composite parent) {
        this.initialLayout(parent);
        this.clipboard = new Clipboard(null);
    }

    private void initialLayout(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComposite.setLayout((Layout)new GridLayout(1, true));
        this.createTableViewer(tableComposite);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                DiskUsageView.this.load();
            }
        });
    }

    public void setInput(int serverId, int objHash) {
        this.serverId = serverId;
        this.objHash = objHash;
        this.setPartName("Disk Usage[" + TextProxy.object.getText(objHash) + "]");
        Server server = ServerManager.getInstance().getServer(serverId);
        String serverName = null;
        if (server != null) {
            serverName = server.getName();
        }
        this.setContentDescription("\u24e2" + serverName + "|" + TextProxy.object.getText(objHash));
        this.load();
    }

    private void createTableViewer(Composite composite) {
        this.viewer = new TableViewer(composite, 67586);
        this.tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)this.tableColumnLayout);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableContextMenu();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.viewer).setCustomCompare(new ColumnLabelSorter.ICustomCompare(){

            @Override
            public int doCompare(TableColumn col, int index, Object o1, Object o2) {
                ILabelProvider labelProvider = (ILabelProvider)DiskUsageView.this.viewer.getLabelProvider(index);
                String t1 = labelProvider.getText(o1);
                String t2 = labelProvider.getText(o2);
                Boolean isNumber = (Boolean)col.getData("isNumber");
                if (isNumber != null && isNumber.booleanValue()) {
                    String number1 = ColumnLabelSorter.numonly(t1);
                    String number2 = ColumnLabelSorter.numonly(t2);
                    double n1 = CastUtil.cdouble((Object)number1);
                    double n2 = CastUtil.cdouble((Object)number2);
                    if (t1.endsWith("G")) {
                        n1 *= Math.pow(1024.0, 3.0);
                    } else if (t1.endsWith("M")) {
                        n1 *= Math.pow(1024.0, 2.0);
                    } else if (t1.endsWith("K")) {
                        n1 *= Math.pow(1024.0, 1.0);
                    }
                    if (t2.endsWith("G")) {
                        n2 *= Math.pow(1024.0, 3.0);
                    } else if (t2.endsWith("M")) {
                        n2 *= Math.pow(1024.0, 2.0);
                    } else if (t2.endsWith("K")) {
                        n2 *= Math.pow(1024.0, 1.0);
                    }
                    if (n1 == n2) {
                        return 0;
                    }
                    return n1 > n2 ? 1 : -1;
                }
                if (t1 == null) {
                    t1 = "";
                }
                if (t2 == null) {
                    t2 = "";
                }
                return t1.compareTo(t2);
            }
        }));
        GridData gridData = new GridData(4, 4, true, true);
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void createTableContextMenu() {
        MenuManager manager = new MenuManager();
        this.viewer.getControl().setMenu(manager.createContextMenu(this.viewer.getControl()));
        manager.add((IAction)new Action("&Copy", ImageDescriptor.createFromImage((Image)Images.copy)){

            public void run() {
                DiskUsageView.this.selectionCopyToClipboard();
            }
        });
        this.viewer.getTable().addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 262144) {
                    DiskUsageView.this.ctrlPressed = true;
                } else if ((e.keyCode == 99 || e.keyCode == 67) && DiskUsageView.this.ctrlPressed) {
                    DiskUsageView.this.selectionCopyToClipboard();
                }
            }
        });
        this.viewer.getTable().addListener(2, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 262144) {
                    DiskUsageView.this.ctrlPressed = false;
                }
            }
        });
    }

    private void selectionCopyToClipboard() {
        TableItem[] items;
        if (this.viewer != null && (items = this.viewer.getTable().getSelection()) != null && items.length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                DiskData data = (DiskData)items[i].getData();
                sb.append(data.toString());
                ++i;
            }
            this.clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack pack;
                block8: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(DiskUsageView.this.serverId);
                    pack = null;
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objHash", (long)DiskUsageView.this.objHash);
                            pack = (MapPack)tcp.getSingle("HOST_DISK_USAGE", (Pack)param);
                        }
                        catch (Throwable t) {
                            ConsoleProxy.errorSafe(t.toString());
                            TcpProxy.putTcpProxy(tcp);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (pack != null) {
                    ListValue deviceList = pack.getList("Device");
                    ListValue totalList = pack.getList("Total");
                    ListValue usedList = pack.getList("Used");
                    ListValue freeList = pack.getList("Free");
                    ListValue pctList = pack.getList("Pct");
                    ListValue typeList = pack.getList("Type");
                    ListValue mountList = pack.getList("Mount");
                    final ArrayList<DiskData> diskList = new ArrayList<DiskData>();
                    if (deviceList != null && deviceList.size() > 0) {
                        int i = 0;
                        while (i < deviceList.size()) {
                            DiskData data = new DiskData();
                            diskList.add(data);
                            data.device = deviceList.getString(i);
                            data.total = totalList.getLong(i);
                            data.used = usedList.getLong(i);
                            data.free = freeList.getLong(i);
                            data.pct = (float)pctList.getDouble(i);
                            data.type = typeList.getString(i);
                            data.mount = mountList.getString(i);
                            ++i;
                        }
                    }
                    ExUtil.exec((Composite)DiskUsageView.this.viewer.getTable(), new Runnable(){

                        @Override
                        public void run() {
                            (this).DiskUsageView.this.viewer.setInput((Object)diskList);
                        }
                    });
                }
            }
        });
    }

    private void createColumns() {
        DiskColumnEnum[] diskColumnEnumArray = DiskColumnEnum.values();
        int n = diskColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            DiskColumnEnum column = diskColumnEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case DEVICE: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof DiskData) {
                                return ((DiskData)element).device;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case TOTAL: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof DiskData) {
                                return FormatUtil.printMem((double)((DiskData)element).total);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case USED: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof DiskData) {
                                return FormatUtil.printMem((double)((DiskData)element).used);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case FREE: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof DiskData) {
                                return FormatUtil.printMem((double)((DiskData)element).free);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case PCT: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof DiskData) {
                                return String.valueOf(FormatUtil.print((Object)Float.valueOf(((DiskData)element).pct), (String)"#0.0")) + "%";
                            }
                            return null;
                        }
                    };
                    break;
                }
                case TYPE: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof DiskData) {
                                return ((DiskData)element).type;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case MOUNT: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof DiskData) {
                                return ((DiskData)element).mount;
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        final TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(30, width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)DiskUsageView.this.viewer.getComparator();
                sorter.setColumn(column);
            }
        });
        return viewerColumn;
    }

    public void setFocus() {
    }

    public static enum DiskColumnEnum {
        DEVICE("Device", 100, 16384, true, true, false),
        TOTAL("Total", 70, 131072, true, true, true),
        USED("Used", 70, 131072, true, true, true),
        FREE("Free", 70, 131072, true, true, true),
        PCT("PCT", 50, 0x1000000, true, true, true),
        TYPE("Type", 70, 0x1000000, true, true, false),
        MOUNT("Mount", 80, 16384, true, true, false);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private DiskColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }

    class DiskData {
        public String device;
        public long total;
        public long used;
        public long free;
        public float pct;
        public String type;
        public String mount;

        DiskData() {
        }

        public String toString() {
            return String.valueOf(this.device) + "\t" + this.total + "\t" + this.used + "\t" + this.free + "\t" + this.pct + "\t" + this.type + "\t" + this.mount + "\n";
        }
    }
}

