/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.host.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.util.ColoringWord;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CustomLineStyleListener;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;

public class MemInfoView
extends ViewPart {
    public static final String ID = MemInfoView.class.getName();
    private StyledText text;
    private int objHash;
    private int serverId;
    private static ArrayList<ColoringWord> reserved = new ArrayList();

    static {
        reserved.add(new ColoringWord("Total ", 6, true));
        reserved.add(new ColoringWord("Available ", 6, true));
        reserved.add(new ColoringWord("Percent ", 6, true));
        reserved.add(new ColoringWord("Used ", 6, true));
        reserved.add(new ColoringWord("Free ", 6, true));
        reserved.add(new ColoringWord("Active ", 6, true));
        reserved.add(new ColoringWord("Inactive ", 6, true));
        reserved.add(new ColoringWord("Buffers ", 6, true));
        reserved.add(new ColoringWord("Cached ", 6, true));
        reserved.add(new ColoringWord("Sin ", 6, true));
        reserved.add(new ColoringWord("Sout ", 6, true));
    }

    public void setInput(int serverId, int objHash) {
        this.serverId = serverId;
        this.objHash = objHash;
        this.setPartName("Mem Info[" + TextProxy.object.getText(objHash) + "]");
        this.load();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.text = new StyledText(parent, 2818);
        this.text.setFont(new Font(null, "Courier New", 10, 0));
        this.text.addLineStyleListener((LineStyleListener)new CustomLineStyleListener(false, reserved, true));
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                MemInfoView.this.load();
            }
        });
    }

    public void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack mpack;
                block6: {
                    mpack = null;
                    TcpProxy tcp = TcpProxy.getTcpProxy(MemInfoView.this.serverId);
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objHash", (long)MemInfoView.this.objHash);
                            mpack = (MapPack)tcp.getSingle("HOST_MEMINFO", (Pack)param);
                        }
                        catch (Exception e) {
                            ConsoleProxy.errorSafe(e.toString());
                            TcpProxy.putTcpProxy(tcp);
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (mpack != null) {
                    final String result = mpack.getText("result");
                    ExUtil.exec((Composite)MemInfoView.this.text, new Runnable(){

                        @Override
                        public void run() {
                            (this).MemInfoView.this.text.setText(result);
                        }
                    });
                }
            }
        });
    }

    public void setFocus() {
    }
}

