/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.host.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;

public class NetStatView
extends ViewPart {
    public static final String ID = NetStatView.class.getName();
    private TableViewer viewer;
    private TableColumnLayout tableColumnLayout;
    private Clipboard clipboard;
    private int objHash;
    private int serverId;
    boolean ctrlPressed = false;

    public void createPartControl(Composite parent) {
        this.initialLayout(parent);
        this.clipboard = new Clipboard(null);
    }

    private void initialLayout(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComposite.setLayout((Layout)new GridLayout(1, true));
        this.createTableViewer(tableComposite);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                NetStatView.this.load();
            }
        });
    }

    public void setInput(int serverId, int objHash) {
        this.serverId = serverId;
        this.objHash = objHash;
        this.setPartName("Net Stat[" + TextProxy.object.getText(objHash) + "]");
        Server server = ServerManager.getInstance().getServer(serverId);
        String serverName = null;
        if (server != null) {
            serverName = server.getName();
        }
        this.setContentDescription("\u24e2" + serverName + "|" + TextProxy.object.getText(objHash));
        this.load();
    }

    private void createTableViewer(Composite composite) {
        this.viewer = new TableViewer(composite, 67586);
        this.tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)this.tableColumnLayout);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableContextMenu();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.viewer));
        GridData gridData = new GridData(4, 4, true, true);
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void createTableContextMenu() {
        MenuManager manager = new MenuManager();
        this.viewer.getControl().setMenu(manager.createContextMenu(this.viewer.getControl()));
        manager.add((IAction)new Action("&Copy", ImageDescriptor.createFromImage((Image)Images.copy)){

            public void run() {
                NetStatView.this.selectionCopyToClipboard();
            }
        });
        this.viewer.getTable().addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 262144) {
                    NetStatView.this.ctrlPressed = true;
                } else if ((e.keyCode == 99 || e.keyCode == 67) && NetStatView.this.ctrlPressed) {
                    NetStatView.this.selectionCopyToClipboard();
                }
            }
        });
        this.viewer.getTable().addListener(2, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 262144) {
                    NetStatView.this.ctrlPressed = false;
                }
            }
        });
    }

    private void selectionCopyToClipboard() {
        TableItem[] items;
        if (this.viewer != null && (items = this.viewer.getTable().getSelection()) != null && items.length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                NetStatData data = (NetStatData)items[i].getData();
                sb.append(data.toString());
                ++i;
            }
            this.clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private void load() {
        MapPack pack;
        block8: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            pack = null;
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objHash", (long)this.objHash);
                    pack = (MapPack)tcp.getSingle("HOST_NET_STAT", (Pack)param);
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (pack != null) {
            ListValue protoList = pack.getList("Proto");
            ListValue localAddrList = pack.getList("LocalAddr");
            ListValue remoteAddrList = pack.getList("RemoteAddr");
            ListValue statusList = pack.getList("Status");
            ListValue pidList = pack.getList("Pid");
            ListValue nameList = pack.getList("ProgramName");
            final ArrayList<NetStatData> diskList = new ArrayList<NetStatData>();
            if (protoList != null && protoList.size() > 0) {
                int i = 0;
                while (i < protoList.size()) {
                    NetStatData data = new NetStatData();
                    diskList.add(data);
                    data.proto = protoList.getString(i);
                    data.localAddr = localAddrList.getString(i);
                    data.remoteAddr = remoteAddrList.getString(i);
                    data.status = statusList.getString(i);
                    data.pid = pidList.getString(i);
                    data.programName = nameList.getString(i);
                    ++i;
                }
            }
            ExUtil.exec((Composite)this.viewer.getTable(), new Runnable(){

                @Override
                public void run() {
                    NetStatView.this.viewer.setInput((Object)diskList);
                }
            });
        }
    }

    private void createColumns() {
        DiskColumnEnum[] diskColumnEnumArray = DiskColumnEnum.values();
        int n = diskColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            DiskColumnEnum column = diskColumnEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case PROTO: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof NetStatData) {
                                return ((NetStatData)element).proto;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case LOCAL_ADDR: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof NetStatData) {
                                return ((NetStatData)element).localAddr;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case REMOTE_ADDR: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof NetStatData) {
                                return ((NetStatData)element).remoteAddr;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case STATUS: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof NetStatData) {
                                return ((NetStatData)element).status;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case PID: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof NetStatData) {
                                return ((NetStatData)element).pid;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case PROGRAM_NAME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof NetStatData) {
                                return ((NetStatData)element).programName;
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(30, width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)NetStatView.this.viewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    public void setFocus() {
    }

    public static enum DiskColumnEnum {
        PROTO("Proto", 50, 16384, true, true, false),
        LOCAL_ADDR("Local Addr", 150, 16384, true, true, false),
        REMOTE_ADDR("Remote Addr", 150, 16384, true, true, false),
        STATUS("Status", 100, 0x1000000, true, true, false),
        PID("PID", 50, 0x1000000, true, true, true),
        PROGRAM_NAME("Program Name", 100, 16384, true, true, false);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private DiskColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }

    class NetStatData {
        public String proto;
        public String localAddr;
        public String remoteAddr;
        public String status;
        public String pid;
        public String programName;

        NetStatData() {
        }

        public String toString() {
            return String.valueOf(this.proto) + "\t" + this.localAddr + "\t" + this.remoteAddr + "\t" + this.status + "\t" + this.pid + "\t" + this.programName + "\n";
        }
    }
}

