/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.host.views;

import java.util.ArrayList;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import scouter.client.net.TcpProxy;
import scouter.client.util.ColoringWord;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CustomLineStyleListener;
import scouter.client.util.ExUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;

public class ProcessDetailView
extends ViewPart {
    public static final String ID = ProcessDetailView.class.getName();
    private StyledText text;
    private int objHash;
    private int serverId;
    private int pid;
    private static ArrayList<ColoringWord> reserved = new ArrayList();

    static {
        reserved.add(new ColoringWord("pid ", 6, true));
        reserved.add(new ColoringWord("name ", 6, true));
        reserved.add(new ColoringWord("exe ", 6, true));
        reserved.add(new ColoringWord("parent ", 6, true));
        reserved.add(new ColoringWord("cmdline ", 6, true));
        reserved.add(new ColoringWord("started ", 6, true));
        reserved.add(new ColoringWord("user ", 6, true));
        reserved.add(new ColoringWord("uids ", 6, true));
        reserved.add(new ColoringWord("gids ", 6, true));
        reserved.add(new ColoringWord("terminal ", 6, true));
        reserved.add(new ColoringWord("cwd ", 6, true));
        reserved.add(new ColoringWord("memory ", 6, true));
        reserved.add(new ColoringWord("cpu ", 6, true));
        reserved.add(new ColoringWord("status ", 6, true));
        reserved.add(new ColoringWord("niceness ", 6, true));
        reserved.add(new ColoringWord("num threads ", 6, true));
        reserved.add(new ColoringWord("I/O ", 6, true));
        reserved.add(new ColoringWord("children ", 6, true));
        reserved.add(new ColoringWord("open files ", 6, true));
        reserved.add(new ColoringWord("running threads ", 6, true));
        reserved.add(new ColoringWord("open connections ", 6, true));
    }

    public void setInput(int serverId, int objHash, int pid) {
        this.serverId = serverId;
        this.objHash = objHash;
        this.pid = pid;
        this.setPartName("Process Detail[" + pid + "]");
        this.load();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.text = new StyledText(parent, 2818);
        this.text.setFont(new Font(null, "Courier New", 10, 0));
        this.text.addLineStyleListener((LineStyleListener)new CustomLineStyleListener(false, reserved, true));
    }

    public void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack mpack;
                block6: {
                    mpack = null;
                    TcpProxy tcp = TcpProxy.getTcpProxy(ProcessDetailView.this.serverId);
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objHash", (long)ProcessDetailView.this.objHash);
                            param.put("pid", (long)ProcessDetailView.this.pid);
                            mpack = (MapPack)tcp.getSingle("HOST_PROCESS_DETAIL", (Pack)param);
                        }
                        catch (Exception e) {
                            ConsoleProxy.errorSafe(e.toString());
                            TcpProxy.putTcpProxy(tcp);
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (mpack != null) {
                    final String result = mpack.getText("result");
                    ExUtil.exec((Composite)ProcessDetailView.this.text, new Runnable(){

                        @Override
                        public void run() {
                            (this).ProcessDetailView.this.text.setText(result);
                        }
                    });
                }
            }
        });
    }

    public void setFocus() {
    }
}

