/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.host.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;

public class TopView
extends ViewPart {
    public static final String ID = TopView.class.getName();
    private TableViewer viewer;
    private TableColumnLayout tableColumnLayout;
    private Clipboard clipboard;
    private int serverId;
    private int objHash;
    ProcessObject[] procList;
    boolean ctrlPressed = false;

    public void createPartControl(Composite parent) {
        this.initialLayout(parent);
        this.clipboard = new Clipboard(null);
    }

    private void initialLayout(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComposite.setLayout((Layout)new GridLayout(1, true));
        this.createTableViewer(tableComposite);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                TopView.this.load();
            }
        });
    }

    public void setInput(int serverId, int objHash) {
        this.serverId = serverId;
        this.objHash = objHash;
        this.setPartName("Top[" + TextProxy.object.getText(objHash) + "]");
        this.load();
    }

    private void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                TcpProxy tcpProxy = TcpProxy.getTcpProxy(TopView.this.serverId);
                try {
                    MapPack param = new MapPack();
                    param.put("objHash", (long)TopView.this.objHash);
                    MapPack pack = (MapPack)tcpProxy.getSingle("HOST_TOP", (Pack)param);
                    if (pack == null) {
                        return;
                    }
                    try {
                        String error = pack.getText("error");
                        if (error != null) {
                            ConsoleProxy.errorSafe(error);
                        }
                        ListValue pidLv = pack.getList("PID");
                        ListValue userLv = pack.getList("USER");
                        ListValue cpuLv = pack.getList("CPU");
                        ListValue memLv = pack.getList("MEM");
                        ListValue timeLv = pack.getList("TIME");
                        ListValue nameLv = pack.getList("NAME");
                        TopView.this.procList = new ProcessObject[pidLv.size()];
                        int i = 0;
                        while (i < pidLv.size()) {
                            TopView.this.procList[i] = new ProcessObject();
                            TopView.this.procList[i].pid = (int)pidLv.getLong(i);
                            TopView.this.procList[i].user = userLv.getString(i);
                            TopView.this.procList[i].cpu = (float)cpuLv.getDouble(i);
                            TopView.this.procList[i].mem = memLv.getLong(i);
                            TopView.this.procList[i].time = timeLv.getLong(i);
                            TopView.this.procList[i].name = nameLv.getString(i);
                            ++i;
                        }
                        ExUtil.exec((Composite)TopView.this.viewer.getTable(), new Runnable(){

                            @Override
                            public void run() {
                                (this).TopView.this.viewer.setInput((Object)(this).TopView.this.procList);
                            }
                        });
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                    }
                }
                finally {
                    TcpProxy.putTcpProxy(tcpProxy);
                }
            }
        });
    }

    private void createTableViewer(Composite composite) {
        this.viewer = new TableViewer(composite, 67586);
        this.tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)this.tableColumnLayout);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableContextMenu();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.viewer).setCustomCompare(new ColumnLabelSorter.ICustomCompare(){

            @Override
            public int doCompare(TableColumn col, int index, Object o1, Object o2) {
                if (!(o1 instanceof ProcessObject) || !(o2 instanceof ProcessObject)) {
                    return 0;
                }
                ProcessObject p1 = (ProcessObject)o1;
                ProcessObject p2 = (ProcessObject)o2;
                Boolean isNumber = (Boolean)col.getData("isNumber");
                if (isNumber != null && isNumber.booleanValue()) {
                    long i2;
                    String v1 = ColumnLabelSorter.numonly(p1.getValueByIndex(index));
                    String v2 = ColumnLabelSorter.numonly(p2.getValueByIndex(index));
                    if (v1 == null) {
                        v1 = "0";
                    }
                    if (v2 == null) {
                        v2 = "0";
                    }
                    if (v1.contains(".") || v2.contains(".")) {
                        double d2;
                        double d1 = Double.valueOf(v1);
                        if (d1 > (d2 = Double.valueOf(v2).doubleValue())) {
                            return 1;
                        }
                        if (d2 > d1) {
                            return -1;
                        }
                        return 0;
                    }
                    long i1 = Long.valueOf(v1);
                    if (i1 > (i2 = Long.valueOf(v2).longValue())) {
                        return 1;
                    }
                    if (i2 > i1) {
                        return -1;
                    }
                    return 0;
                }
                String v1 = p1.getValueByIndex(index);
                String v2 = p2.getValueByIndex(index);
                if (v1 == null) {
                    v1 = "";
                }
                if (v2 == null) {
                    v2 = "";
                }
                return v1.compareTo(v2);
            }
        }));
        GridData gridData = new GridData(4, 4, true, true);
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void createTableContextMenu() {
        MenuManager manager = new MenuManager();
        this.viewer.getControl().setMenu(manager.createContextMenu(this.viewer.getControl()));
        manager.add((IAction)new Action("&Copy", ImageDescriptor.createFromImage((Image)Images.copy)){

            public void run() {
                TopView.this.selectionCopyToClipboard();
            }
        });
        this.viewer.getTable().addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 262144) {
                    TopView.this.ctrlPressed = true;
                } else if ((e.keyCode == 99 || e.keyCode == 67) && TopView.this.ctrlPressed) {
                    TopView.this.selectionCopyToClipboard();
                }
            }
        });
        this.viewer.getTable().addListener(2, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 262144) {
                    TopView.this.ctrlPressed = false;
                }
            }
        });
    }

    private void selectionCopyToClipboard() {
        TableItem[] items;
        if (this.viewer != null && (items = this.viewer.getTable().getSelection()) != null && items.length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                ProcessObject data = (ProcessObject)items[i].getData();
                sb.append(data.toString());
                ++i;
            }
            this.clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private void createColumns() {
        ColumnEnum[] columnEnumArray = ColumnEnum.values();
        int n = columnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnEnum column = columnEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case PID: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ProcessObject) {
                                return String.valueOf(((ProcessObject)element).pid);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case USER: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ProcessObject) {
                                return ((ProcessObject)element).user;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case CPU: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ProcessObject) {
                                return String.valueOf(FormatUtil.print((Object)Float.valueOf(((ProcessObject)element).cpu), (String)"#,##0.0")) + "%";
                            }
                            return null;
                        }
                    };
                    break;
                }
                case MEM: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ProcessObject) {
                                return FormatUtil.printMem((double)((ProcessObject)element).mem);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case TIME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ProcessObject) {
                                return DateUtil.format((long)((ProcessObject)element).time, (String)"mm:ss.SSS");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case NAME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ProcessObject) {
                                return ((ProcessObject)element).name;
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        final TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(30, width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)TopView.this.viewer.getComparator();
                sorter.setColumn(column);
            }
        });
        return viewerColumn;
    }

    public void setFocus() {
    }

    public static enum ColumnEnum {
        PID("PID", 50, 131072, true, true, true),
        USER("USER", 70, 131072, true, true, false),
        CPU("CPU%", 50, 131072, true, true, true),
        MEM("MEM", 50, 131072, true, true, true),
        TIME("TIME", 100, 131072, true, true, true),
        NAME("NAME", 150, 16384, true, true, false);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private ColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }

    class ProcessObject {
        int pid;
        String user;
        float cpu;
        long mem;
        long time;
        String name;

        ProcessObject() {
        }

        public String getValueByIndex(int index) {
            switch (index) {
                case 0: {
                    return String.valueOf(this.pid);
                }
                case 1: {
                    return this.user;
                }
                case 2: {
                    return String.valueOf(this.cpu);
                }
                case 3: {
                    return String.valueOf(this.mem);
                }
                case 4: {
                    return String.valueOf(this.time);
                }
                case 5: {
                    return this.name;
                }
            }
            return null;
        }

        public String toString() {
            return String.valueOf(this.pid) + "\t" + this.user + "\t" + this.cpu + "\t" + this.mem + "\t" + DateUtil.format((long)this.time, (String)"mm:ss.SSS") + "\t" + this.name + "\n";
        }
    }
}

