/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.maria.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.maria.views.DbDailyTotalConnView;
import scouter.client.popup.CalendarDialog;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ImageUtil;
import scouter.util.DateUtil;

public class OpenDbDailyConnView
extends Action {
    private final int serverId;
    String date;

    public OpenDbDailyConnView(int serverId) {
        this(serverId, null);
    }

    public OpenDbDailyConnView(int serverId, String date) {
        this.serverId = serverId;
        this.setText("Open Daily Connection");
        this.setImageDescriptor(ImageUtil.getImageDescriptor(Images.calendar));
    }

    public void run() {
        try {
            CalendarDialog dialog = new CalendarDialog(Display.getDefault(), new CalendarDialog.ILoadCalendarDialog(){

                @Override
                public void onPressedOk(long startTime, long endTime) {
                }

                @Override
                public void onPressedOk(String date) {
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(DbDailyTotalConnView.ID, String.valueOf(OpenDbDailyConnView.this.serverId) + "&" + date, 1);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onPressedCancel() {
                }
            });
            if (this.date == null) {
                dialog.show();
            } else {
                dialog.show(-1, -1, DateUtil.yyyymmdd((String)this.date));
            }
        }
        catch (Exception e) {
            ConsoleProxy.errorSafe(e.toString());
        }
    }
}

