/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.maria.views;

import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.maria.actions.OpenDbDailyConnView;
import scouter.client.maria.actions.OpenDigestTableAction;
import scouter.client.model.AgentDailyListProxy;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ScouterUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

public class DbDailyTotalConnView
extends ViewPart {
    public static final String ID = DbDailyTotalConnView.class.getName();
    int serverId;
    static long TIME_RANGE = 86400000L;
    static int REFRESH_INTERVAL = 10000;
    static int BUFFER_SIZE = (int)(TIME_RANGE / 300000L);
    FigureCanvas canvas;
    XYGraph xyGraph;
    Trace totalTrace;
    Trace activeTrace;
    String date;
    AgentDailyListProxy agentDailyProxy = new AgentDailyListProxy();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.date = ids[1];
    }

    public void createPartControl(Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        this.setPartName("Connections[" + server.getName() + "][" + this.date + "]");
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                Rectangle r = DbDailyTotalConnView.this.canvas.getClientArea();
                DbDailyTotalConnView.this.xyGraph.setSize(r.width, r.height);
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(true);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setFormatPattern("HH:mm:ss");
        this.xyGraph.primaryYAxis.setFormatPattern("#,##0");
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        final CircularBufferDataProvider totalProvider = new CircularBufferDataProvider(true);
        totalProvider.setBufferSize(BUFFER_SIZE);
        totalProvider.setCurrentXDataArray(new double[0]);
        totalProvider.setCurrentYDataArray(new double[0]);
        this.totalTrace = new Trace("Total (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, totalProvider);
        this.totalTrace.setPointStyle(Trace.PointStyle.NONE);
        this.totalTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.totalTrace.setTraceType(Trace.TraceType.SOLID_LINE);
        this.totalTrace.setTraceColor(ColorUtil.getInstance().getColor(4));
        this.xyGraph.addTrace(this.totalTrace);
        CircularBufferDataProvider activeProvider = new CircularBufferDataProvider(true);
        activeProvider.setBufferSize(BUFFER_SIZE);
        activeProvider.setCurrentXDataArray(new double[0]);
        activeProvider.setCurrentYDataArray(new double[0]);
        this.activeTrace = new Trace("Running (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, activeProvider);
        this.activeTrace.setPointStyle(Trace.PointStyle.NONE);
        this.activeTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.activeTrace.setTraceType(Trace.TraceType.SOLID_LINE);
        this.activeTrace.setTraceColor(ColorUtil.getInstance().getColor(6));
        this.xyGraph.addTrace(this.activeTrace);
        ScouterUtil.addHorizontalRangeListener(this.xyGraph.getPlotArea(), new OpenDigestTableAction(this.serverId), true);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new OpenDbDailyConnView(this.serverId, this.date));
        man.add((IAction)new Action("Zoom out", ImageUtil.getImageDescriptor(Images.zoomout)){

            public void run() {
                long stime = DateUtil.yyyymmdd((String)DbDailyTotalConnView.this.date);
                long etime = stime + 86400000L - 1L;
                DbDailyTotalConnView.this.xyGraph.primaryXAxis.setRange(stime, etime);
                double max = ChartUtil.getMax(totalProvider.iterator());
                DbDailyTotalConnView.this.xyGraph.primaryYAxis.setRange(0.0, max);
            }
        });
        this.load();
    }

    public void setFocus() {
    }

    public void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                Pack p;
                block7: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(DbDailyTotalConnView.this.serverId);
                    p = null;
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objHash", (Value)DbDailyTotalConnView.this.agentDailyProxy.getObjHashLv(DbDailyTotalConnView.this.date, DbDailyTotalConnView.this.serverId, "mariaplugin"));
                            param.put("sdate", DbDailyTotalConnView.this.date);
                            param.put("edate", DbDailyTotalConnView.this.date);
                            p = tcp.getSingle("DB_DAILY_CONNECTIONS", (Pack)param);
                        }
                        catch (Exception e) {
                            ConsoleProxy.errorSafe(e.toString());
                            TcpProxy.putTcpProxy(tcp);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (p == null) {
                    ExUtil.exec((Composite)DbDailyTotalConnView.this.canvas, new Runnable(){

                        @Override
                        public void run() {
                            DbDailyTotalConnView.this.setTitleImage(Images.inactive);
                            DbDailyTotalConnView.this.setContentDescription(String.valueOf((this).DbDailyTotalConnView.this.date.substring(0, 4)) + "-" + (this).DbDailyTotalConnView.this.date.substring(5, 6) + "-" + (this).DbDailyTotalConnView.this.date.substring(7, 8));
                            long stime = DateUtil.yyyymmdd((String)(this).DbDailyTotalConnView.this.date);
                            long etime = stime + 86400000L - 1L;
                            (this).DbDailyTotalConnView.this.xyGraph.primaryXAxis.setRange(stime, etime);
                        }
                    });
                } else {
                    MapPack m = (MapPack)p;
                    final ListValue timeLv = m.getList("time");
                    final ListValue totalLv = m.getList("total");
                    final ListValue activeLv = m.getList("active");
                    ExUtil.exec((Composite)DbDailyTotalConnView.this.canvas, new Runnable(){

                        @Override
                        public void run() {
                            DbDailyTotalConnView.this.setTitleImage(Images.active);
                            CircularBufferDataProvider totalProvider = (CircularBufferDataProvider)(this).DbDailyTotalConnView.this.totalTrace.getDataProvider();
                            CircularBufferDataProvider activeProvider = (CircularBufferDataProvider)(this).DbDailyTotalConnView.this.activeTrace.getDataProvider();
                            totalProvider.clearTrace();
                            activeProvider.clearTrace();
                            int i = 0;
                            while (i < timeLv.size()) {
                                long time = timeLv.getLong(i);
                                double totalV = totalLv.getDouble(i);
                                double activeV = activeLv.getDouble(i);
                                totalProvider.addSample(new Sample(time, totalV));
                                activeProvider.addSample(new Sample(time, activeV));
                                ++i;
                            }
                            DbDailyTotalConnView.this.setContentDescription(String.valueOf((this).DbDailyTotalConnView.this.date.substring(0, 4)) + "-" + (this).DbDailyTotalConnView.this.date.substring(4, 6) + "-" + (this).DbDailyTotalConnView.this.date.substring(6, 8));
                            long stime = DateUtil.yyyymmdd((String)(this).DbDailyTotalConnView.this.date);
                            long etime = stime + 86400000L - 1L;
                            (this).DbDailyTotalConnView.this.xyGraph.primaryXAxis.setRange(stime, etime);
                            double max = ChartUtil.getMax(totalProvider.iterator());
                            (this).DbDailyTotalConnView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                        }
                    });
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
    }
}

