/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.maria.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.StatusPack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

public class DbLockListView
extends ViewPart {
    public static final String ID = DbLockListView.class.getName();
    private TreeViewer viewer;
    private Tree tree;
    private TreeColumnLayout columnLayout;
    private long time;
    private int serverId;
    private int objHash;
    Map<Long, LockObject> root = new HashMap<Long, LockObject>();
    ArrayList<LockTableSchema> columnList = new ArrayList();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objHash = CastUtil.cint((Object)ids[1]);
    }

    public void createPartControl(Composite parent) {
        this.setPartName("Lock List[" + TextProxy.object.getText(this.objHash) + "]");
        this.columnLayout = new TreeColumnLayout();
        parent.setLayout((Layout)this.columnLayout);
        this.tree = new Tree(parent, 68352);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.viewer = new TreeViewer(this.tree);
        this.createColumns();
        this.viewer.setContentProvider((IContentProvider)new LockContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LockLabelProvider());
        this.viewer.setInput(this.root);
    }

    public void setInput(long time) {
        this.time = time;
        this.load();
    }

    private void load() {
        this.root.clear();
        this.tree.removeAll();
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                Pack p;
                block8: {
                    TcpProxy tcpProxy = TcpProxy.getTcpProxy(DbLockListView.this.serverId);
                    p = null;
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("key", "lock_info");
                            param.put("objHash", (long)DbLockListView.this.objHash);
                            param.put("time", DbLockListView.this.time);
                            p = tcpProxy.getSingle("STATUS_AROUND_VALUE", (Pack)param);
                        }
                        catch (Throwable th) {
                            th.printStackTrace();
                            TcpProxy.putTcpProxy(tcpProxy);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcpProxy);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcpProxy);
                }
                if (p != null) {
                    String date = DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(DbLockListView.this.serverId));
                    StatusPack sp = (StatusPack)p;
                    ListValue waitStartedLv = sp.data.getList("WAIT_STARTED");
                    ListValue waitingPidLv = sp.data.getList("WAITING_PID");
                    ListValue lockedTableLv = sp.data.getList("LOCKED_TABLE");
                    ListValue lockedIndexLv = sp.data.getList("LOCKED_INDEX");
                    ListValue lockedTypeLv = sp.data.getList("LOCKED_TYPE");
                    ListValue blockingPidLv = sp.data.getList("BLOCKING_PID");
                    ListValue waitingQueryLv = sp.data.getList("WAITING_QUERY");
                    ListValue waitingLockModeLv = sp.data.getList("WAITING_LOCK_MODE");
                    ListValue blockingQueryLv = sp.data.getList("BLOCKING_QUERY");
                    ListValue blockingTrxStartedLv = sp.data.getList("BLOCKING_TRX_STARTED");
                    ListValue blockingLockModeLv = sp.data.getList("BLOCKING_LOCK_MODE");
                    int i = 0;
                    while (i < waitStartedLv.size()) {
                        long blockPid = blockingPidLv.getLong(i);
                        LockObject blockObject = DbLockListView.this.root.get(blockPid);
                        if (blockObject == null) {
                            blockObject = new LockObject(blockPid);
                            blockObject.startTime = blockingTrxStartedLv.getLong(i);
                            blockObject.sql = TextProxy.maria.getLoadText(date, blockingQueryLv.getInt(i), DbLockListView.this.serverId);
                            blockObject.type = lockedTypeLv.getString(i);
                            blockObject.waitingLockMode = waitingLockModeLv.getString(i);
                            blockObject.blockingLockMode = blockingLockModeLv.getString(i);
                            blockObject.index = lockedIndexLv.getString(i);
                            blockObject.table = lockedTableLv.getString(i);
                            DbLockListView.this.root.put(blockPid, blockObject);
                        }
                        long waitPid = waitingPidLv.getLong(i);
                        LockObject waitObject = new LockObject(waitPid);
                        waitObject.startTime = waitStartedLv.getLong(i);
                        waitObject.sql = TextProxy.maria.getLoadText(date, waitingQueryLv.getInt(i), DbLockListView.this.serverId);
                        waitObject.type = lockedTypeLv.getString(i);
                        waitObject.waitingLockMode = waitingLockModeLv.getString(i);
                        waitObject.blockingLockMode = blockingLockModeLv.getString(i);
                        waitObject.index = lockedIndexLv.getString(i);
                        waitObject.table = lockedTableLv.getString(i);
                        waitObject.parent = blockObject;
                        blockObject.addChild(waitObject);
                        ++i;
                    }
                }
                ExUtil.exec((Composite)DbLockListView.this.tree, new Runnable(){

                    @Override
                    public void run() {
                        (this).DbLockListView.this.viewer.refresh();
                        (this).DbLockListView.this.viewer.expandAll();
                    }
                });
            }
        });
    }

    public void setFocus() {
    }

    private void createColumns() {
        this.columnList.clear();
        LockTableSchema[] lockTableSchemaArray = LockTableSchema.values();
        int n = lockTableSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            LockTableSchema column = lockTableSchemaArray[n2];
            this.createTreeViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), true, true, column.isNumber());
            this.columnList.add(column);
            ++n2;
        }
    }

    private TreeViewerColumn createTreeViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.viewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.columnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(width, resizable));
        return viewerColumn;
    }

    class LockContentProvider
    implements ITreeContentProvider {
        LockContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).values().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof LockObject && ((LockObject)parentElement).childList != null) {
                return ((LockObject)parentElement).childList.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof LockObject) {
                return ((LockObject)element).parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof LockObject) {
                return ((LockObject)element).childList != null;
            }
            return false;
        }
    }

    class LockLabelProvider
    implements ITableLabelProvider {
        LockLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof LockObject) {
                LockObject model = (LockObject)element;
                LockTableSchema column = DbLockListView.this.columnList.get(columnIndex);
                switch (column) {
                    case PID: {
                        return CastUtil.cString((Object)model.pid);
                    }
                    case START: {
                        return DateUtil.format((long)model.startTime, (String)"HH:mm:ss");
                    }
                    case SQL: {
                        return model.sql;
                    }
                    case TYPE: {
                        return model.type;
                    }
                    case MODE: {
                        if (model.parent == null) {
                            return model.blockingLockMode;
                        }
                        return model.waitingLockMode;
                    }
                    case INDEX: {
                        return model.index;
                    }
                    case TABLE: {
                        return model.table;
                    }
                }
            }
            return null;
        }
    }

    static class LockObject {
        long pid;
        long startTime;
        String sql;
        String type;
        String waitingLockMode;
        String blockingLockMode;
        String index;
        String table;
        LockObject parent;
        List<LockObject> childList;

        LockObject(long id) {
            this.pid = id;
        }

        public void addChild(LockObject child) {
            if (this.childList == null) {
                this.childList = new ArrayList<LockObject>();
            }
            this.childList.add(child);
        }
    }

    static enum LockTableSchema {
        PID("PID", 100, 16384, true),
        START("Start", 100, 0x1000000, false),
        SQL("SQL", 200, 16384, false),
        TYPE("Type", 100, 16384, false),
        MODE("Mode", 100, 16384, false),
        INDEX("Index", 100, 16384, true),
        TABLE("Table", 100, 16384, false);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean isNumber;

        private LockTableSchema(String text, int width, int alignment, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }
}

