/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.maria.views;

import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.listeners.RangeMouseListener;
import scouter.client.maria.actions.OpenDigestTableAction;
import scouter.client.maria.views.DbTodayTotalActivityView;
import scouter.client.model.AgentModelThread;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.LinkedList;

public class DbRealtimeTotalActivityView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = DbRealtimeTotalActivityView.class.getName();
    int serverId;
    RefreshThread thread;
    static long TIME_RANGE = 300000L;
    static int REFRESH_INTERVAL = 2000;
    static int BUFFER_SIZE = (int)(TIME_RANGE / (long)REFRESH_INTERVAL) + 1;
    FigureCanvas canvas;
    XYGraph xyGraph;
    Trace callTrace;
    Trace selectTrace;
    Trace insertTrace;
    Trace updateTrace;
    Trace deleteTrace;
    boolean isStackView = true;
    LinkedList<ValueLog> valueLogs = new LinkedList();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        this.serverId = CastUtil.cint((Object)secId);
    }

    public void createPartControl(Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        this.setPartName("DB Activity[" + server.getName() + "]");
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                Rectangle r = DbRealtimeTotalActivityView.this.canvas.getClientArea();
                DbRealtimeTotalActivityView.this.xyGraph.setSize(r.width, r.height);
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(true);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setFormatPattern("HH:mm:ss");
        this.xyGraph.primaryYAxis.setFormatPattern("#,##0");
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.primaryYAxis.addMouseListener((MouseListener)new RangeMouseListener(this.getViewSite().getShell(), this.xyGraph.primaryYAxis));
        CircularBufferDataProvider callProvider = new CircularBufferDataProvider(true);
        callProvider.setBufferSize(BUFFER_SIZE);
        callProvider.setCurrentXDataArray(new double[0]);
        callProvider.setCurrentYDataArray(new double[0]);
        this.callTrace = new Trace("Call (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, callProvider);
        this.callTrace.setPointStyle(Trace.PointStyle.NONE);
        this.callTrace.setTraceType(Trace.TraceType.AREA);
        this.callTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.callTrace.setAreaAlpha(255);
        this.callTrace.setTraceColor(ColorUtil.getInstance().getColor(10));
        this.xyGraph.addTrace(this.callTrace);
        CircularBufferDataProvider selectProvider = new CircularBufferDataProvider(true);
        selectProvider.setBufferSize(BUFFER_SIZE);
        selectProvider.setCurrentXDataArray(new double[0]);
        selectProvider.setCurrentYDataArray(new double[0]);
        this.selectTrace = new Trace("Select (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, selectProvider);
        this.selectTrace.setPointStyle(Trace.PointStyle.NONE);
        this.selectTrace.setTraceType(Trace.TraceType.AREA);
        this.selectTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.selectTrace.setAreaAlpha(255);
        this.selectTrace.setTraceColor(ColorUtil.getInstance().getColor(14));
        this.xyGraph.addTrace(this.selectTrace);
        CircularBufferDataProvider insertProvider = new CircularBufferDataProvider(true);
        insertProvider.setBufferSize(BUFFER_SIZE);
        insertProvider.setCurrentXDataArray(new double[0]);
        insertProvider.setCurrentYDataArray(new double[0]);
        this.insertTrace = new Trace("Insert (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, insertProvider);
        this.insertTrace.setPointStyle(Trace.PointStyle.NONE);
        this.insertTrace.setTraceType(Trace.TraceType.AREA);
        this.insertTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.insertTrace.setAreaAlpha(255);
        this.insertTrace.setTraceColor(ColorUtil.getInstance().getColor(16));
        this.xyGraph.addTrace(this.insertTrace);
        CircularBufferDataProvider updateProvider = new CircularBufferDataProvider(true);
        updateProvider.setBufferSize(BUFFER_SIZE);
        updateProvider.setCurrentXDataArray(new double[0]);
        updateProvider.setCurrentYDataArray(new double[0]);
        this.updateTrace = new Trace("Update (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, updateProvider);
        this.updateTrace.setPointStyle(Trace.PointStyle.NONE);
        this.updateTrace.setTraceType(Trace.TraceType.AREA);
        this.updateTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.updateTrace.setAreaAlpha(255);
        this.updateTrace.setTraceColor(ColorUtil.getInstance().getColor(6));
        this.xyGraph.addTrace(this.updateTrace);
        CircularBufferDataProvider deleteProvider = new CircularBufferDataProvider(true);
        deleteProvider.setBufferSize(BUFFER_SIZE);
        deleteProvider.setCurrentXDataArray(new double[0]);
        deleteProvider.setCurrentYDataArray(new double[0]);
        this.deleteTrace = new Trace("Delete (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, deleteProvider);
        this.deleteTrace.setPointStyle(Trace.PointStyle.NONE);
        this.deleteTrace.setTraceType(Trace.TraceType.AREA);
        this.deleteTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.deleteTrace.setAreaAlpha(255);
        this.deleteTrace.setTraceColor(ColorUtil.getInstance().getColor(12));
        this.xyGraph.addTrace(this.deleteTrace);
        ScouterUtil.addHorizontalRangeListener(this.xyGraph.getPlotArea(), new OpenDigestTableAction(this.serverId), false);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        Action stackViewAct = new Action("Area Mode", 2){

            public void run() {
                DbRealtimeTotalActivityView.this.isStackView = this.isChecked();
                DbRealtimeTotalActivityView.this.changeMode();
            }
        };
        stackViewAct.setImageDescriptor(ImageUtil.getImageDescriptor(Images.sum));
        stackViewAct.setChecked(true);
        man.add((IAction)stackViewAct);
        Action openDailyView = new Action("Open Daily View", ImageUtil.getImageDescriptor(Images.calendar)){

            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(DbTodayTotalActivityView.ID, "" + DbRealtimeTotalActivityView.this.serverId, 1);
                }
                catch (PartInitException e) {
                    ConsoleProxy.errorSafe(e.toString());
                }
            }
        };
        man.add((IAction)openDailyView);
        this.thread = new RefreshThread(this, REFRESH_INTERVAL);
        this.thread.start();
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    @Override
    public void refresh() {
        Value v;
        block8: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            v = null;
            try {
                try {
                    MapPack param = new MapPack();
                    ListValue objHashLv = AgentModelThread.getInstance().getLiveObjHashLV(this.serverId, "mariaplugin");
                    if (objHashLv.size() > 0) {
                        param.put("objHash", (Value)objHashLv);
                        v = tcp.getSingleValue("DB_REALTIME_ACTIVITY", (Pack)param);
                    }
                }
                catch (Exception e) {
                    ConsoleProxy.errorSafe(e.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (v == null) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    DbRealtimeTotalActivityView.this.setTitleImage(Images.inactive);
                    long now = TimeUtil.getCurrentTime(DbRealtimeTotalActivityView.this.serverId);
                    long stime = now - TIME_RANGE;
                    DbRealtimeTotalActivityView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                }
            });
        } else {
            MapValue mv = (MapValue)v;
            final DecimalValue callValue = new DecimalValue(mv.getLong("call"));
            final DecimalValue selectValue = new DecimalValue(mv.getLong("select"));
            final DecimalValue insertValue = new DecimalValue(mv.getLong("insert"));
            final DecimalValue updateValue = new DecimalValue(mv.getLong("update"));
            final DecimalValue deleteValue = new DecimalValue(mv.getLong("delete"));
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    DbRealtimeTotalActivityView.this.setTitleImage(Images.active);
                    long now = TimeUtil.getCurrentTime(DbRealtimeTotalActivityView.this.serverId) / (long)REFRESH_INTERVAL * (long)REFRESH_INTERVAL;
                    long stime = now - TIME_RANGE;
                    DbRealtimeTotalActivityView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                    ValueLog valueLog = new ValueLog();
                    valueLog.time = now;
                    valueLog.delete = deleteValue.value;
                    valueLog.update = updateValue.value;
                    valueLog.insert = insertValue.value;
                    valueLog.select = selectValue.value;
                    valueLog.call = callValue.value;
                    DbRealtimeTotalActivityView.this.valueLogs.add((Object)valueLog);
                    if (DbRealtimeTotalActivityView.this.valueLogs.size() > BUFFER_SIZE) {
                        DbRealtimeTotalActivityView.this.valueLogs.removeFirst();
                    }
                    if (DbRealtimeTotalActivityView.this.isStackView) {
                        updateValue.value += deleteValue.value;
                        insertValue.value += updateValue.value;
                        selectValue.value += insertValue.value;
                        callValue.value += selectValue.value;
                    }
                    ((CircularBufferDataProvider)DbRealtimeTotalActivityView.this.callTrace.getDataProvider()).addSample(new Sample(now, callValue.value));
                    ((CircularBufferDataProvider)DbRealtimeTotalActivityView.this.selectTrace.getDataProvider()).addSample(new Sample(now, selectValue.value));
                    ((CircularBufferDataProvider)DbRealtimeTotalActivityView.this.insertTrace.getDataProvider()).addSample(new Sample(now, insertValue.value));
                    ((CircularBufferDataProvider)DbRealtimeTotalActivityView.this.updateTrace.getDataProvider()).addSample(new Sample(now, updateValue.value));
                    ((CircularBufferDataProvider)DbRealtimeTotalActivityView.this.deleteTrace.getDataProvider()).addSample(new Sample(now, deleteValue.value));
                    DbRealtimeTotalActivityView.this.xyGraph.primaryYAxis.setRange(0.0, this.getMaxYValue());
                }

                private double getMaxYValue() {
                    if (DbRealtimeTotalActivityView.this.isStackView) {
                        return ChartUtil.getMax(((CircularBufferDataProvider)DbRealtimeTotalActivityView.this.callTrace.getDataProvider()).iterator());
                    }
                    double value = ChartUtil.getMax(((CircularBufferDataProvider)DbRealtimeTotalActivityView.this.callTrace.getDataProvider()).iterator());
                    value = Math.max(value, ChartUtil.getMax(((CircularBufferDataProvider)DbRealtimeTotalActivityView.this.selectTrace.getDataProvider()).iterator()));
                    value = Math.max(value, ChartUtil.getMax(((CircularBufferDataProvider)DbRealtimeTotalActivityView.this.insertTrace.getDataProvider()).iterator()));
                    value = Math.max(value, ChartUtil.getMax(((CircularBufferDataProvider)DbRealtimeTotalActivityView.this.updateTrace.getDataProvider()).iterator()));
                    value = Math.max(value, ChartUtil.getMax(((CircularBufferDataProvider)DbRealtimeTotalActivityView.this.deleteTrace.getDataProvider()).iterator()));
                    return value;
                }
            });
        }
    }

    protected void changeMode() {
        CircularBufferDataProvider delProvider = (CircularBufferDataProvider)this.deleteTrace.getDataProvider();
        CircularBufferDataProvider upProvider = (CircularBufferDataProvider)this.updateTrace.getDataProvider();
        CircularBufferDataProvider inProvider = (CircularBufferDataProvider)this.insertTrace.getDataProvider();
        CircularBufferDataProvider selProvider = (CircularBufferDataProvider)this.selectTrace.getDataProvider();
        CircularBufferDataProvider callProvider = (CircularBufferDataProvider)this.callTrace.getDataProvider();
        delProvider.clearTrace();
        upProvider.clearTrace();
        inProvider.clearTrace();
        selProvider.clearTrace();
        callProvider.clearTrace();
        int size = this.valueLogs.size();
        if (size > 0) {
            LinkedList.ENTRY entry = this.valueLogs.getFirst();
            if (this.isStackView) {
                do {
                    ValueLog log = (ValueLog)entry.item;
                    double x = log.time;
                    double delValue = log.delete;
                    double upValue = delValue + log.update;
                    double inValue = upValue + log.insert;
                    double selValue = inValue + log.select;
                    double callValue = selValue + log.call;
                    callProvider.addSample(new Sample(x, callValue));
                    selProvider.addSample(new Sample(x, selValue));
                    inProvider.addSample(new Sample(x, inValue));
                    upProvider.addSample(new Sample(x, upValue));
                    delProvider.addSample(new Sample(x, delValue));
                } while ((entry = entry.next) != null);
            } else {
                do {
                    ValueLog log = (ValueLog)entry.item;
                    double x = log.time;
                    double delValue = log.delete;
                    double upValue = log.update;
                    double inValue = log.insert;
                    double selValue = log.select;
                    double callValue = log.call;
                    callProvider.addSample(new Sample(x, callValue));
                    selProvider.addSample(new Sample(x, selValue));
                    inProvider.addSample(new Sample(x, inValue));
                    upProvider.addSample(new Sample(x, upValue));
                    delProvider.addSample(new Sample(x, delValue));
                } while ((entry = entry.next) != null);
            }
        }
        if (this.isStackView) {
            this.deleteTrace.setTraceType(Trace.TraceType.AREA);
            this.updateTrace.setTraceType(Trace.TraceType.AREA);
            this.insertTrace.setTraceType(Trace.TraceType.AREA);
            this.selectTrace.setTraceType(Trace.TraceType.AREA);
            this.callTrace.setTraceType(Trace.TraceType.AREA);
        } else {
            this.deleteTrace.setTraceType(Trace.TraceType.SOLID_LINE);
            this.updateTrace.setTraceType(Trace.TraceType.SOLID_LINE);
            this.insertTrace.setTraceType(Trace.TraceType.SOLID_LINE);
            this.selectTrace.setTraceType(Trace.TraceType.SOLID_LINE);
            this.callTrace.setTraceType(Trace.TraceType.SOLID_LINE);
        }
    }

    private static class ValueLog {
        long time;
        double delete;
        double update;
        double insert;
        double select;
        double call;

        private ValueLog() {
        }
    }
}

