/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.maria.views;

import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.maria.actions.OpenDigestTableAction;
import scouter.client.maria.views.DbTodayTotalConnView;
import scouter.client.model.AgentModelThread;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;

public class DbRealtimeTotalConnView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = DbRealtimeTotalConnView.class.getName();
    int serverId;
    RefreshThread thread;
    static long TIME_RANGE = 300000L;
    static int REFRESH_INTERVAL = 2000;
    FigureCanvas canvas;
    XYGraph xyGraph;
    Trace totalTrace;
    Trace activeTrace;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        this.serverId = CastUtil.cint((Object)secId);
    }

    public void createPartControl(Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        this.setPartName("Connections[" + server.getName() + "]");
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                Rectangle r = DbRealtimeTotalConnView.this.canvas.getClientArea();
                DbRealtimeTotalConnView.this.xyGraph.setSize(r.width, r.height);
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(true);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setFormatPattern("HH:mm:ss");
        this.xyGraph.primaryYAxis.setFormatPattern("#,##0");
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        CircularBufferDataProvider totalProvider = new CircularBufferDataProvider(true);
        totalProvider.setBufferSize((int)(TIME_RANGE / (long)REFRESH_INTERVAL) + 1);
        totalProvider.setCurrentXDataArray(new double[0]);
        totalProvider.setCurrentYDataArray(new double[0]);
        this.totalTrace = new Trace("Total (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, totalProvider);
        this.totalTrace.setPointStyle(Trace.PointStyle.NONE);
        this.totalTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.totalTrace.setTraceType(Trace.TraceType.SOLID_LINE);
        this.totalTrace.setTraceColor(ColorUtil.getInstance().getColor(4));
        this.xyGraph.addTrace(this.totalTrace);
        CircularBufferDataProvider activeProvider = new CircularBufferDataProvider(true);
        activeProvider.setBufferSize((int)(TIME_RANGE / (long)REFRESH_INTERVAL) + 1);
        activeProvider.setCurrentXDataArray(new double[0]);
        activeProvider.setCurrentYDataArray(new double[0]);
        this.activeTrace = new Trace("Running (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, activeProvider);
        this.activeTrace.setPointStyle(Trace.PointStyle.NONE);
        this.activeTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.activeTrace.setTraceType(Trace.TraceType.SOLID_LINE);
        this.activeTrace.setTraceColor(ColorUtil.getInstance().getColor(6));
        this.xyGraph.addTrace(this.activeTrace);
        ScouterUtil.addHorizontalRangeListener(this.xyGraph.getPlotArea(), new OpenDigestTableAction(this.serverId), false);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        Action openDailyView = new Action("Open Daily View", ImageUtil.getImageDescriptor(Images.calendar)){

            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(DbTodayTotalConnView.ID, "" + DbRealtimeTotalConnView.this.serverId, 1);
                }
                catch (PartInitException e) {
                    ConsoleProxy.errorSafe(e.toString());
                }
            }
        };
        man.add((IAction)openDailyView);
        this.thread = new RefreshThread(this, REFRESH_INTERVAL);
        this.thread.start();
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    @Override
    public void refresh() {
        Value v;
        block8: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            v = null;
            try {
                try {
                    MapPack param = new MapPack();
                    ListValue objHashLv = AgentModelThread.getInstance().getLiveObjHashLV(this.serverId, "mariaplugin");
                    if (objHashLv.size() > 0) {
                        param.put("objHash", (Value)objHashLv);
                        v = tcp.getSingleValue("DB_REALTIME_CONNECTIONS", (Pack)param);
                    }
                }
                catch (Exception e) {
                    ConsoleProxy.errorSafe(e.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (v == null) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    DbRealtimeTotalConnView.this.setTitleImage(Images.inactive);
                    long now = TimeUtil.getCurrentTime(DbRealtimeTotalConnView.this.serverId);
                    long stime = now - TIME_RANGE;
                    DbRealtimeTotalConnView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                }
            });
        } else {
            MapValue value = (MapValue)v;
            final long total = value.getLong("total");
            final long active = value.getLong("active");
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    DbRealtimeTotalConnView.this.setTitleImage(Images.active);
                    long now = TimeUtil.getCurrentTime(DbRealtimeTotalConnView.this.serverId);
                    long stime = now - TIME_RANGE;
                    DbRealtimeTotalConnView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                    ((CircularBufferDataProvider)DbRealtimeTotalConnView.this.totalTrace.getDataProvider()).addSample(new Sample(now, total));
                    ((CircularBufferDataProvider)DbRealtimeTotalConnView.this.activeTrace.getDataProvider()).addSample(new Sample(now, active));
                    double max = ChartUtil.getMax(((CircularBufferDataProvider)DbRealtimeTotalConnView.this.totalTrace.getDataProvider()).iterator());
                    DbRealtimeTotalConnView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
            });
        }
    }
}

