/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.maria.views;

import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.listeners.RangeMouseListener;
import scouter.client.maria.actions.OpenDigestTableAction;
import scouter.client.model.AgentModelThread;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;

public class DbRealtimeTotalHitRatioView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = DbRealtimeTotalHitRatioView.class.getName();
    int serverId;
    RefreshThread thread;
    static long TIME_RANGE = 300000L;
    static int REFRESH_INTERVAL = 2000;
    FigureCanvas canvas;
    XYGraph xyGraph;
    Trace innoBufTrace;
    Trace keyCacheTrace;
    Trace queryCacheTrace;
    Trace threadCacheTrace;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        this.serverId = CastUtil.cint((Object)secId);
    }

    public void createPartControl(Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        this.setPartName("Hit Ratio[" + server.getName() + "]");
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                Rectangle r = DbRealtimeTotalHitRatioView.this.canvas.getClientArea();
                DbRealtimeTotalHitRatioView.this.xyGraph.setSize(r.width, r.height);
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(true);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setFormatPattern("HH:mm:ss");
        this.xyGraph.primaryYAxis.setFormatPattern("#,##0");
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.primaryYAxis.addMouseListener((MouseListener)new RangeMouseListener(this.getViewSite().getShell(), this.xyGraph.primaryYAxis));
        CircularBufferDataProvider innoDbProvider = new CircularBufferDataProvider(true);
        innoDbProvider.setBufferSize((int)(TIME_RANGE / (long)REFRESH_INTERVAL) + 1);
        innoDbProvider.setCurrentXDataArray(new double[0]);
        innoDbProvider.setCurrentYDataArray(new double[0]);
        this.innoBufTrace = new Trace("InnoDB Buffer (AVG)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, innoDbProvider);
        this.innoBufTrace.setPointStyle(Trace.PointStyle.NONE);
        this.innoBufTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.innoBufTrace.setTraceType(Trace.TraceType.SOLID_LINE);
        this.innoBufTrace.setTraceColor(ColorUtil.getInstance().getColor(10));
        this.xyGraph.addTrace(this.innoBufTrace);
        CircularBufferDataProvider keyProvider = new CircularBufferDataProvider(true);
        keyProvider.setBufferSize((int)(TIME_RANGE / (long)REFRESH_INTERVAL) + 1);
        keyProvider.setCurrentXDataArray(new double[0]);
        keyProvider.setCurrentYDataArray(new double[0]);
        this.keyCacheTrace = new Trace("Key Cache (AVG)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, keyProvider);
        this.keyCacheTrace.setPointStyle(Trace.PointStyle.NONE);
        this.keyCacheTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.keyCacheTrace.setTraceType(Trace.TraceType.SOLID_LINE);
        this.keyCacheTrace.setTraceColor(ColorUtil.getInstance().getColor(14));
        this.xyGraph.addTrace(this.keyCacheTrace);
        CircularBufferDataProvider queryProvider = new CircularBufferDataProvider(true);
        queryProvider.setBufferSize((int)(TIME_RANGE / (long)REFRESH_INTERVAL) + 1);
        queryProvider.setCurrentXDataArray(new double[0]);
        queryProvider.setCurrentYDataArray(new double[0]);
        this.queryCacheTrace = new Trace("Query Cache (AVG)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, queryProvider);
        this.queryCacheTrace.setPointStyle(Trace.PointStyle.NONE);
        this.queryCacheTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.queryCacheTrace.setTraceType(Trace.TraceType.SOLID_LINE);
        this.queryCacheTrace.setTraceColor(ColorUtil.getInstance().getColor(16));
        this.xyGraph.addTrace(this.queryCacheTrace);
        CircularBufferDataProvider threadProvider = new CircularBufferDataProvider(true);
        threadProvider.setBufferSize((int)(TIME_RANGE / (long)REFRESH_INTERVAL) + 1);
        threadProvider.setCurrentXDataArray(new double[0]);
        threadProvider.setCurrentYDataArray(new double[0]);
        this.threadCacheTrace = new Trace("Thread Cache (AVG)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, threadProvider);
        this.threadCacheTrace.setPointStyle(Trace.PointStyle.NONE);
        this.threadCacheTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.threadCacheTrace.setTraceType(Trace.TraceType.SOLID_LINE);
        this.threadCacheTrace.setTraceColor(ColorUtil.getInstance().getColor(6));
        this.xyGraph.addTrace(this.threadCacheTrace);
        ScouterUtil.addHorizontalRangeListener(this.xyGraph.getPlotArea(), new OpenDigestTableAction(this.serverId), false);
        this.thread = new RefreshThread(this, REFRESH_INTERVAL);
        this.thread.start();
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    @Override
    public void refresh() {
        Pack p;
        block8: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            p = null;
            try {
                try {
                    MapPack param = new MapPack();
                    ListValue objHashLv = AgentModelThread.getInstance().getLiveObjHashLV(this.serverId, "mariaplugin");
                    if (objHashLv.size() > 0) {
                        param.put("objHash", (Value)objHashLv);
                        p = tcp.getSingle("DB_REALTIME_HIT_RATIO", (Pack)param);
                    }
                }
                catch (Exception e) {
                    ConsoleProxy.errorSafe(e.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (p == null) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    DbRealtimeTotalHitRatioView.this.setTitleImage(Images.inactive);
                    long now = TimeUtil.getCurrentTime(DbRealtimeTotalHitRatioView.this.serverId);
                    long stime = now - TIME_RANGE;
                    DbRealtimeTotalHitRatioView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                    DbRealtimeTotalHitRatioView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                }
            });
        } else {
            final MapPack m = (MapPack)p;
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    long now = TimeUtil.getCurrentTime(DbRealtimeTotalHitRatioView.this.serverId);
                    long stime = now - TIME_RANGE;
                    DbRealtimeTotalHitRatioView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                    DbRealtimeTotalHitRatioView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                    if (m.size() == 0) {
                        DbRealtimeTotalHitRatioView.this.setTitleImage(Images.inactive);
                        return;
                    }
                    DbRealtimeTotalHitRatioView.this.setTitleImage(Images.active);
                    float innodb_buf = m.getFloat("innodb_buffer");
                    float key_cache = m.getFloat("key_cache");
                    float query_cache = m.getFloat("query_cache");
                    float thread_cache = m.getFloat("thread_cache");
                    ((CircularBufferDataProvider)DbRealtimeTotalHitRatioView.this.innoBufTrace.getDataProvider()).addSample(new Sample(now, innodb_buf));
                    ((CircularBufferDataProvider)DbRealtimeTotalHitRatioView.this.keyCacheTrace.getDataProvider()).addSample(new Sample(now, key_cache));
                    ((CircularBufferDataProvider)DbRealtimeTotalHitRatioView.this.queryCacheTrace.getDataProvider()).addSample(new Sample(now, query_cache));
                    ((CircularBufferDataProvider)DbRealtimeTotalHitRatioView.this.threadCacheTrace.getDataProvider()).addSample(new Sample(now, thread_cache));
                }
            });
        }
    }
}

