/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.maria.views;

import java.util.List;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.listeners.RangeMouseListener;
import scouter.client.maria.actions.OpenDigestTableAction;
import scouter.client.model.AgentModelThread;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;

public class DbRealtimeTotalResponseView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = DbRealtimeTotalResponseView.class.getName();
    int serverId;
    RefreshThread thread;
    Trace avgTrace;
    static long TIME_RANGE = 300000L;
    static int REFRESH_INTERVAL = 2000;
    FigureCanvas canvas;
    XYGraph xyGraph;
    static double PICO_TO_MS = Math.pow(10.0, -9.0);

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        this.serverId = CastUtil.cint((Object)secId);
    }

    public void createPartControl(Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        this.setPartName("ResponseTime[" + server.getName() + "]");
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                Rectangle r = DbRealtimeTotalResponseView.this.canvas.getClientArea();
                DbRealtimeTotalResponseView.this.xyGraph.setSize(r.width, r.height);
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(true);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setFormatPattern("HH:mm:ss");
        this.xyGraph.primaryYAxis.setFormatPattern("#,##0");
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.primaryYAxis.addMouseListener((MouseListener)new RangeMouseListener(this.getViewSite().getShell(), this.xyGraph.primaryYAxis));
        CircularBufferDataProvider avgProvider = new CircularBufferDataProvider(true);
        avgProvider.setBufferSize((int)(TIME_RANGE / (long)REFRESH_INTERVAL) + 1);
        avgProvider.setCurrentXDataArray(new double[0]);
        avgProvider.setCurrentYDataArray(new double[0]);
        this.avgTrace = new Trace("Response Time(ms)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, avgProvider);
        this.avgTrace.setPointStyle(Trace.PointStyle.NONE);
        this.avgTrace.setTraceType(Trace.TraceType.AREA);
        this.avgTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.avgTrace.setTraceColor(ColorUtil.getInstance().getColor(6));
        this.xyGraph.addTrace(this.avgTrace);
        ScouterUtil.addHorizontalRangeListener(this.xyGraph.getPlotArea(), new OpenDigestTableAction(this.serverId), false);
        this.thread = new RefreshThread(this, REFRESH_INTERVAL);
        this.thread.start();
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    @Override
    public void refresh() {
        List<Pack> list;
        block9: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            list = null;
            try {
                try {
                    MapPack param = new MapPack();
                    ListValue objHashLv = AgentModelThread.getInstance().getLiveObjHashLV(this.serverId, "mariaplugin");
                    if (objHashLv.size() > 0) {
                        param.put("objHash", (Value)objHashLv);
                        list = tcp.process("DB_REALTIME_RESPONSE_TIME", (Pack)param);
                    }
                }
                catch (Exception e) {
                    ConsoleProxy.errorSafe(e.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (list == null || list.size() == 0) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    DbRealtimeTotalResponseView.this.setTitleImage(Images.inactive);
                    long now = TimeUtil.getCurrentTime(DbRealtimeTotalResponseView.this.serverId);
                    long stime = now - TIME_RANGE;
                    DbRealtimeTotalResponseView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                }
            });
        } else {
            double sum = 0.0;
            for (Pack p : list) {
                MapPack m = (MapPack)p;
                sum += (double)m.getFloat("value");
            }
            final double avg = sum * PICO_TO_MS / (double)list.size();
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    DbRealtimeTotalResponseView.this.setTitleImage(Images.active);
                    long now = TimeUtil.getCurrentTime(DbRealtimeTotalResponseView.this.serverId);
                    long stime = now - TIME_RANGE;
                    DbRealtimeTotalResponseView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                    ((CircularBufferDataProvider)DbRealtimeTotalResponseView.this.avgTrace.getDataProvider()).addSample(new Sample(now, avg));
                    double max = ChartUtil.getMax(((CircularBufferDataProvider)DbRealtimeTotalResponseView.this.avgTrace.getDataProvider()).iterator());
                    DbRealtimeTotalResponseView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
            });
        }
    }
}

