/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.maria.views;

import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.maria.actions.OpenDbLockListAction;
import scouter.client.model.AgentColorManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.NumberValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;

public class DbRealtimeWaitCountView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = DbRealtimeWaitCountView.class.getName();
    int serverId;
    int objHash;
    RefreshThread thread;
    Trace trace;
    Trace pointTrace;
    static long TIME_RANGE = 300000L;
    static int REFRESH_INTERVAL = 2000;
    FigureCanvas canvas;
    XYGraph xyGraph;
    MapPack param = new MapPack();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objHash = CastUtil.cint((Object)ids[1]);
    }

    public void createPartControl(Composite parent) {
        AgentObject ao = AgentModelThread.getInstance().getAgentObject(this.objHash);
        this.setPartName("WaitCount[" + ao.getObjName() + "]");
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                Rectangle r = DbRealtimeWaitCountView.this.canvas.getClientArea();
                DbRealtimeWaitCountView.this.xyGraph.setSize(r.width, r.height);
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                double x = DbRealtimeWaitCountView.this.xyGraph.primaryXAxis.getPositionValue(e.x, false);
                ((CircularBufferDataProvider)DbRealtimeWaitCountView.this.pointTrace.getDataProvider()).addSample(new Sample(x, DbRealtimeWaitCountView.this.xyGraph.primaryYAxis.getRange().getUpper()));
                new OpenDbLockListAction(DbRealtimeWaitCountView.this.serverId, DbRealtimeWaitCountView.this.objHash, (long)x).run();
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(false);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setFormatPattern("HH:mm:ss");
        this.xyGraph.primaryYAxis.setFormatPattern("#,##0");
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        CircularBufferDataProvider avgProvider = new CircularBufferDataProvider(true);
        avgProvider.setBufferSize((int)(TIME_RANGE / (long)REFRESH_INTERVAL) + 1);
        avgProvider.setCurrentXDataArray(new double[0]);
        avgProvider.setCurrentYDataArray(new double[0]);
        this.trace = new Trace("WAIT_COUNT_TRACE", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, avgProvider);
        this.trace.setPointStyle(Trace.PointStyle.NONE);
        this.trace.setTraceType(Trace.TraceType.SOLID_LINE);
        this.trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.trace.setTraceColor(AgentColorManager.getInstance().assignColor(ao.getObjType(), this.objHash));
        this.xyGraph.addTrace(this.trace);
        CircularBufferDataProvider pointProvider = new CircularBufferDataProvider(true);
        pointProvider.setBufferSize(1);
        pointProvider.setCurrentXDataArray(new double[0]);
        pointProvider.setCurrentYDataArray(new double[0]);
        this.pointTrace = new Trace("POINT_TRACE", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, pointProvider);
        this.pointTrace.setPointStyle(Trace.PointStyle.NONE);
        this.pointTrace.setTraceType(Trace.TraceType.BAR);
        this.pointTrace.setLineWidth(1);
        this.pointTrace.setTraceColor(ColorUtil.getInstance().getColor("red"));
        this.xyGraph.addTrace(this.pointTrace);
        this.param.put("objHash", (long)this.objHash);
        this.param.put("counter", "WAIT_COUNT");
        this.param.put("timetype", 1L);
        this.setContentDescription("Double-click to see the detail list at that time.");
        this.thread = new RefreshThread(this, REFRESH_INTERVAL);
        this.thread.start();
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    @Override
    public void refresh() {
        Value v;
        block7: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            v = null;
            try {
                try {
                    v = tcp.getSingleValue("COUNTER_REAL_TIME", (Pack)this.param);
                }
                catch (Exception e) {
                    ConsoleProxy.errorSafe(e.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (v == null) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    DbRealtimeWaitCountView.this.setTitleImage(Images.inactive);
                    long now = TimeUtil.getCurrentTime(DbRealtimeWaitCountView.this.serverId);
                    long stime = now - TIME_RANGE;
                    DbRealtimeWaitCountView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                }
            });
        } else {
            final NumberValue nv = (NumberValue)v;
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    DbRealtimeWaitCountView.this.setTitleImage(Images.active);
                    long now = TimeUtil.getCurrentTime(DbRealtimeWaitCountView.this.serverId);
                    long stime = now - TIME_RANGE;
                    DbRealtimeWaitCountView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                    ((CircularBufferDataProvider)DbRealtimeWaitCountView.this.trace.getDataProvider()).addSample(new Sample(now, nv.doubleValue()));
                    double max = ChartUtil.getMax(((CircularBufferDataProvider)DbRealtimeWaitCountView.this.trace.getDataProvider()).iterator());
                    DbRealtimeWaitCountView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
            });
        }
    }
}

