/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.maria.views;

import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.maria.actions.OpenDigestTableAction;
import scouter.client.model.AgentDailyListProxy;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

public class DbTodayTotalActivityView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = DbTodayTotalActivityView.class.getName();
    int serverId;
    RefreshThread thread;
    static long TIME_RANGE = 86400000L;
    static int REFRESH_INTERVAL = 10000;
    static int BUFFER_SIZE = (int)(TIME_RANGE / 300000L);
    FigureCanvas canvas;
    XYGraph xyGraph;
    Trace callTrace;
    Trace selectTrace;
    Trace insertTrace;
    Trace updateTrace;
    Trace deleteTrace;
    boolean fixRange = false;
    AgentDailyListProxy agentDailyProxy = new AgentDailyListProxy();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        this.serverId = CastUtil.cint((Object)secId);
    }

    public void createPartControl(Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        this.setPartName("DB Activity[" + server.getName() + "]");
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                Rectangle r = DbTodayTotalActivityView.this.canvas.getClientArea();
                DbTodayTotalActivityView.this.xyGraph.setSize(r.width, r.height);
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(true);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setFormatPattern("HH:mm:ss");
        this.xyGraph.primaryYAxis.setFormatPattern("#,##0");
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        CircularBufferDataProvider callProvider = new CircularBufferDataProvider(true);
        callProvider.setBufferSize(BUFFER_SIZE);
        callProvider.setCurrentXDataArray(new double[0]);
        callProvider.setCurrentYDataArray(new double[0]);
        this.callTrace = new Trace("Call (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, callProvider);
        this.callTrace.setPointStyle(Trace.PointStyle.NONE);
        this.callTrace.setTraceType(Trace.TraceType.AREA);
        this.callTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.callTrace.setAreaAlpha(255);
        this.callTrace.setTraceColor(ColorUtil.getInstance().getColor(10));
        this.xyGraph.addTrace(this.callTrace);
        CircularBufferDataProvider selectProvider = new CircularBufferDataProvider(true);
        selectProvider.setBufferSize(BUFFER_SIZE);
        selectProvider.setCurrentXDataArray(new double[0]);
        selectProvider.setCurrentYDataArray(new double[0]);
        this.selectTrace = new Trace("Select (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, selectProvider);
        this.selectTrace.setPointStyle(Trace.PointStyle.NONE);
        this.selectTrace.setTraceType(Trace.TraceType.AREA);
        this.selectTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.selectTrace.setAreaAlpha(255);
        this.selectTrace.setTraceColor(ColorUtil.getInstance().getColor(14));
        this.xyGraph.addTrace(this.selectTrace);
        CircularBufferDataProvider insertProvider = new CircularBufferDataProvider(true);
        insertProvider.setBufferSize(BUFFER_SIZE);
        insertProvider.setCurrentXDataArray(new double[0]);
        insertProvider.setCurrentYDataArray(new double[0]);
        this.insertTrace = new Trace("Insert (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, insertProvider);
        this.insertTrace.setPointStyle(Trace.PointStyle.NONE);
        this.insertTrace.setTraceType(Trace.TraceType.AREA);
        this.insertTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.insertTrace.setAreaAlpha(255);
        this.insertTrace.setTraceColor(ColorUtil.getInstance().getColor(16));
        this.xyGraph.addTrace(this.insertTrace);
        CircularBufferDataProvider updateProvider = new CircularBufferDataProvider(true);
        updateProvider.setBufferSize(BUFFER_SIZE);
        updateProvider.setCurrentXDataArray(new double[0]);
        updateProvider.setCurrentYDataArray(new double[0]);
        this.updateTrace = new Trace("Update (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, updateProvider);
        this.updateTrace.setPointStyle(Trace.PointStyle.NONE);
        this.updateTrace.setTraceType(Trace.TraceType.AREA);
        this.updateTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.updateTrace.setAreaAlpha(255);
        this.updateTrace.setTraceColor(ColorUtil.getInstance().getColor(6));
        this.xyGraph.addTrace(this.updateTrace);
        CircularBufferDataProvider deleteProvider = new CircularBufferDataProvider(true);
        deleteProvider.setBufferSize(BUFFER_SIZE);
        deleteProvider.setCurrentXDataArray(new double[0]);
        deleteProvider.setCurrentYDataArray(new double[0]);
        this.deleteTrace = new Trace("Delete (SUM)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, deleteProvider);
        this.deleteTrace.setPointStyle(Trace.PointStyle.NONE);
        this.deleteTrace.setTraceType(Trace.TraceType.AREA);
        this.deleteTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.deleteTrace.setAreaAlpha(255);
        this.deleteTrace.setTraceColor(ColorUtil.getInstance().getColor(12));
        this.xyGraph.addTrace(this.deleteTrace);
        ScouterUtil.addHorizontalRangeListener(this.xyGraph.getPlotArea(), new OpenDigestTableAction(this.serverId), true);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        Action fixRangeAct = new Action("Pin Range", 2){

            public void run() {
                DbTodayTotalActivityView.this.fixRange = this.isChecked();
            }
        };
        fixRangeAct.setImageDescriptor(ImageUtil.getImageDescriptor(Images.pin));
        man.add((IAction)fixRangeAct);
        this.thread = new RefreshThread(this, REFRESH_INTERVAL);
        this.thread.start();
    }

    public void setFocus() {
    }

    @Override
    public void refresh() {
        String date;
        Pack p;
        block7: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            p = null;
            date = DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(this.serverId));
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objHash", (Value)this.agentDailyProxy.getObjHashLv(date, this.serverId, "mariaplugin"));
                    param.put("sdate", date);
                    param.put("edate", date);
                    p = tcp.getSingle("DB_DAILY_ACTIVITY", (Pack)param);
                }
                catch (Exception e) {
                    ConsoleProxy.errorSafe(e.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (p == null) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    DbTodayTotalActivityView.this.setTitleImage(Images.inactive);
                    if (!DbTodayTotalActivityView.this.fixRange) {
                        DbTodayTotalActivityView.this.setContentDescription(String.valueOf(date.substring(0, 4)) + "-" + date.substring(5, 6) + "-" + date.substring(7, 8));
                        long stime = DateUtil.yyyymmdd((String)date);
                        long etime = stime + 86400000L - 1L;
                        DbTodayTotalActivityView.this.xyGraph.primaryXAxis.setRange(stime, etime);
                    }
                }
            });
        } else {
            MapPack m = (MapPack)p;
            final ListValue timeLv = m.getList("time");
            final ListValue callLv = m.getList("call");
            final ListValue selectLv = m.getList("select");
            final ListValue insertLv = m.getList("insert");
            final ListValue updateLv = m.getList("update");
            final ListValue deleteLv = m.getList("delete");
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    DbTodayTotalActivityView.this.setTitleImage(Images.active);
                    CircularBufferDataProvider callProvider = (CircularBufferDataProvider)DbTodayTotalActivityView.this.callTrace.getDataProvider();
                    CircularBufferDataProvider selectProvider = (CircularBufferDataProvider)DbTodayTotalActivityView.this.selectTrace.getDataProvider();
                    CircularBufferDataProvider insertProvider = (CircularBufferDataProvider)DbTodayTotalActivityView.this.insertTrace.getDataProvider();
                    CircularBufferDataProvider updateProvider = (CircularBufferDataProvider)DbTodayTotalActivityView.this.updateTrace.getDataProvider();
                    CircularBufferDataProvider deleteProvider = (CircularBufferDataProvider)DbTodayTotalActivityView.this.deleteTrace.getDataProvider();
                    callProvider.clearTrace();
                    selectProvider.clearTrace();
                    insertProvider.clearTrace();
                    updateProvider.clearTrace();
                    deleteProvider.clearTrace();
                    int i = 0;
                    while (i < timeLv.size()) {
                        long time = timeLv.getLong(i);
                        double value = deleteLv.getDouble(i);
                        deleteProvider.addSample(new Sample(time, value));
                        updateProvider.addSample(new Sample(time, value += updateLv.getDouble(i)));
                        insertProvider.addSample(new Sample(time, value += insertLv.getDouble(i)));
                        selectProvider.addSample(new Sample(time, value += selectLv.getDouble(i)));
                        callProvider.addSample(new Sample(time, value += callLv.getDouble(i)));
                        ++i;
                    }
                    if (!DbTodayTotalActivityView.this.fixRange) {
                        DbTodayTotalActivityView.this.setContentDescription(String.valueOf(date.substring(0, 4)) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8));
                        long stime = DateUtil.yyyymmdd((String)date);
                        long etime = stime + 86400000L - 1L;
                        DbTodayTotalActivityView.this.xyGraph.primaryXAxis.setRange(stime, etime);
                        double max = ChartUtil.getMax(callProvider.iterator());
                        DbTodayTotalActivityView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                    }
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }
}

