/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.maria.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.maria.views.DigestSchema;
import scouter.client.model.AgentDailyListProxy;
import scouter.client.model.DigestModel;
import scouter.client.model.RefreshThread;
import scouter.client.model.TextProxy;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.popup.DigestDetailDialog;
import scouter.client.sorter.TreeLabelSorter;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;
import scouter.io.DataInputX;
import scouter.lang.DigestKey;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.StatusPack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;

public class DigestTableView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = DigestTableView.class.getName();
    double PICO = Math.pow(10.0, -12.0);
    int serverId;
    Composite parent;
    TreeViewer viewer;
    TreeColumnLayout columnLayout;
    AgentDailyListProxy agentProxy = new AgentDailyListProxy();
    RefreshThread thread;
    boolean isAutoRefresh = false;
    String date;
    long stime;
    long etime;
    HashMap<Integer, DigestModel> root = new HashMap();
    ArrayList<DigestSchema> columnList = new ArrayList();
    Job loadQueryJob = new Job("Load Digest List..."){
        HashMap<DigestKey, MapPack> summaryMap;
        HashMap<Integer, StatusPack> firstStatusMap;
        HashMap<Integer, StatusPack> lastStatusMap;
        {
            this.summaryMap = new HashMap();
            this.firstStatusMap = new HashMap();
            this.lastStatusMap = new HashMap();
        }

        protected IStatus run(final IProgressMonitor monitor) {
            block19: {
                this.summaryMap.clear();
                this.firstStatusMap.clear();
                this.lastStatusMap.clear();
                monitor.beginTask(String.valueOf(DateUtil.hhmmss((long)DigestTableView.this.stime)) + " ~ " + DateUtil.hhmmss((long)DigestTableView.this.etime), 100);
                TcpProxy tcp = TcpProxy.getTcpProxy(DigestTableView.this.serverId);
                try {
                    try {
                        MapPack param = new MapPack();
                        ListValue objHashLv = DigestTableView.this.agentProxy.getObjHashLv(DigestTableView.this.date, DigestTableView.this.serverId, "mariaplugin");
                        if (objHashLv.size() > 0) {
                            param.put("objHash", (Value)objHashLv);
                            param.put("date", DigestTableView.this.date);
                            param.put("time", DigestTableView.this.stime);
                            List<Pack> firstList = tcp.process("DB_LAST_DIGEST_TABLE", (Pack)param);
                            for (Pack p : firstList) {
                                StatusPack s = (StatusPack)p;
                                this.firstStatusMap.put(s.objHash, s);
                            }
                            param.put("stime", DigestTableView.this.stime);
                            param.put("etime", DigestTableView.this.etime);
                            tcp.process("DB_DIGEST_TABLE", param, new INetReader(){

                                @Override
                                public void process(DataInputX in) throws IOException {
                                    Pack p = in.readPack();
                                    switch (p.getPackType()) {
                                        case 10: {
                                            MapPack m = (MapPack)p;
                                            if (m.containsKey("percent")) {
                                                monitor.worked(m.getInt("percent"));
                                                break;
                                            }
                                            int objHash = m.getInt("objHash");
                                            int digestHash = m.getInt("digestHash");
                                            summaryMap.put(new DigestKey(objHash, digestHash), m);
                                            break;
                                        }
                                        case 61: {
                                            StatusPack sp = (StatusPack)p;
                                            lastStatusMap.put(sp.objHash, sp);
                                        }
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        ConsoleProxy.errorSafe(e.toString());
                        TcpProxy.putTcpProxy(tcp);
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    TcpProxy.putTcpProxy(tcp);
                    throw throwable;
                }
                TcpProxy.putTcpProxy(tcp);
            }
            for (int objHash : this.lastStatusMap.keySet()) {
                StatusPack firstStatus = this.firstStatusMap.get(objHash);
                StatusPack lastStatus = this.lastStatusMap.get(objHash);
                HashMap<Integer, MapValue> firstMap = new HashMap<Integer, MapValue>();
                if (firstStatus != null) {
                    MapValue firstData = firstStatus.data;
                    ListValue firstDigestLv = firstData.getList("DIGEST_TEXT");
                    int i = 0;
                    while (i < firstDigestLv.size()) {
                        int digestHash = firstDigestLv.getInt(i);
                        MapValue valueMap = new MapValue();
                        Enumeration keys = firstData.keys();
                        while (keys.hasMoreElements()) {
                            String key = (String)keys.nextElement();
                            valueMap.put(key, firstData.getList(key).get(i));
                        }
                        firstMap.put(digestHash, valueMap);
                        ++i;
                    }
                }
                MapValue data = lastStatus.data;
                ListValue digestLv = data.getList("DIGEST_TEXT");
                ListValue schemaNameLv = data.getList("SCHEMA_NAME");
                ListValue executionLv = data.getList("COUNT_STAR");
                ListValue timerWaitLv = data.getList("SUM_TIMER_WAIT");
                ListValue lockTimeLv = data.getList("SUM_LOCK_TIME");
                ListValue errorsLv = data.getList("SUM_ERRORS");
                ListValue warnsLv = data.getList("SUM_WARNINGS");
                ListValue rowsAffectedLv = data.getList("SUM_ROWS_AFFECTED");
                ListValue rowsSentLv = data.getList("SUM_ROWS_SENT");
                ListValue rowsExaminedLv = data.getList("SUM_ROWS_EXAMINED");
                ListValue createdTmpDiskTablesLv = data.getList("SUM_CREATED_TMP_DISK_TABLES");
                ListValue createdTmpTablesLv = data.getList("SUM_CREATED_TMP_TABLES");
                ListValue selectFullJoin = data.getList("SUM_SELECT_FULL_JOIN");
                ListValue selectFullRangeJoin = data.getList("SUM_SELECT_FULL_RANGE_JOIN");
                ListValue selectRangeLv = data.getList("SUM_SELECT_RANGE");
                ListValue selectRangeCheckLv = data.getList("SUM_SELECT_RANGE_CHECK");
                ListValue selectScanLv = data.getList("SUM_SELECT_SCAN");
                ListValue sortMergePassesLv = data.getList("SUM_SORT_MERGE_PASSES");
                ListValue sortRangeLv = data.getList("SUM_SORT_RANGE");
                ListValue sortRowsLv = data.getList("SUM_SORT_ROWS");
                ListValue sortScanLv = data.getList("SUM_SORT_SCAN");
                ListValue noIndexUsedLv = data.getList("SUM_NO_INDEX_USED");
                ListValue noGoodIndexUsedLv = data.getList("SUM_NO_GOOD_INDEX_USED");
                ListValue firstSeenLv = data.getList("FIRST_SEEN");
                ListValue lastSeenLv = data.getList("LAST_SEEN");
                int i = 0;
                while (i < digestLv.size()) {
                    if (lastSeenLv.getLong(i) >= DigestTableView.this.stime && lastSeenLv.getLong(i) <= DigestTableView.this.etime) {
                        DigestModel model = new DigestModel();
                        int digestHash = digestLv.getInt(i);
                        MapPack m = this.summaryMap.get(new DigestKey(objHash, digestHash));
                        if (m != null) {
                            long maxTimerWait = m.getLong("MAX_TIMER_WAIT");
                            long minTimerWait = m.getLong("MIN_TIMER_WAIT");
                            long avgTimerWait = m.getLong("AVG_TIMER_WAIT");
                            int count = m.getInt("count");
                            model.objHash = objHash;
                            model.digestHash = digestHash;
                            model.name = TextProxy.object.getLoadText(DigestTableView.this.date, objHash, DigestTableView.this.serverId);
                            model.database = TextProxy.maria.getLoadText(DigestTableView.this.date, schemaNameLv.getInt(i), DigestTableView.this.serverId);
                            model.firstSeen = firstSeenLv.getLong(i);
                            model.lastSeen = lastSeenLv.getLong(i);
                            model.avgResponseTime = (double)avgTimerWait / (double)count;
                            model.minResponseTime = minTimerWait;
                            model.maxResponseTime = maxTimerWait;
                            MapValue firstValue = (MapValue)firstMap.get(digestHash);
                            if (firstValue == null) {
                                firstValue = new MapValue();
                            }
                            model.execution = executionLv.getInt(i) - firstValue.getInt("COUNT_STAR");
                            if (model.execution < 1) {
                                System.out.println("first=>" + firstStatus);
                                System.out.println("last =>" + lastStatus);
                            }
                            model.errorCnt = errorsLv.getInt(i) - firstValue.getInt("SUM_ERRORS");
                            model.warnCnt = warnsLv.getInt(i) - firstValue.getInt("SUM_WARNINGS");
                            model.sumResponseTime = timerWaitLv.getLong(i) - firstValue.getLong("SUM_TIMER_WAIT");
                            model.lockTime = lockTimeLv.getLong(i) - firstValue.getLong("SUM_LOCK_TIME");
                            model.rowsAffected = rowsAffectedLv.getLong(i) - firstValue.getLong("SUM_ROWS_AFFECTED");
                            model.rowsSent = rowsSentLv.getLong(i) - firstValue.getLong("SUM_ROWS_SENT");
                            model.rowsExamined = rowsExaminedLv.getLong(i) - firstValue.getLong("SUM_ROWS_EXAMINED");
                            model.createdTmpDiskTables = createdTmpDiskTablesLv.getLong(i) - firstValue.getLong("SUM_CREATED_TMP_DISK_TABLES");
                            model.createdTmpTables = createdTmpTablesLv.getLong(i) - firstValue.getLong("SUM_CREATED_TMP_TABLES");
                            model.selectFullJoin = selectFullJoin.getLong(i) - firstValue.getLong("SUM_SELECT_FULL_JOIN");
                            model.selectFullRangeJoin = selectFullRangeJoin.getLong(i) - firstValue.getLong("SUM_SELECT_FULL_RANGE_JOIN");
                            model.selectRange = selectRangeLv.getLong(i) - firstValue.getLong("SUM_SELECT_RANGE");
                            model.selectRangeCheck = selectRangeCheckLv.getLong(i) - firstValue.getLong("SUM_SELECT_RANGE_CHECK");
                            model.selectScan = selectScanLv.getLong(i) - firstValue.getLong("SUM_SELECT_SCAN");
                            model.sortMergePasses = sortMergePassesLv.getLong(i) - firstValue.getLong("SUM_SORT_MERGE_PASSES");
                            model.sortRange = sortRangeLv.getLong(i) - firstValue.getLong("SUM_SORT_RANGE");
                            model.sortRows = sortRowsLv.getLong(i) - firstValue.getLong("SUM_SORT_ROWS");
                            model.sortScan = sortScanLv.getLong(i) - firstValue.getLong("SUM_SORT_SCAN");
                            model.noIndexUsed = noIndexUsedLv.getLong(i) - firstValue.getLong("SUM_NO_INDEX_USED");
                            model.noGoodIndexUsed = noGoodIndexUsedLv.getLong(i) - firstValue.getLong("SUM_NO_GOOD_INDEX_USED");
                            DigestModel parent = DigestTableView.this.root.get(digestHash);
                            if (parent == null) {
                                parent = new DigestModel();
                                parent.digestHash = digestHash;
                                String digestTxt = TextProxy.maria.getLoadText(DigestTableView.this.date, digestHash, DigestTableView.this.serverId);
                                parent.name = digestTxt == null ? "unknown hash" : digestTxt;
                                DigestTableView.this.root.put(digestHash, parent);
                            }
                            model.parent = parent;
                            parent.addChild(model);
                        }
                    }
                    ++i;
                }
            }
            for (DigestModel parent : DigestTableView.this.root.values()) {
                DigestModel[] childs = parent.getChildArray();
                if (childs == null) continue;
                double sumAvg = 0.0;
                DigestModel[] digestModelArray = childs;
                int n = childs.length;
                int n2 = 0;
                while (n2 < n) {
                    DigestModel child = digestModelArray[n2];
                    sumAvg += child.avgResponseTime;
                    ++n2;
                }
                parent.avgResponseTime = sumAvg / (double)childs.length;
            }
            monitor.done();
            ExUtil.exec((Composite)DigestTableView.this.viewer.getTree(), new Runnable(){

                @Override
                public void run() {
                    DigestTableView.this.setContentDescription(String.valueOf(DateUtil.format((long)(this).DigestTableView.this.stime, (String)"MM-dd HH:mm:ss")) + " ~ " + DateUtil.format((long)(this).DigestTableView.this.etime, (String)"MM-dd HH:mm:ss") + " (" + (this).DigestTableView.this.root.size() + ")");
                    (this).DigestTableView.this.viewer.refresh();
                }
            });
            return Status.OK_STATUS;
        }
    };

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        this.serverId = CastUtil.cint((Object)secId);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        GridLayout gridlayout = new GridLayout(1, false);
        gridlayout.marginHeight = 0;
        gridlayout.horizontalSpacing = 0;
        gridlayout.marginWidth = 0;
        parent.setLayout((Layout)gridlayout);
        this.columnLayout = new TreeColumnLayout();
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComp.setLayout((Layout)this.columnLayout);
        this.viewer = new TreeViewer(mainComp, 68352);
        this.createColumns();
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.viewer.setComparator((ViewerComparator)new TreeLabelSorter(this.viewer));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof DigestModel) {
                    DigestModel model = (DigestModel)o;
                    new DigestDetailDialog().show(model, DigestTableView.this.stime, DigestTableView.this.etime, DigestTableView.this.serverId);
                }
            }
        });
        this.viewer.setInput(this.root);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        Action actAutoRefresh = new Action("Auto Refresh in 10 sec.", 2){

            public void run() {
                DigestTableView.this.isAutoRefresh = this.isChecked();
                if (DigestTableView.this.isAutoRefresh) {
                    DigestTableView.this.thread.interrupt();
                }
            }
        };
        actAutoRefresh.setImageDescriptor(ImageUtil.getImageDescriptor(Images.refresh_auto));
        man.add((IAction)actAutoRefresh);
        long now = TimeUtil.getCurrentTime(this.serverId);
        this.date = DateUtil.yyyymmdd((long)now);
        this.stime = now - 300000L;
        this.etime = now;
        this.loadQueryJob.schedule(2000L);
        this.thread = new RefreshThread(this, 10000);
        this.thread.start();
    }

    @Override
    public void refresh() {
        if (this.isAutoRefresh) {
            this.root.clear();
            long now = TimeUtil.getCurrentTime(this.serverId);
            this.date = DateUtil.yyyymmdd((long)now);
            this.stime = now - 300000L;
            this.etime = now;
            this.loadQueryJob.schedule();
        }
    }

    public void setInput(long stime, long etime) {
        if (this.loadQueryJob.getState() == 2 || this.loadQueryJob.getState() == 4) {
            MessageDialog.openInformation(null, (String)"STOP", (String)"Previous loading is not yet finished");
            return;
        }
        if (etime - stime < 60000L) {
            stime = etime - 60000L;
        }
        this.root.clear();
        this.stime = stime;
        this.etime = etime;
        this.date = DateUtil.yyyymmdd((long)stime);
        this.loadQueryJob.schedule();
    }

    private void createColumns() {
        this.columnList.clear();
        DigestSchema[] digestSchemaArray = DigestSchema.values();
        int n = digestSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            DigestSchema column = digestSchemaArray[n2];
            this.createTreeViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), true, true, column.isNumber());
            this.columnList.add(column);
            ++n2;
        }
    }

    private TreeViewerColumn createTreeViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.viewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.columnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeLabelSorter sorter = (TreeLabelSorter)DigestTableView.this.viewer.getComparator();
                TreeColumn selectedColumn = (TreeColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        if (this.loadQueryJob != null && (this.loadQueryJob.getState() == 2 || this.loadQueryJob.getState() == 4)) {
            this.loadQueryJob.cancel();
        }
    }

    public static void main(String[] args) {
        System.out.println(1.39871834183E11 * Math.pow(10.0, -12.0));
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }

        public Object[] getChildren(Object parentElement) {
            DigestModel parent;
            Object[] array;
            if (parentElement instanceof DigestModel && (array = (parent = (DigestModel)parentElement).getChildArray()) != null) {
                return array;
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof HashMap) {
                HashMap map = (HashMap)inputElement;
                Object[] objArray = new Object[map.size()];
                Iterator itr = map.values().iterator();
                int cnt = 0;
                while (itr.hasNext()) {
                    objArray[cnt] = itr.next();
                    ++cnt;
                }
                return objArray;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof DigestModel) {
                return ((DigestModel)element).parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof DigestModel) {
                return ((DigestModel)element).getChildArray() != null;
            }
            return false;
        }
    }

    class TreeLabelProvider
    implements ITableLabelProvider {
        TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof DigestModel) {
                DigestModel model = (DigestModel)element;
                DigestSchema column = DigestTableView.this.columnList.get(columnIndex);
                switch (column) {
                    case DIGEST_TEXT: {
                        return model.name;
                    }
                    case SCHEMA_NAME: {
                        return model.database;
                    }
                    case COUNT_STAR: {
                        return FormatUtil.print((Object)model.execution, (String)"#,##0");
                    }
                    case SUM_ERRORS: {
                        return FormatUtil.print((Object)model.errorCnt, (String)"#,##0");
                    }
                    case SUM_WARNINGS: {
                        return FormatUtil.print((Object)model.warnCnt, (String)"#,##0");
                    }
                    case SUM_TIMER_WAIT: {
                        return FormatUtil.print((Object)((double)model.sumResponseTime * DigestTableView.this.PICO), (String)"#,##0.00#");
                    }
                    case AVG_TIMER_WAIT: {
                        return FormatUtil.print((Object)(model.avgResponseTime * DigestTableView.this.PICO), (String)"#,##0.00#");
                    }
                    case MIN_TIMER_WAIT: {
                        return FormatUtil.print((Object)((double)model.minResponseTime * DigestTableView.this.PICO), (String)"#,##0.00#");
                    }
                    case MAX_TIMER_WAIT: {
                        return FormatUtil.print((Object)((double)model.maxResponseTime * DigestTableView.this.PICO), (String)"#,##0.00#");
                    }
                    case SUM_LOCK_TIME: {
                        return FormatUtil.print((Object)((double)model.lockTime * DigestTableView.this.PICO), (String)"#,##0.00#");
                    }
                    case SUM_ROWS_AFFECTED: {
                        return FormatUtil.print((Object)model.rowsAffected, (String)"#,##0");
                    }
                    case SUM_ROWS_SENT: {
                        return FormatUtil.print((Object)model.rowsSent, (String)"#,##0");
                    }
                    case SUM_ROWS_EXAMINED: {
                        return FormatUtil.print((Object)model.rowsExamined, (String)"#,##0");
                    }
                    case SUM_CREATED_TMP_DISK_TABLES: {
                        return FormatUtil.print((Object)model.createdTmpDiskTables, (String)"#,##0");
                    }
                    case SUM_CREATED_TMP_TABLES: {
                        return FormatUtil.print((Object)model.createdTmpTables, (String)"#,##0");
                    }
                    case SUM_SELECT_FULL_JOIN: {
                        return FormatUtil.print((Object)model.selectFullJoin, (String)"#,##0");
                    }
                    case SUM_SELECT_FULL_RANGE_JOIN: {
                        return FormatUtil.print((Object)model.selectFullRangeJoin, (String)"#,##0");
                    }
                    case SUM_SELECT_RANGE: {
                        return FormatUtil.print((Object)model.selectRange, (String)"#,##0");
                    }
                    case SUM_SELECT_RANGE_CHECK: {
                        return FormatUtil.print((Object)model.selectRangeCheck, (String)"#,##0");
                    }
                    case SUM_SELECT_SCAN: {
                        return FormatUtil.print((Object)model.selectScan, (String)"#,##0");
                    }
                    case SUM_SORT_MERGE_PASSES: {
                        return FormatUtil.print((Object)model.sortMergePasses, (String)"#,##0");
                    }
                    case SUM_SORT_RANGE: {
                        return FormatUtil.print((Object)model.sortRange, (String)"#,##0");
                    }
                    case SUM_SORT_ROWS: {
                        return FormatUtil.print((Object)model.sortRows, (String)"#,##0");
                    }
                    case SUM_SORT_SCAN: {
                        return FormatUtil.print((Object)model.sortScan, (String)"#,##0");
                    }
                    case SUM_NO_INDEX_USED: {
                        return FormatUtil.print((Object)model.noIndexUsed, (String)"#,##0");
                    }
                    case SUM_NO_GOOD_INDEX_USED: {
                        return FormatUtil.print((Object)model.noGoodIndexUsed, (String)"#,##0");
                    }
                    case FIRST_SEEN: {
                        return DateUtil.timestamp((long)model.firstSeen);
                    }
                    case LAST_SEEN: {
                        return DateUtil.timestamp((long)model.lastSeen);
                    }
                }
            }
            return null;
        }
    }
}

