/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.misc;

import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import scouter.Version;
import scouter.client.server.ServerManager;
import scouter.client.util.ExUtil;
import scouter.util.StringUtil;
import scouter.util.ThreadUtil;

public enum UpdateCheckScheduler {
    INSTANCE;

    private final String RELEASE_BASE_URL = "https://github.com/scouter-project/scouter/releases";
    private final String releaseVersionAppendix = "/tag/";
    boolean initialized = false;

    public void initialize() {
        ExUtil.asyncRun(() -> {
            if (!this.initialized) {
                this.initialized = true;
                try {
                    ThreadUtil.sleep((long)6000L);
                    this.process();
                }
                catch (Exception e) {
                    this.initialized = false;
                    e.printStackTrace();
                }
            }
        });
    }

    private void process() throws IOException {
        String clientVersion;
        final String recommendedVersion = UpdateCheckScheduler.getRecommendedVersion();
        if (Version.versionCompare((String)recommendedVersion, (String)(clientVersion = Version.getVersion())) > 0) {
            ExUtil.exec(PlatformUI.getWorkbench().getDisplay(), new Runnable(){

                @Override
                public void run() {
                    String message = "You can update your scouter client v" + clientVersion + " to v" + recommendedVersion + "\nDo you want to download it from the release page?";
                    boolean ok = MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Confirm", (String)message);
                    if (ok) {
                        Program.launch((String)("https://github.com/scouter-project/scouter/releases/tag/v" + recommendedVersion));
                    }
                }
            });
        }
    }

    public static String getRecommendedVersion() {
        return ServerManager.getInstance().getOpenServerList().stream().map(ServerManager.getInstance()::getServer).map(s -> StringUtil.isNotEmpty((String)s.getRecommendedClientVersion()) ? s.getRecommendedClientVersion() : s.getVersion()).map(UpdateCheckScheduler::getVersionOnly).max(Version::versionCompare).orElse("");
    }

    private static String getVersionOnly(String buildIncludedVersion) {
        String[] parts = buildIncludedVersion.split(" ");
        return parts[0];
    }
}

