/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import scouter.client.util.ColorUtil;

public class AgentColorManager {
    private static AgentColorManager instance;
    private Map<Integer, Color> assignedColor = new HashMap<Integer, Color>();
    private Map<String, Integer> assignedIndex = new HashMap<String, Integer>();

    public static synchronized AgentColorManager getInstance() {
        if (instance == null) {
            instance = new AgentColorManager();
        }
        return instance;
    }

    private AgentColorManager() {
    }

    public Color getColor(int objHash) {
        return this.assignedColor.get(objHash);
    }

    public Color assignColor(String objType, int objHash) {
        Color color = this.assignedColor.get(objHash);
        if (color != null) {
            return color;
        }
        if (!this.assignedIndex.containsKey(objType)) {
            this.assignedIndex.put(objType, 0);
        }
        int index = this.assignedIndex.get(objType);
        color = this.searchAvaliableColor(ColorUtil.default_rgb_map[index % ColorUtil.default_rgb_map.length]);
        this.assignedColor.put(objHash, color);
        if (index >= ColorUtil.default_rgb_map.length - 1) {
            this.assignedIndex.put(objType, 0);
        } else {
            this.assignedIndex.put(objType, index + 1);
        }
        return color;
    }

    public Color changeColor(int objHash, RGB rgb) {
        Color color = this.searchAvaliableColor(rgb);
        this.assignedColor.put(objHash, color);
        return color;
    }

    private Color searchAvaliableColor(RGB rgb) {
        for (Color existColor : this.assignedColor.values()) {
            if (!existColor.getRGB().equals((Object)rgb)) continue;
            int[] rgbs = new int[]{rgb.red, rgb.green, rgb.blue};
            int rand = (int)(Math.random() * 3.0);
            rgbs[rand] = (rgbs[rand] + 1) % 256;
            return this.searchAvaliableColor(new RGB(rgbs[0], rgbs[1], rgbs[2]));
        }
        return new Color(null, rgb);
    }

    public int getObjectHash(RGB rgb) {
        for (int objHash : this.assignedColor.keySet()) {
            Color objColor = this.assignedColor.get(objHash);
            if (!objColor.getRGB().equals((Object)rgb)) continue;
            return objHash;
        }
        return 0;
    }

    public static void main(String[] args) {
        System.out.println((int)(Math.random() * 3.0));
    }
}

