/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.model;

import java.util.ArrayList;
import java.util.HashMap;
import scouter.client.model.AgentObject;
import scouter.client.net.TcpProxy;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.DateUtil;

public class AgentDailyListProxy {
    HashMap<Key, ListValue> cacheMap = new HashMap();

    public ArrayList<AgentObject> getObjectList(String date, int serverId) {
        ArrayList<AgentObject> agentList = new ArrayList<AgentObject>();
        TcpProxy proxy = TcpProxy.getTcpProxy(serverId);
        try {
            MapPack param = new MapPack();
            param.put("date", date);
            MapPack out = (MapPack)proxy.getSingle("OBJECT_LIST_LOAD_DATE", (Pack)param);
            ListValue objTypeLv = out.getList("objType");
            ListValue objHashLv = out.getList("objHash");
            ListValue objNameLv = out.getList("objName");
            if (objHashLv == null || objHashLv.size() < 0) {
                ArrayList<AgentObject> arrayList = agentList;
                return arrayList;
            }
            try {
                int i = 0;
                while (i < objHashLv.size()) {
                    int objHash = (int)objHashLv.getLong(i);
                    String objType = objTypeLv.getString(i);
                    String objName = objNameLv.getString(i);
                    AgentObject agentObject = new AgentObject(objType, objHash, objName, serverId);
                    agentList.add(agentObject);
                    ++i;
                }
            }
            catch (Exception e) {
                ConsoleProxy.errorSafe(e.toString());
            }
        }
        finally {
            TcpProxy.putTcpProxy(proxy);
        }
        return agentList;
    }

    public AgentObject getAgentObject(String date, int serverId, int objHash) {
        TcpProxy proxy = TcpProxy.getTcpProxy(serverId);
        try {
            MapPack param = new MapPack();
            param.put("date", date);
            MapPack out = (MapPack)proxy.getSingle("OBJECT_LIST_LOAD_DATE", (Pack)param);
            ListValue objTypeLv = out.getList("objType");
            ListValue objHashLv = out.getList("objHash");
            ListValue objNameLv = out.getList("objName");
            if (objHashLv == null || objHashLv.size() < 0) {
                return null;
            }
            int i = 0;
            while (i < objHashLv.size()) {
                int hash = (int)objHashLv.getLong(i);
                if (objHash == hash) {
                    String objType = objTypeLv.getString(i);
                    String objName = objNameLv.getString(i);
                    AgentObject agentObject = new AgentObject(objType, objHash, objName, serverId);
                    return agentObject;
                }
                try {
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    ConsoleProxy.errorSafe(e.toString());
                }
                break;
            }
        }
        finally {
            TcpProxy.putTcpProxy(proxy);
        }
        return null;
    }

    public ListValue getObjHashLv(String date, int serverId, String objType) {
        Key key = new Key(date, serverId, objType);
        ListValue lv = this.cacheMap.get(key);
        if (!DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(serverId)).equals(date) && lv != null) {
            return lv;
        }
        lv = new ListValue();
        this.cacheMap.put(key, lv);
        TcpProxy proxy = TcpProxy.getTcpProxy(serverId);
        try {
            MapPack param = new MapPack();
            param.put("date", date);
            MapPack out = (MapPack)proxy.getSingle("OBJECT_LIST_LOAD_DATE", (Pack)param);
            ListValue objHashLv = out.getList("objHash");
            if (objHashLv == null || objHashLv.size() < 0) {
                ListValue listValue = lv;
                return listValue;
            }
            try {
                ListValue objTypeLv = out.getList("objType");
                int i = 0;
                while (i < objHashLv.size()) {
                    String type = objTypeLv.getString(i);
                    if (objType.equals(type)) {
                        int objHash = (int)objHashLv.getLong(i);
                        lv.add((long)objHash);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                ConsoleProxy.errorSafe(e.toString());
            }
        }
        finally {
            TcpProxy.putTcpProxy(proxy);
        }
        return lv;
    }

    static class Key {
        String date;
        int serverId;
        String objType;

        Key(String date, int serverId, String objType) {
            this.date = date;
            this.serverId = serverId;
            this.objType = objType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
            result = 31 * result + (this.objType == null ? 0 : this.objType.hashCode());
            result = 31 * result + this.serverId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
                return false;
            }
            if (this.objType == null ? other.objType != null : !this.objType.equals(other.objType)) {
                return false;
            }
            return this.serverId == other.serverId;
        }
    }
}

