/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.model;

import java.util.List;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;

public class AgentDataProxy {
    public static MapPack getThreadList(int objHash, int serverId) {
        MapPack param = new MapPack();
        param.put("objHash", (long)objHash);
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            MapPack mapPack = (MapPack)tcp.getSingle("OBJECT_THREAD_LIST", (Pack)param);
            return mapPack;
        }
        catch (Exception e) {
            ConsoleProxy.errorSafe(e.toString());
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return null;
    }

    public static List<Pack> getActiveThreadList(String objType, int objHash, int serverId) {
        MapPack param = new MapPack();
        param.put("objType", objType);
        param.put("objHash", (long)objHash);
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            List<Pack> list = tcp.process("OBJECT_ACTIVE_SERVICE_LIST", (Pack)param);
            return list;
        }
        catch (Exception e) {
            ConsoleProxy.errorSafe(e.toString());
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return null;
    }

    public static List<Pack> getBatchActiveList(String objType, int objHash, int serverId) {
        MapPack param = new MapPack();
        param.put("objType", objType);
        param.put("objHash", (long)objHash);
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            List<Pack> list = tcp.process("OBJECT_BATCH_ACTIVE_LIST", (Pack)param);
            return list;
        }
        catch (Exception e) {
            ConsoleProxy.errorSafe(e.toString());
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return null;
    }

    public static MapPack getThreadDetail(int objHash, long threadId, long txid, int serverId) {
        MapPack param = new MapPack();
        param.put("objHash", (long)objHash);
        param.put("id", threadId);
        param.put("txid", txid);
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            MapPack mapPack = (MapPack)tcp.getSingle("OBJECT_THREAD_DETAIL", (Pack)param);
            return mapPack;
        }
        catch (Exception e) {
            ConsoleProxy.errorSafe(e.toString());
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return null;
    }

    public static MapPack getEnv(int objHash, int serverId) {
        MapPack param = new MapPack();
        param.put("objHash", (long)objHash);
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        Server server = ServerManager.getInstance().getServer(serverId);
        param.put("userSession", server.getSession());
        param.put("userIp", tcp.getLocalInetAddress().getHostAddress());
        try {
            MapPack mapPack = (MapPack)tcp.getSingle("OBJECT_ENV", (Pack)param);
            return mapPack;
        }
        catch (Exception e) {
            ConsoleProxy.errorSafe(e.toString());
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return null;
    }

    public static MapPack getLoadedClassList(int objHash, int serverId) {
        MapPack param = new MapPack();
        param.put("objHash", (long)objHash);
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            MapPack mapPack = (MapPack)tcp.getSingle("OBJECT_CLASS_LIST", (Pack)param);
            return mapPack;
        }
        catch (Exception e) {
            ConsoleProxy.errorSafe(e.toString());
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return null;
    }

    public static void resetCache(int objHash, int serverId) {
        MapPack param = new MapPack();
        param.put("objHash", (long)objHash);
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            try {
                tcp.getSingle("OBJECT_RESET_CACHE", (Pack)param);
            }
            catch (Exception e) {
                ConsoleProxy.errorSafe(e.toString());
                TcpProxy.putTcpProxy(tcp);
            }
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
    }
}

