/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import scouter.client.model.AgentObject;
import scouter.client.model.TextProxy;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.server.ServerManager;
import scouter.io.DataInputX;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.ObjectPack;
import scouter.lang.value.ListValue;
import scouter.util.ThreadUtil;

public class AgentModelThread
extends Thread {
    private static AgentModelThread instance = null;
    private Map<Integer, AgentObject> agentMap = new HashMap<Integer, AgentObject>();
    ArrayList<ObjectPack> allAgentList = new ArrayList();
    private boolean existUnknownType;
    private Set<Integer> existServerset = new HashSet<Integer>();
    private boolean brun = true;

    public static final synchronized AgentModelThread getInstance() {
        if (instance == null) {
            instance = new AgentModelThread();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName((Thread)instance));
            instance.start();
        }
        return instance;
    }

    public ArrayList<ObjectPack> getAgentPackList() {
        return this.allAgentList;
    }

    @Override
    public void run() {
        while (this.brun) {
            this.fetchObjectList();
            int i = 0;
            while (i < 20 && this.brun) {
                ThreadUtil.sleep((long)100L);
                ++i;
            }
        }
    }

    public synchronized void fetchObjectList() {
        HashMap<Integer, AgentObject> tempAgentMap = new HashMap<Integer, AgentObject>();
        ArrayList objectPackList = new ArrayList();
        boolean existUnknownType = false;
        this.existServerset.clear();
        Set<Integer> serverIdSet = ServerManager.getInstance().getOpenServerList();
        if (serverIdSet.size() > 0) {
            Integer[] serverIds;
            Integer[] integerArray = serverIds = serverIdSet.toArray(new Integer[serverIdSet.size()]);
            int n = serverIds.length;
            int n2 = 0;
            while (n2 < n) {
                block12: {
                    int serverId = integerArray[n2];
                    CounterEngine counterEngine = ServerManager.getInstance().getServer(serverId).getCounterEngine();
                    TcpProxy proxy = TcpProxy.getTcpProxy(serverId);
                    try {
                        try {
                            final ArrayList agentList = new ArrayList();
                            proxy.process("OBJECT_LIST_REAL_TIME", null, new INetReader(){

                                @Override
                                public void process(DataInputX in) throws IOException {
                                    ObjectPack o = (ObjectPack)in.readPack();
                                    agentList.add(o);
                                }
                            });
                            objectPackList.addAll(agentList);
                            int i = 0;
                            while (agentList != null && i < agentList.size()) {
                                AgentObject oldAgent;
                                ObjectPack m = (ObjectPack)agentList.get(i);
                                String objType = m.objType;
                                int objHash = m.objHash;
                                String objName = m.objName;
                                if (TextProxy.object.getText(objHash) == null) {
                                    TextProxy.object.putText(objHash, objName);
                                }
                                if (!tempAgentMap.containsKey(objHash) || !(oldAgent = (AgentObject)tempAgentMap.get(objHash)).isAlive()) {
                                    AgentObject agentObject = new AgentObject(objType, objHash, objName, serverId);
                                    tempAgentMap.put(objHash, agentObject);
                                    agentObject.objPack = m;
                                    if (counterEngine.isUnknownObjectType(objType)) {
                                        existUnknownType = true;
                                    }
                                }
                                ++i;
                            }
                            if (agentList.size() > 0) {
                                this.existServerset.add(serverId);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(proxy);
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(proxy);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(proxy);
                }
                ++n2;
            }
        }
        this.allAgentList = objectPackList;
        this.agentMap = tempAgentMap;
        this.existUnknownType = existUnknownType;
    }

    public Set<Integer> existServerSet() {
        return this.existServerset;
    }

    public AgentObject getAgentObject(int objHash) {
        return this.agentMap.get(objHash);
    }

    public Map<Integer, AgentObject> getAgentObjectMap() {
        return this.agentMap;
    }

    public static void removeInactive() {
        Set<Integer> serverIdSet = ServerManager.getInstance().getOpenServerList();
        if (serverIdSet.size() > 0) {
            Integer[] serverIds;
            Integer[] integerArray = serverIds = serverIdSet.toArray(new Integer[serverIdSet.size()]);
            int n = serverIds.length;
            int n2 = 0;
            while (n2 < n) {
                int serverId = integerArray[n2];
                TcpProxy proxy = TcpProxy.getTcpProxy(serverId);
                try {
                    proxy.process("OBJECT_REMOVE_INACTIVE", null);
                }
                finally {
                    TcpProxy.putTcpProxy(proxy);
                }
                ++n2;
            }
        }
    }

    public Set<AgentObject> getAgentObjectByServerId(int serverId) {
        HashSet<AgentObject> set = new HashSet<AgentObject>();
        for (AgentObject obj : this.agentMap.values()) {
            if (serverId != obj.getServerId()) continue;
            set.add(obj);
        }
        return set;
    }

    public Set<Integer> getObjectSetByServerId(int serverId) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (AgentObject obj : this.agentMap.values()) {
            if (serverId != obj.getServerId()) continue;
            set.add(obj.objHash);
        }
        return set;
    }

    public AgentObject[] getObjectList() {
        return this.agentMap.values().toArray(new AgentObject[this.agentMap.size()]);
    }

    public Set<String> getCurrentObjTypeSet() {
        HashSet<String> typeSet = new HashSet<String>();
        Iterator<Integer> keys = this.agentMap.keySet().iterator();
        while (keys.hasNext()) {
            AgentObject agent = this.agentMap.get(keys.next());
            typeSet.add(agent.getObjType());
        }
        return typeSet;
    }

    public boolean existUnknownType() {
        return this.existUnknownType;
    }

    public Set<Integer> getObjectList(String objType) {
        HashSet<Integer> set = new HashSet<Integer>();
        Iterator<Integer> keys = this.agentMap.keySet().iterator();
        while (keys.hasNext()) {
            AgentObject agent = this.agentMap.get(keys.next());
            if (!objType.equals(agent.getObjType())) continue;
            set.add(agent.getObjHash());
        }
        return set;
    }

    public String getLiveObjectHashString(int serverId, String objType) {
        StringBuilder sb = new StringBuilder();
        Iterator<Integer> keys = this.agentMap.keySet().iterator();
        boolean first = true;
        while (keys.hasNext()) {
            AgentObject agent = this.agentMap.get(keys.next());
            if (serverId != agent.getServerId() || !agent.isAlive() || !objType.equals(agent.getObjType())) continue;
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(agent.getObjHash());
        }
        return sb.toString();
    }

    public String getLiveObjectHashStringWithParent(int serverId, String objType) {
        StringBuilder sb = new StringBuilder();
        Iterator<Integer> keys = this.agentMap.keySet().iterator();
        boolean first = true;
        while (keys.hasNext()) {
            String parentName;
            AgentObject agent = this.agentMap.get(keys.next());
            if (serverId != agent.getServerId() || !agent.isAlive() || !objType.equals(agent.getObjType())) continue;
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(agent.getObjHash());
            String string = parentName = agent.getObjName().contains("/") ? agent.getObjName().substring(0, agent.getObjName().indexOf("/", 1)) : null;
            if (parentName == null) continue;
            this.agentMap.values().stream().filter(anyAgent -> anyAgent.getObjName().equals(parentName)).findFirst().ifPresent(parent -> sb.append(',').append(parent.getObjHash()));
        }
        return sb.toString();
    }

    public ListValue getLiveObjHashLV(int serverId, String objType) {
        ListValue lv = new ListValue();
        for (AgentObject obj : this.agentMap.values()) {
            if (serverId != obj.getServerId() || !obj.isAlive() || !objType.equals(obj.getObjType())) continue;
            lv.add((long)obj.objHash);
        }
        return lv;
    }

    public Set<String> getCurrentObjectTypeList(int serverId) {
        TreeSet<String> objectTypeList = new TreeSet<String>();
        for (AgentObject agent : this.agentMap.values()) {
            if (agent.getServerId() != serverId) continue;
            String objType = agent.getObjType();
            objectTypeList.add(objType);
        }
        return objectTypeList;
    }

    public boolean existFamilyType(int serverId, String family) {
        CounterEngine engine = ServerManager.getInstance().getServer(serverId).getCounterEngine();
        for (AgentObject agent : this.agentMap.values()) {
            if (agent.getServerId() != serverId || !engine.isChildOf(agent.getObjType(), family)) continue;
            return true;
        }
        return false;
    }

    public void shutdown() {
        this.brun = false;
    }
}

