/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.model;

import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import scouter.client.model.AgentColorManager;
import scouter.client.model.HierarchyObject;
import scouter.lang.pack.ObjectPack;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.StringUtil;

public class AgentObject
extends HierarchyObject {
    private String objType;
    protected int objHash;
    protected String objName;
    private Color color;
    private String displayName;
    protected ObjectPack objPack;
    private int activeCounterInt = 0;
    private int serverId;

    public AgentObject(String objType, int objHash, String objName, int serverId) {
        this.objType = objType;
        this.objHash = objHash;
        this.objName = objName;
        this.color = AgentColorManager.getInstance().assignColor(objType, objHash);
        this.serverId = serverId;
        String[] objPaths = StringUtil.tokenizer((String)objName, (String)"/");
        this.displayName = objPaths[objPaths.length - 1];
    }

    public AgentObject(AgentObject another) {
        this.objType = another.getObjType();
        this.objHash = another.getObjHash();
        this.objName = another.getObjName();
        this.color = another.getColor();
        this.serverId = another.getServerId();
        this.displayName = another.getDisplayName();
        this.objPack = another.getSpec();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public String getObjType() {
        return this.objType;
    }

    public void setObjType(String objType) {
        this.objType = objType;
    }

    public void setObjHash(int objHash) {
        this.objHash = objHash;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public int getObjHash() {
        return this.objHash;
    }

    public String getObjName() {
        return this.objName;
    }

    public boolean isAlive() {
        if (this.objPack == null) {
            return false;
        }
        return this.objPack.alive;
    }

    @Override
    public String toString() {
        return this.getObjName();
    }

    public ObjectPack getSpec() {
        return this.objPack;
    }

    public Value getMasterCounter() {
        if (this.objPack == null) {
            return null;
        }
        return this.objPack.tags.get("counter");
    }

    public int getActiveCounterInt() {
        if (this.objPack == null) {
            return this.activeCounterInt;
        }
        Value v = this.objPack.tags.get("counter");
        if (v instanceof Number) {
            this.activeCounterInt = CastUtil.cint((Object)v);
            return this.activeCounterInt;
        }
        return this.activeCounterInt;
    }

    public void setSpec(ObjectPack objPack) {
        this.objPack = objPack;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.objHash;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgentObject other = (AgentObject)obj;
        return this.objHash == other.objHash;
    }

    public int getServerId() {
        return this.serverId;
    }

    public void setChildMap(Map<String, HierarchyObject> childMap) {
        Set<String> keys = childMap.keySet();
        for (String key : keys) {
            HierarchyObject value = childMap.get(key);
            value.setParent(this);
            super.putChild(key, value);
        }
    }

    @Override
    public String getName() {
        return this.getObjName();
    }
}

