/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class CounterColorManager {
    private static CounterColorManager instance;
    private Map<String, Color> assignedColor = new HashMap<String, Color>();
    static RGB[] default_rgb_map;

    static {
        default_rgb_map = new RGB[]{new RGB(55, 78, 179), new RGB(5, 128, 100), new RGB(55, 178, 180), new RGB(105, 128, 181), new RGB(156, 128, 163), new RGB(157, 178, 182), new RGB(105, 128, 203), new RGB(158, 128, 161), new RGB(1, 2, 222), new RGB(0, 128, 10), new RGB(101, 9, 251), new RGB(41, 121, 138), new RGB(11, 50, 249)};
    }

    public static synchronized CounterColorManager getInstance() {
        if (instance == null) {
            instance = new CounterColorManager();
        }
        return instance;
    }

    private CounterColorManager() {
    }

    public Color getColor(String name) {
        return this.assignedColor.get(name);
    }

    public Color assignColor(String name) {
        Color color = this.assignedColor.get(name);
        if (color != null) {
            return color;
        }
        color = this.searchAvaliableColor(default_rgb_map[this.assignedColor.size() % default_rgb_map.length]);
        this.assignedColor.put(name, color);
        return color;
    }

    private Color searchAvaliableColor(RGB rgb) {
        for (Color existColor : this.assignedColor.values()) {
            if (!existColor.getRGB().equals((Object)rgb)) continue;
            int[] rgbs = new int[]{rgb.red, rgb.green, rgb.blue};
            int rand = (int)(Math.random() * 3.0);
            rgbs[rand] = (rgbs[rand] + 1) % 256;
            return this.searchAvaliableColor(new RGB(rgbs[0], rgbs[1], rgbs[2]));
        }
        return new Color(null, rgb);
    }

    public String getName(RGB rgb) {
        for (String name : this.assignedColor.keySet()) {
            Color color = this.assignedColor.get(name);
            if (!color.getRGB().equals((Object)rgb)) continue;
            return name;
        }
        return null;
    }
}

